
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_Rate_Period">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Hourly"/>
 *     &lt;xs:enumeration value="Daily"/>
 *     &lt;xs:enumeration value="Weekly"/>
 *     &lt;xs:enumeration value="Monthly"/>
 *     &lt;xs:enumeration value="WeekendDay"/>
 *     &lt;xs:enumeration value="Other"/>
 *     &lt;xs:enumeration value="Package"/>
 *     &lt;xs:enumeration value="Bundle"/>
 *     &lt;xs:enumeration value="Total"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumRatePeriod implements Serializable {
    HOURLY("Hourly"), DAILY("Daily"), WEEKLY("Weekly"), MONTHLY("Monthly"), WEEKEND_DAY(
            "WeekendDay"), OTHER("Other"), /** 
                                            * The rate period is based on the package.
                                            */
    PACKAGE("Package"), /** 
                         * The rate is the same regardless of the number of days
                            the vehicle is rented
                        
                         */
    BUNDLE("Bundle"), /** 
                       * The rate is the total, no specific rate period.
                       */
    TOTAL("Total");
    private final String value;

    private EnumRatePeriod(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumRatePeriod convert(String value) {
        for (EnumRatePeriod inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
