
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_Relationships_Personal">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Spouse"/>
 *     &lt;xs:enumeration value="Parent"/>
 *     &lt;xs:enumeration value="Family"/>
 *     &lt;xs:enumeration value="Employer"/>
 *     &lt;xs:enumeration value="TravelCompanion"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumRelationshipsPersonal implements Serializable {
    SPOUSE("Spouse"), PARENT("Parent"), FAMILY("Family"), EMPLOYER("Employer"), TRAVEL_COMPANION(
            "TravelCompanion"), OTHER("Other");
    private final String value;

    private EnumRelationshipsPersonal(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumRelationshipsPersonal convert(String value) {
        for (EnumRelationshipsPersonal inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
