
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_StatusSpecialLeg">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Diverted"/>
 *     &lt;xs:enumeration value="AirReturn"/>
 *     &lt;xs:enumeration value="GroundReturn"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumStatusSpecialLeg implements Serializable {
    DIVERTED("Diverted"), AIR_RETURN("AirReturn"), GROUND_RETURN("GroundReturn"), OTHER(
            "Other");
    private final String value;

    private EnumStatusSpecialLeg(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumStatusSpecialLeg convert(String value) {
        for (EnumStatusSpecialLeg inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
