
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_WeightUnit">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Kilo"/>
 *     &lt;xs:enumeration value="Pounds"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumWeightUnit implements Serializable {
    KILO("Kilo"), POUNDS("Pounds");
    private final String value;

    private EnumWeightUnit(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumWeightUnit convert(String value) {
        for (EnumWeightUnit inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
