
package com.sabre.services.stl.v02;

import java.io.Serializable;
import org.opentravel.common.message.v02.ExtensionPointSummary;

/** 
 * Describes loyalty level, whether it is atpco level code, sabre code, ot vendor
 specified.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:ns1="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Loyalty">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Enum_TravelSector" name="TravelSector" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Vendor" minOccurs="0"/>
 *     &lt;xs:element type="ns:Loyalty_Level" name="Level" minOccurs="1"/>
 *     &lt;xs:element ref="ns1:ExtensionPoint_Summary" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Loyalty1 implements Serializable
{
    private EnumTravelSector travelSector;
    private String vendor;
    private LoyaltyLevel level;
    private ExtensionPointSummary extensionPointSummary;

    /** 
     * Get the 'TravelSector' element value. Used to identify the specific travel sector to which the loyalty program
                          applies. Refer to OTA Codelist Travel Sector (TVS).
                      Assigned XSD Type: {http://services.sabre.com/STL/v01}OTA_CodeType
                      
     * 
     * @return value
     */
    public EnumTravelSector getTravelSector() {
        return travelSector;
    }

    /** 
     * Set the 'TravelSector' element value. Used to identify the specific travel sector to which the loyalty program
                          applies. Refer to OTA Codelist Travel Sector (TVS).
                      Assigned XSD Type: {http://services.sabre.com/STL/v01}OTA_CodeType
                      
     * 
     * @param travelSector
     */
    public void setTravelSector(EnumTravelSector travelSector) {
        this.travelSector = travelSector;
    }

    /** 
     * Get the 'Vendor' element value. Identifier for the company owner of the loyalty program.Assigned XSD Type: {http://services.sabre.com/STL/v01}VendorCode
                      
     * 
     * @return value
     */
    public String getVendor() {
        return vendor;
    }

    /** 
     * Set the 'Vendor' element value. Identifier for the company owner of the loyalty program.Assigned XSD Type: {http://services.sabre.com/STL/v01}VendorCode
                      
     * 
     * @param vendor
     */
    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    /** 
     * Get the 'Level' element value.
     * 
     * @return value
     */
    public LoyaltyLevel getLevel() {
        return level;
    }

    /** 
     * Set the 'Level' element value.
     * 
     * @param level
     */
    public void setLevel(LoyaltyLevel level) {
        this.level = level;
    }

    /** 
     * Get the 'ExtensionPoint_Summary' element value.
     * 
     * @return value
     */
    public ExtensionPointSummary getExtensionPointSummary() {
        return extensionPointSummary;
    }

    /** 
     * Set the 'ExtensionPoint_Summary' element value.
     * 
     * @param extensionPointSummary
     */
    public void setExtensionPointSummary(
            ExtensionPointSummary extensionPointSummary) {
        this.extensionPointSummary = extensionPointSummary;
    }
}
