
package com.sabre.services.stl.v02;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opentravel.common.message.v02.ExtensionPointDetail;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:ns1="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Loyalty_Detail">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:Loyalty">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Partners" minOccurs="0" maxOccurs="100"/>
 *         &lt;xs:element type="xs:string" name="Notes" minOccurs="0"/>
 *         &lt;xs:element ref="ns1:ExtensionPoint_Detail" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LoyaltyDetail1 extends Loyalty1 implements Serializable
{
    private List<String> partnerList = new ArrayList<String>();
    private String notes;
    private ExtensionPointDetail extensionPointDetail;

    /** 
     * Get the list of 'Partners' element items. The partner(s)/vendor(s) for which the customer loyalty number is
                                  valid.
                              Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}StringLength1to128
                              
     * 
     * @return list
     */
    public List<String> getPartnerList() {
        return partnerList;
    }

    /** 
     * Set the list of 'Partners' element items. The partner(s)/vendor(s) for which the customer loyalty number is
                                  valid.
                              Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}StringLength1to128
                              
     * 
     * @param list
     */
    public void setPartnerList(List<String> list) {
        partnerList = list;
    }

    /** 
     * Get the 'Notes' element value.
     * 
     * @return value
     */
    public String getNotes() {
        return notes;
    }

    /** 
     * Set the 'Notes' element value.
     * 
     * @param notes
     */
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /** 
     * Get the 'ExtensionPoint_Detail' element value.
     * 
     * @return value
     */
    public ExtensionPointDetail getExtensionPointDetail() {
        return extensionPointDetail;
    }

    /** 
     * Set the 'ExtensionPoint_Detail' element value.
     * 
     * @param extensionPointDetail
     */
    public void setExtensionPointDetail(
            ExtensionPointDetail extensionPointDetail) {
        this.extensionPointDetail = extensionPointDetail;
    }
}
