
package com.sabre.services.stl.v02;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.opentravel.common.message.v02.ExtensionPointDetail;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:ns1="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Person_Name_Detail">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:Person_Name">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="Middle" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Source" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Prefix" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="PreferredFirstName" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="PreferredSurname" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="Suffix" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="AdditionalLastNames" minOccurs="0" maxOccurs="10"/>
 *         &lt;xs:element type="xs:string" name="AdditionalNames" minOccurs="0" maxOccurs="10"/>
 *         &lt;xs:element ref="ns1:ExtensionPoint_Detail" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="ns:Enum_NameType" use="optional" name="nameType"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="qualityWarningInd"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="shareMarketInd"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="shareSyncInd"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PersonNameDetail extends PersonName1 implements Serializable
{
    private String middle;
    private String source;
    private String prefix;
    private String preferredFirstName;
    private String preferredSurname;
    private String suffix;
    private List<String> additionalLastNameList = new ArrayList<String>();
    private List<String> additionalNameList = new ArrayList<String>();
    private ExtensionPointDetail extensionPointDetail;
    private EnumNameType nameType;
    private Boolean qualityWarningInd;
    private Boolean shareMarketInd;
    private Boolean shareSyncInd;

    /** 
     * Get the 'Middle' element value.
     * 
     * @return value
     */
    public String getMiddle() {
        return middle;
    }

    /** 
     * Set the 'Middle' element value.
     * 
     * @param middle
     */
    public void setMiddle(String middle) {
        this.middle = middle;
    }

    /** 
     * Get the 'Source' element value. Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}StringLength1to64
                              
     * 
     * @return value
     */
    public String getSource() {
        return source;
    }

    /** 
     * Set the 'Source' element value. Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}StringLength1to64
                              
     * 
     * @param source
     */
    public void setSource(String source) {
        this.source = source;
    }

    /** 
     * Get the 'Prefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss,
                                  Dr.)
                              Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}StringLength1to16
                              
     * 
     * @return value
     */
    public String getPrefix() {
        return prefix;
    }

    /** 
     * Set the 'Prefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss,
                                  Dr.)
                              Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}StringLength1to16
                              
     * 
     * @param prefix
     */
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    /** 
     * Get the 'PreferredFirstName' element value. Any preferred names for first name used instead of
                                  GivenName
                              Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}ProperName
                              
     * 
     * @return value
     */
    public String getPreferredFirstName() {
        return preferredFirstName;
    }

    /** 
     * Set the 'PreferredFirstName' element value. Any preferred names for first name used instead of
                                  GivenName
                              Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}ProperName
                              
     * 
     * @param preferredFirstName
     */
    public void setPreferredFirstName(String preferredFirstName) {
        this.preferredFirstName = preferredFirstName;
    }

    /** 
     * Get the 'PreferredSurname' element value. Any preferred names for last names used instead of
                                  surname
                              Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}ProperName
                              
     * 
     * @return value
     */
    public String getPreferredSurname() {
        return preferredSurname;
    }

    /** 
     * Set the 'PreferredSurname' element value. Any preferred names for last names used instead of
                                  surname
                              Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}ProperName
                              
     * 
     * @param preferredSurname
     */
    public void setPreferredSurname(String preferredSurname) {
        this.preferredSurname = preferredSurname;
    }

    /** 
     * Get the 'Suffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr.,
                                  III, Ret., Esq.).
                              Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}StringLength1to16
                              
     * 
     * @return value
     */
    public String getSuffix() {
        return suffix;
    }

    /** 
     * Set the 'Suffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr.,
                                  III, Ret., Esq.).
                              Assigned XSD Type:
                                  {http://services.sabre.com/STL/v01}StringLength1to16
                              
     * 
     * @param suffix
     */
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    /** 
     * Get the list of 'AdditionalLastNames' element items. Additional last names not used in travel documents.
     * 
     * @return list
     */
    public List<String> getAdditionalLastNameList() {
        return additionalLastNameList;
    }

    /** 
     * Set the list of 'AdditionalLastNames' element items. Additional last names not used in travel documents.
     * 
     * @param list
     */
    public void setAdditionalLastNameList(List<String> list) {
        additionalLastNameList = list;
    }

    /** 
     * Get the list of 'AdditionalNames' element items. Additional first or middle names not used in travel
                                  documents.
                              
     * 
     * @return list
     */
    public List<String> getAdditionalNameList() {
        return additionalNameList;
    }

    /** 
     * Set the list of 'AdditionalNames' element items. Additional first or middle names not used in travel
                                  documents.
                              
     * 
     * @param list
     */
    public void setAdditionalNameList(List<String> list) {
        additionalNameList = list;
    }

    /** 
     * Get the 'ExtensionPoint_Detail' element value.
     * 
     * @return value
     */
    public ExtensionPointDetail getExtensionPointDetail() {
        return extensionPointDetail;
    }

    /** 
     * Set the 'ExtensionPoint_Detail' element value.
     * 
     * @param extensionPointDetail
     */
    public void setExtensionPointDetail(
            ExtensionPointDetail extensionPointDetail) {
        this.extensionPointDetail = extensionPointDetail;
    }

    /** 
     * Get the 'nameType' attribute value. If not specified this is the person's current name.Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to64
                          
     * 
     * @return value
     */
    public EnumNameType getNameType() {
        return nameType;
    }

    /** 
     * Set the 'nameType' attribute value. If not specified this is the person's current name.Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to64
                          
     * 
     * @param nameType
     */
    public void setNameType(EnumNameType nameType) {
        this.nameType = nameType;
    }

    /** 
     * Get the 'qualityWarningInd' attribute value. qualityWarningInd is the quality indicator for the
                              parsed name data. If true there were parsing warnings or errors
                              detected during the parsing of the nameString into the name tokens
                              stored in the elements of this record.
                          
     * 
     * @return value
     */
    public Boolean getQualityWarningInd() {
        return qualityWarningInd;
    }

    /** 
     * Set the 'qualityWarningInd' attribute value. qualityWarningInd is the quality indicator for the
                              parsed name data. If true there were parsing warnings or errors
                              detected during the parsing of the nameString into the name tokens
                              stored in the elements of this record.
                          
     * 
     * @param qualityWarningInd
     */
    public void setQualityWarningInd(Boolean qualityWarningInd) {
        this.qualityWarningInd = qualityWarningInd;
    }

    /** 
     * Get the 'shareMarketInd' attribute value. If present and true, sharing is enabled and overiding
                              on any previous setting.
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ShareIndicator
                          
     * 
     * @return value
     */
    public Boolean getShareMarketInd() {
        return shareMarketInd;
    }

    /** 
     * Set the 'shareMarketInd' attribute value. If present and true, sharing is enabled and overiding
                              on any previous setting.
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ShareIndicator
                          
     * 
     * @param shareMarketInd
     */
    public void setShareMarketInd(Boolean shareMarketInd) {
        this.shareMarketInd = shareMarketInd;
    }

    /** 
     * Get the 'shareSyncInd' attribute value. If present and true, sharing is enabled and overiding
                              on any previous setting.
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ShareIndicator
                          
     * 
     * @return value
     */
    public Boolean getShareSyncInd() {
        return shareSyncInd;
    }

    /** 
     * Set the 'shareSyncInd' attribute value. If present and true, sharing is enabled and overiding
                              on any previous setting.
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ShareIndicator
                          
     * 
     * @param shareSyncInd
     */
    public void setShareSyncInd(Boolean shareSyncInd) {
        this.shareSyncInd = shareSyncInd;
    }
}
