
package com.sabre.services.stl.v02;

import java.io.Serializable;
import org.opentravel.common.message.v02.ExtensionPointSummary;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:ns1="http://opentravel.org/common/message/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Phone">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CountryCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="AreaCode" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Number" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Extension" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element ref="ns1:ExtensionPoint_Summary" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns:Enum_PhoneRole_Base" name="role"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Phone1 implements Serializable
{
    private String countryCode;
    private String areaCode;
    private String number;
    private String extension;
    private ExtensionPointSummary extensionPointSummary;
    private EnumPhoneRoleBase role;

    /** 
     * Get the 'CountryCode' element value. Country code portion of the number.
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. Country code portion of the number.
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'AreaCode' element value. Area code portion of the number
     * 
     * @return value
     */
    public String getAreaCode() {
        return areaCode;
    }

    /** 
     * Set the 'AreaCode' element value. Area code portion of the number
     * 
     * @param areaCode
     */
    public void setAreaCode(String areaCode) {
        this.areaCode = areaCode;
    }

    /** 
     * Get the 'Number' element value. The actual number
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' element value. The actual number
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /** 
     * Get the 'Extension' element value. Optional extension suffix
     * 
     * @return value
     */
    public String getExtension() {
        return extension;
    }

    /** 
     * Set the 'Extension' element value. Optional extension suffix
     * 
     * @param extension
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }

    /** 
     * Get the 'ExtensionPoint_Summary' element value.
     * 
     * @return value
     */
    public ExtensionPointSummary getExtensionPointSummary() {
        return extensionPointSummary;
    }

    /** 
     * Set the 'ExtensionPoint_Summary' element value.
     * 
     * @param extensionPointSummary
     */
    public void setExtensionPointSummary(
            ExtensionPointSummary extensionPointSummary) {
        this.extensionPointSummary = extensionPointSummary;
    }

    /** 
     * Get the 'role' attribute value.
     * 
     * @return value
     */
    public EnumPhoneRoleBase getRole() {
        return role;
    }

    /** 
     * Set the 'role' attribute value.
     * 
     * @param role
     */
    public void setRole(EnumPhoneRoleBase role) {
        this.role = role;
    }
}
