
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Assigned XSD Type:
 {http://services.sabre.com/STL/v01}ProperName

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Street">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="streetNmbrSuffix"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="streetDirection"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="ruralRouteNmbr"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="pO_Box"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Street implements Serializable
{
    private String string;
    private String streetNmbrSuffix;
    private String streetDirection;
    private String ruralRouteNmbr;
    private String POBox;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'streetNmbrSuffix' attribute value. Usually a letter right after the street number (A in
                              66-A, B in 123-B etc).
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to8
                          
     * 
     * @return value
     */
    public String getStreetNmbrSuffix() {
        return streetNmbrSuffix;
    }

    /** 
     * Set the 'streetNmbrSuffix' attribute value. Usually a letter right after the street number (A in
                              66-A, B in 123-B etc).
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to8
                          
     * 
     * @param streetNmbrSuffix
     */
    public void setStreetNmbrSuffix(String streetNmbrSuffix) {
        this.streetNmbrSuffix = streetNmbrSuffix;
    }

    /** 
     * Get the 'streetDirection' attribute value. Street direction of an address (e.g., N, E, S, NW, SW).Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to8
                          
     * 
     * @return value
     */
    public String getStreetDirection() {
        return streetDirection;
    }

    /** 
     * Set the 'streetDirection' attribute value. Street direction of an address (e.g., N, E, S, NW, SW).Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to8
                          
     * 
     * @param streetDirection
     */
    public void setStreetDirection(String streetDirection) {
        this.streetDirection = streetDirection;
    }

    /** 
     * Get the 'ruralRouteNmbr' attribute value. Numerical equivalent of a rural township as defined
                              within a given area (e.g., 12, 99).
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}NumericStringLength1to5
                          
     * 
     * @return value
     */
    public String getRuralRouteNmbr() {
        return ruralRouteNmbr;
    }

    /** 
     * Set the 'ruralRouteNmbr' attribute value. Numerical equivalent of a rural township as defined
                              within a given area (e.g., 12, 99).
                          Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}NumericStringLength1to5
                          
     * 
     * @param ruralRouteNmbr
     */
    public void setRuralRouteNmbr(String ruralRouteNmbr) {
        this.ruralRouteNmbr = ruralRouteNmbr;
    }

    /** 
     * Get the 'pO_Box' attribute value. Defines a Post Office Box number.Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to16
                          
     * 
     * @return value
     */
    public String getPOBox() {
        return POBox;
    }

    /** 
     * Set the 'pO_Box' attribute value. Defines a Post Office Box number.Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}StringLength1to16
                          
     * 
     * @param pOBox
     */
    public void setPOBox(String pOBox) {
        POBox = pOBox;
    }
}
