
package com.sabre.services.stl.v02;

import java.io.Serializable;

/** 
 * Assigned XSD Type:
 {http://services.sabre.com/STL/v01}VendorCode

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="name"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="codeContext"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="division"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="department"/>
 *       &lt;xs:attribute type="ns:Enum_TravelSector" use="optional" name="travelSector"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Vendor implements Serializable
{
    private String string;
    private String name;
    private String codeContext;
    private String division;
    private String department;
    private EnumTravelSector travelSector;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'name' attribute value. Full Name of a vendorAssigned XSD Type:
                              {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @return value
     */
    public String getName() {
        return name;
    }

    /** 
     * Set the 'name' attribute value. Full Name of a vendorAssigned XSD Type:
                              {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @param name
     */
    public void setName(String name) {
        this.name = name;
    }

    /** 
     * Get the 'codeContext' attribute value. Identifies the context of the identifying code, such as
                              DUNS, IATA or internal code, etc.
                          
     * 
     * @return value
     */
    public String getCodeContext() {
        return codeContext;
    }

    /** 
     * Set the 'codeContext' attribute value. Identifies the context of the identifying code, such as
                              DUNS, IATA or internal code, etc.
                          
     * 
     * @param codeContext
     */
    public void setCodeContext(String codeContext) {
        this.codeContext = codeContext;
    }

    /** 
     * Get the 'division' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @return value
     */
    public String getDivision() {
        return division;
    }

    /** 
     * Set the 'division' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @param division
     */
    public void setDivision(String division) {
        this.division = division;
    }

    /** 
     * Get the 'department' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @return value
     */
    public String getDepartment() {
        return department;
    }

    /** 
     * Set the 'department' attribute value. Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @param department
     */
    public void setDepartment(String department) {
        this.department = department;
    }

    /** 
     * Get the 'travelSector' attribute value. Describes which sector vendor belongs to.Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}TravelSectorType
                          
     * 
     * @return value
     */
    public EnumTravelSector getTravelSector() {
        return travelSector;
    }

    /** 
     * Set the 'travelSector' attribute value. Describes which sector vendor belongs to.Assigned XSD Type:
                              {http://services.sabre.com/STL/v01}TravelSectorType
                          
     * 
     * @param travelSector
     */
    public void setTravelSector(EnumTravelSector travelSector) {
        this.travelSector = travelSector;
    }
}
