
package com.sabre.services.stlheader.v120;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL_Header/v120" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Diagnostics">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DiagnosticLevels" name="Level" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Data" minOccurs="0"/>
 *     &lt;xs:element type="ns:DiagnosticResults" name="Diagnostic" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Diagnostics implements Serializable
{
    private DiagnosticLevels level;
    private String data;
    private DiagnosticResults diagnostic;

    /** 
     * Get the 'Level' element value. Describes the level of diagnostic data requested or provided.
     * 
     * @return value
     */
    public DiagnosticLevels getLevel() {
        return level;
    }

    /** 
     * Set the 'Level' element value. Describes the level of diagnostic data requested or provided.
     * 
     * @param level
     */
    public void setLevel(DiagnosticLevels level) {
        this.level = level;
    }

    /** 
     * Get the 'Data' element value. Block of diagnostic data included in request or returned in the response.
     * 
     * @return value
     */
    public String getData() {
        return data;
    }

    /** 
     * Set the 'Data' element value. Block of diagnostic data included in request or returned in the response.
     * 
     * @param data
     */
    public void setData(String data) {
        this.data = data;
    }

    /** 
     * Get the 'Diagnostic' element value. Diagnostic data. Must be defined in a differrent namespace as the header.
     * 
     * @return value
     */
    public DiagnosticResults getDiagnostic() {
        return diagnostic;
    }

    /** 
     * Set the 'Diagnostic' element value. Diagnostic data. Must be defined in a differrent namespace as the header.
     * 
     * @param diagnostic
     */
    public void setDiagnostic(DiagnosticResults diagnostic) {
        this.diagnostic = diagnostic;
    }
}
