
package com.sabre.services.stlheader.v120;

import java.io.Serializable;
import java.util.Date;

/** 
 * The Identification metadata uniquely identify each message instance.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL_Header/v120" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Identification">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CustomerID" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CustomerAppID" minOccurs="0"/>
 *     &lt;xs:element type="ns:TrackingID" name="ConversationID" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MessageID" minOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="TimeStamp" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Identification implements Serializable
{
    private String customerID;
    private String customerAppID;
    private TrackingID conversationID;
    private String messageID;
    private Date timeStamp;

    /** 
     * Get the 'CustomerID' element value.
     * 
     * @return value
     */
    public String getCustomerID() {
        return customerID;
    }

    /** 
     * Set the 'CustomerID' element value.
     * 
     * @param customerID
     */
    public void setCustomerID(String customerID) {
        this.customerID = customerID;
    }

    /** 
     * Get the 'CustomerAppID' element value.
     * 
     * @return value
     */
    public String getCustomerAppID() {
        return customerAppID;
    }

    /** 
     * Set the 'CustomerAppID' element value.
     * 
     * @param customerAppID
     */
    public void setCustomerAppID(String customerAppID) {
        this.customerAppID = customerAppID;
    }

    /** 
     * Get the 'ConversationID' element value. 
    					The ConversationId element is a string identifying the set of related messages that make up a
    					conversation between two or more Parties. The Party initiating a conversation determines the value of
    					the ConversationId element that shall be reflected in all messages pertaining to that
    					conversation. It remains constant for all messages within a conversation.
    					Service providers are expected to increment the optional TrackingID integer attribute when present.
    				
     * 
     * @return value
     */
    public TrackingID getConversationID() {
        return conversationID;
    }

    /** 
     * Set the 'ConversationID' element value. 
    					The ConversationId element is a string identifying the set of related messages that make up a
    					conversation between two or more Parties. The Party initiating a conversation determines the value of
    					the ConversationId element that shall be reflected in all messages pertaining to that
    					conversation. It remains constant for all messages within a conversation.
    					Service providers are expected to increment the optional TrackingID integer attribute when present.
    				
     * 
     * @param conversationID
     */
    public void setConversationID(TrackingID conversationID) {
        this.conversationID = conversationID;
    }

    /** 
     * Get the 'MessageID' element value.
     * 
     * @return value
     */
    public String getMessageID() {
        return messageID;
    }

    /** 
     * Set the 'MessageID' element value.
     * 
     * @param messageID
     */
    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    /** 
     * Get the 'TimeStamp' element value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'TimeStamp' element value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }
}
