
package com.sabre.services.stlheader.v120;

import java.io.Serializable;

/** 
 * System identifier used to uniquily identify the specific system.
 "Source" is used to return the application name responsible for fulfilling the particular request transaction.
 "ApplicationInstance" is used to return the application instance responsible for fulfilling the particular request transaction.
 "Cluster" is used to return the application cluster responsible for fulfilling the particular request transaction.
 "HostName" is used to return the particular server name responsible for fulfilling the particular request transaction.
  Example: Source ApplicationInstance="PROD1" Cluster="PROD TPF SCC" HostName="PSS" TPF Source

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL_Header/v120" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Identifier.System">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" name="instance"/>
 *       &lt;xs:attribute type="xs:string" name="cluster"/>
 *       &lt;xs:attribute type="xs:string" name="host"/>
 *       &lt;xs:attribute type="xs:string" name="uri"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class IdentifierSystem implements Serializable
{
    private String string;
    private String instance;
    private String cluster;
    private String host;
    private String uri;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'instance' attribute value.
     * 
     * @return value
     */
    public String getInstance() {
        return instance;
    }

    /** 
     * Set the 'instance' attribute value.
     * 
     * @param instance
     */
    public void setInstance(String instance) {
        this.instance = instance;
    }

    /** 
     * Get the 'cluster' attribute value.
     * 
     * @return value
     */
    public String getCluster() {
        return cluster;
    }

    /** 
     * Set the 'cluster' attribute value.
     * 
     * @param cluster
     */
    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    /** 
     * Get the 'host' attribute value.
     * 
     * @return value
     */
    public String getHost() {
        return host;
    }

    /** 
     * Set the 'host' attribute value.
     * 
     * @param host
     */
    public void setHost(String host) {
        this.host = host;
    }

    /** 
     * Get the 'uri' attribute value. The uri representing the endpoint reference by which this system can be accessed.
    					
     * 
     * @return value
     */
    public String getUri() {
        return uri;
    }

    /** 
     * Set the 'uri' attribute value. The uri representing the endpoint reference by which this system can be accessed.
    					
     * 
     * @param uri
     */
    public void setUri(String uri) {
        this.uri = uri;
    }
}
