
package com.sabre.services.stlheader.v120;

import java.io.Serializable;
import java.util.Date;

/** 
 * Record for all systems (consumer, proxies and gateways, providers) to use to trace the message. 
 The value is the common system name. 

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL_Header/v120" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TraceRecord">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" name="key"/>
 *       &lt;xs:attribute type="xs:dateTime" use="required" name="start"/>
 *       &lt;xs:attribute type="xs:dateTime" name="end"/>
 *       &lt;xs:attribute type="xs:string" name="appInstance"/>
 *       &lt;xs:attribute type="xs:string" name="cluster"/>
 *       &lt;xs:attribute type="xs:string" name="host"/>
 *       &lt;xs:attribute type="xs:string" name="targetURI"/>
 *       &lt;xs:attribute type="ns:TraceRole" name="role"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TraceRecord implements Serializable
{
    private String string;
    private String key;
    private Date start;
    private Date end;
    private String appInstance;
    private String cluster;
    private String host;
    private String targetURI;
    private TraceRole role;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'key' attribute value. 
    						The key attribute is similar to ConversationID but is provided by the service requestor or entrypoint gateway and 
    						must be unique across all Sabre gateways. Each gateway instance must prepend the ID value with its unique system identifier. 
    						Internal service consumers must provide this value which may be their unique system identifier concantanated 
    						with the ConversationID.
    					
     * 
     * @return value
     */
    public String getKey() {
        return key;
    }

    /** 
     * Set the 'key' attribute value. 
    						The key attribute is similar to ConversationID but is provided by the service requestor or entrypoint gateway and 
    						must be unique across all Sabre gateways. Each gateway instance must prepend the ID value with its unique system identifier. 
    						Internal service consumers must provide this value which may be their unique system identifier concantanated 
    						with the ConversationID.
    					
     * 
     * @param key
     */
    public void setKey(String key) {
        this.key = key;
    }

    /** 
     * Get the 'start' attribute value. When the system stated processing the message.
     * 
     * @return value
     */
    public Date getStart() {
        return start;
    }

    /** 
     * Set the 'start' attribute value. When the system stated processing the message.
     * 
     * @param start
     */
    public void setStart(Date start) {
        this.start = start;
    }

    /** 
     * Get the 'end' attribute value. When the system completed processing the message. 
    					Example: 2002-10-10T12:00:00+05:00.
    					
     * 
     * @return value
     */
    public Date getEnd() {
        return end;
    }

    /** 
     * Set the 'end' attribute value. When the system completed processing the message. 
    					Example: 2002-10-10T12:00:00+05:00.
    					
     * 
     * @param end
     */
    public void setEnd(Date end) {
        this.end = end;
    }

    /** 
     * Get the 'appInstance' attribute value. The application instance involved in the particular transaction. 
    					For example: PROD1
    					
     * 
     * @return value
     */
    public String getAppInstance() {
        return appInstance;
    }

    /** 
     * Set the 'appInstance' attribute value. The application instance involved in the particular transaction. 
    					For example: PROD1
    					
     * 
     * @param appInstance
     */
    public void setAppInstance(String appInstance) {
        this.appInstance = appInstance;
    }

    /** 
     * Get the 'cluster' attribute value. The application server cluster involved in the particular transaction. 
    					Example: PROD TPFC SCC
    					
     * 
     * @return value
     */
    public String getCluster() {
        return cluster;
    }

    /** 
     * Set the 'cluster' attribute value. The application server cluster involved in the particular transaction. 
    					Example: PROD TPFC SCC
    					
     * 
     * @param cluster
     */
    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    /** 
     * Get the 'host' attribute value. The server name involved in the particular transaction. 
    					Example: PSS
    					
     * 
     * @return value
     */
    public String getHost() {
        return host;
    }

    /** 
     * Set the 'host' attribute value. The server name involved in the particular transaction. 
    					Example: PSS
    					
     * 
     * @param host
     */
    public void setHost(String host) {
        this.host = host;
    }

    /** 
     * Get the 'targetURI' attribute value. The targetURI is the endpoint address this system sent the message to. 
    					For ServiceProviders it should be the abstract service address which is the address used by 
    					registries to look up the actual service endpoint URI. The endpoint address may be a queue
    					name (MOM service name).
    					
     * 
     * @return value
     */
    public String getTargetURI() {
        return targetURI;
    }

    /** 
     * Set the 'targetURI' attribute value. The targetURI is the endpoint address this system sent the message to. 
    					For ServiceProviders it should be the abstract service address which is the address used by 
    					registries to look up the actual service endpoint URI. The endpoint address may be a queue
    					name (MOM service name).
    					
     * 
     * @param targetURI
     */
    public void setTargetURI(String targetURI) {
        this.targetURI = targetURI;
    }

    /** 
     * Get the 'role' attribute value.
     * 
     * @return value
     */
    public TraceRole getRole() {
        return role;
    }

    /** 
     * Set the 'role' attribute value.
     * 
     * @param role
     */
    public void setRole(TraceRole role) {
        this.role = role;
    }
}
