
package com.sabre.services.stlheader.v120;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://services.sabre.com/STL_Header/v120" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TraceRole">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="consumer"/>
 *     &lt;xs:enumeration value="provider"/>
 *     &lt;xs:enumeration value="gateway"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum TraceRole implements Serializable {
    /** 
     * the system that initiated the service request and will be the ultimate consumer 
    of the service results.
    
     */
    CONSUMER("consumer"), /** 
                           * System that performs the service operation defined in the service interface. 
                          For RQ/RS exchange patterns, the provider reads the request message, applies business logic and 
                          returns a response.
                          
                           */
    PROVIDER("provider"), GATEWAY("gateway");
    private final String value;

    private TraceRole(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static TraceRole convert(String value) {
        for (TraceRole inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
