
package com.sabre.services.stlpayload.v0201;

import com.sabre.services.stlmessagecommon.v0201.CompletionCodes;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL_MessageCommon/v02_01" xmlns:ns1="http://services.sabre.com/STL_Payload/v02_01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ApplicationResults">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns1:Results">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns1:ProblemInformation" name="Success" minOccurs="0" maxOccurs="99"/>
 *         &lt;xs:element type="ns1:ProblemInformation" name="Error" minOccurs="0" maxOccurs="99"/>
 *         &lt;xs:element type="ns1:ProblemInformation" name="Warning" minOccurs="0" maxOccurs="99"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="ns:CompletionCodes" use="required" name="status"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ApplicationResults extends Results1 implements Serializable
{
    private List<ProblemInformation> successList = new ArrayList<ProblemInformation>();
    private List<ProblemInformation> errorList = new ArrayList<ProblemInformation>();
    private List<ProblemInformation> warningList = new ArrayList<ProblemInformation>();
    private CompletionCodes status;

    /** 
     * Get the list of 'Success' element items.
     * 
     * @return list
     */
    public List<ProblemInformation> getSuccessList() {
        return successList;
    }

    /** 
     * Set the list of 'Success' element items.
     * 
     * @param list
     */
    public void setSuccessList(List<ProblemInformation> list) {
        successList = list;
    }

    /** 
     * Get the list of 'Error' element items.
     * 
     * @return list
     */
    public List<ProblemInformation> getErrorList() {
        return errorList;
    }

    /** 
     * Set the list of 'Error' element items.
     * 
     * @param list
     */
    public void setErrorList(List<ProblemInformation> list) {
        errorList = list;
    }

    /** 
     * Get the list of 'Warning' element items.
     * 
     * @return list
     */
    public List<ProblemInformation> getWarningList() {
        return warningList;
    }

    /** 
     * Set the list of 'Warning' element items.
     * 
     * @param list
     */
    public void setWarningList(List<ProblemInformation> list) {
        warningList = list;
    }

    /** 
     * Get the 'status' attribute value.
     * 
     * @return value
     */
    public CompletionCodes getStatus() {
        return status;
    }

    /** 
     * Set the 'status' attribute value.
     * 
     * @param status
     */
    public void setStatus(CompletionCodes status) {
        this.status = status;
    }
}
