
package com.sabre.services.stlpayload.v0201;

import com.sabre.services.stlmessagecommon.v0201.MessageCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL_MessageCommon/v02_01" xmlns:ns1="http://services.sabre.com/STL_Payload/v02_01" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SystemSpecificResults">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns1:HostCommand" name="HostCommand" minOccurs="0"/>
 *     &lt;xs:element type="ns:Message.Condition" name="Message" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:string" name="ShortText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Element" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RecordID" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DocURL" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:dateTime" name="timeStamp"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="reference"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SystemSpecificResults implements Serializable
{
    private HostCommand hostCommand;
    private List<MessageCondition> messageList = new ArrayList<MessageCondition>();
    private String shortText;
    private String element;
    private String recordID;
    private String docURL;
    private Date timeStamp;
    private String reference;

    /** 
     * Get the 'HostCommand' element value. Host system command run to create this result.
     * 
     * @return value
     */
    public HostCommand getHostCommand() {
        return hostCommand;
    }

    /** 
     * Set the 'HostCommand' element value. Host system command run to create this result.
     * 
     * @param hostCommand
     */
    public void setHostCommand(HostCommand hostCommand) {
        this.hostCommand = hostCommand;
    }

    /** 
     * Get the list of 'Message' element items. Application specific code and Message. A textual description to provide more 
    				information about the specific condition, warning or error  with code attribute as numeric value.
    				
     * 
     * @return list
     */
    public List<MessageCondition> getMessageList() {
        return messageList;
    }

    /** 
     * Set the list of 'Message' element items. Application specific code and Message. A textual description to provide more 
    				information about the specific condition, warning or error  with code attribute as numeric value.
    				
     * 
     * @param list
     */
    public void setMessageList(List<MessageCondition> list) {
        messageList = list;
    }

    /** 
     * Get the 'ShortText' element value. An abbreviated version of the error in textual format.
     * 
     * @return value
     */
    public String getShortText() {
        return shortText;
    }

    /** 
     * Set the 'ShortText' element value. An abbreviated version of the error in textual format.
     * 
     * @param shortText
     */
    public void setShortText(String shortText) {
        this.shortText = shortText;
    }

    /** 
     * Get the 'Element' element value. If present, this attribute may identify an unknown or misspelled tag that caused 
    				an error in processing. It is recommended that the Tag attribute use XPath notation to identify the 
    				location of a tag in the event that more than one tag of the same name is present in the document. 
    				Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing].
    				
     * 
     * @return value
     */
    public String getElement() {
        return element;
    }

    /** 
     * Set the 'Element' element value. If present, this attribute may identify an unknown or misspelled tag that caused 
    				an error in processing. It is recommended that the Tag attribute use XPath notation to identify the 
    				location of a tag in the event that more than one tag of the same name is present in the document. 
    				Alternatively, the tag name alone can be used to identify missing data [Type=ReqFieldMissing].
    				
     * 
     * @param element
     */
    public void setElement(String element) {
        this.element = element;
    }

    /** 
     * Get the 'RecordID' element value. If present, this attribute allows for batch processing and the identification of the 
    				record that failed amongst a group of records. This value may contain a concatenation of a unique failed 
    				transaction ID with specific record(s) associated with that transaction.
    				
     * 
     * @return value
     */
    public String getRecordID() {
        return recordID;
    }

    /** 
     * Set the 'RecordID' element value. If present, this attribute allows for batch processing and the identification of the 
    				record that failed amongst a group of records. This value may contain a concatenation of a unique failed 
    				transaction ID with specific record(s) associated with that transaction.
    				
     * 
     * @param recordID
     */
    public void setRecordID(String recordID) {
        this.recordID = recordID;
    }

    /** 
     * Get the 'DocURL' element value. If present, this attribute refers to an online description of the error that occurred.
    				
     * 
     * @return value
     */
    public String getDocURL() {
        return docURL;
    }

    /** 
     * Set the 'DocURL' element value. If present, this attribute refers to an online description of the error that occurred.
    				
     * 
     * @param docURL
     */
    public void setDocURL(String docURL) {
        this.docURL = docURL;
    }

    /** 
     * Get the 'timeStamp' attribute value.
     * 
     * @return value
     */
    public Date getTimeStamp() {
        return timeStamp;
    }

    /** 
     * Set the 'timeStamp' attribute value.
     * 
     * @param timeStamp
     */
    public void setTimeStamp(Date timeStamp) {
        this.timeStamp = timeStamp;
    }

    /** 
     * Get the 'reference' attribute value. If present, this attribute provides an XML IDREF to the elemenet for which the results apply.
    			
     * 
     * @return value
     */
    public String getReference() {
        return reference;
    }

    /** 
     * Set the 'reference' attribute value. If present, this attribute provides an XML IDREF to the elemenet for which the results apply.
    			
     * 
     * @param reference
     */
    public void setReference(String reference) {
        this.reference = reference;
    }
}
