
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Amenity">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Code" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="Description" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="Fee" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="id"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Amenity implements Serializable
{
    private String code;
    private String description;
    private Amount fee;
    private String id;

    /** 
     * Get the 'Code' element value. Product code.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' element value. Product code.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'Description' element value. Description of the amenity
     * 
     * @return value
     */
    public String getDescription() {
        return description;
    }

    /** 
     * Set the 'Description' element value. Description of the amenity
     * 
     * @param description
     */
    public void setDescription(String description) {
        this.description = description;
    }

    /** 
     * Get the 'Fee' element value. Total Fee if any applicable to the amenity
     * 
     * @return value
     */
    public Amount getFee() {
        return fee;
    }

    /** 
     * Set the 'Fee' element value. Total Fee if any applicable to the amenity
     * 
     * @param fee
     */
    public void setFee(Amount fee) {
        this.fee = fee;
    }

    /** 
     * Get the 'id' attribute value. XML ID value used to reference this amenity.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. XML ID value used to reference this amenity.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }
}
