
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * Travellers Loyalty Membership NumberAssigned XSD Type: {http://services.sabre.com/STL/v01}MembershipID
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerLoyalty">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="required" name="carrier"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="program"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="partnerProgram"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="level"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="notes"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="tag"/>
 *       &lt;xs:attribute type="xs:string" use="optional" name="profileTier"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CustomerLoyalty implements Serializable
{
    private String string;
    private String carrier;
    private String program;
    private String partnerProgram;
    private String level;
    private String notes;
    private String tag;
    private String profileTier;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'carrier' attribute value. Loyalty program owning carrier
     * 
     * @return value
     */
    public String getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'carrier' attribute value. Loyalty program owning carrier
     * 
     * @param carrier
     */
    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'program' attribute value. Primary Membership programAssigned XSD Type: {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @return value
     */
    public String getProgram() {
        return program;
    }

    /** 
     * Set the 'program' attribute value. Primary Membership programAssigned XSD Type: {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @param program
     */
    public void setProgram(String program) {
        this.program = program;
    }

    /** 
     * Get the 'partnerProgram' attribute value. Partner or AllianceAssigned XSD Type: {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @return value
     */
    public String getPartnerProgram() {
        return partnerProgram;
    }

    /** 
     * Set the 'partnerProgram' attribute value. Partner or AllianceAssigned XSD Type: {http://services.sabre.com/STL/v01}ProperName
                          
     * 
     * @param partnerProgram
     */
    public void setPartnerProgram(String partnerProgram) {
        this.partnerProgram = partnerProgram;
    }

    /** 
     * Get the 'level' attribute value. Frequent Flier Tier Number stored in PNRAssigned XSD Type: {http://services.sabre.com/STL/v01}StringLength1to64
                          
     * 
     * @return value
     */
    public String getLevel() {
        return level;
    }

    /** 
     * Set the 'level' attribute value. Frequent Flier Tier Number stored in PNRAssigned XSD Type: {http://services.sabre.com/STL/v01}StringLength1to64
                          
     * 
     * @param level
     */
    public void setLevel(String level) {
        this.level = level;
    }

    /** 
     * Get the 'notes' attribute value. Free textAssigned XSD Type: {http://services.sabre.com/STL/v01}Text
                          
     * 
     * @return value
     */
    public String getNotes() {
        return notes;
    }

    /** 
     * Set the 'notes' attribute value. Free textAssigned XSD Type: {http://services.sabre.com/STL/v01}Text
                          
     * 
     * @param notes
     */
    public void setNotes(String notes) {
        this.notes = notes;
    }

    /** 
     * Get the 'tag' attribute value. Frequent Flier Tag stored in PNR
     * 
     * @return value
     */
    public String getTag() {
        return tag;
    }

    /** 
     * Set the 'tag' attribute value. Frequent Flier Tag stored in PNR
     * 
     * @param tag
     */
    public void setTag(String tag) {
        this.tag = tag;
    }

    /** 
     * Get the 'profileTier' attribute value. Frequent Flier Tier stored in Profiles
     * 
     * @return value
     */
    public String getProfileTier() {
        return profileTier;
    }

    /** 
     * Set the 'profileTier' attribute value. Frequent Flier Tier stored in Profiles
     * 
     * @param profileTier
     */
    public void setProfileTier(String profileTier) {
        this.profileTier = profileTier;
    }
}
