
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Deal">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Enum_Deal_Type" name="Type" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OfferName" minOccurs="1"/>
 *     &lt;xs:element type="xs:decimal" name="Percentage" minOccurs="0"/>
 *     &lt;xs:element type="ns:Amount" name="Amount" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Deal implements Serializable
{
    private EnumDealType type;
    private String offerName;
    private BigDecimal percentage;
    private Amount amount;

    /** 
     * Get the 'Type' element value. Indicates whether price goes up or down
     * 
     * @return value
     */
    public EnumDealType getType() {
        return type;
    }

    /** 
     * Set the 'Type' element value. Indicates whether price goes up or down
     * 
     * @param type
     */
    public void setType(EnumDealType type) {
        this.type = type;
    }

    /** 
     * Get the 'OfferName' element value. Rule ID that applies in DR for this ancillary
     * 
     * @return value
     */
    public String getOfferName() {
        return offerName;
    }

    /** 
     * Set the 'OfferName' element value. Rule ID that applies in DR for this ancillary
     * 
     * @param offerName
     */
    public void setOfferName(String offerName) {
        this.offerName = offerName;
    }

    /** 
     * Get the 'Percentage' element value. Percentage as defined in DR rule for percentage discounts/markups
                      
     * 
     * @return value
     */
    public BigDecimal getPercentage() {
        return percentage;
    }

    /** 
     * Set the 'Percentage' element value. Percentage as defined in DR rule for percentage discounts/markups
                      
     * 
     * @param percentage
     */
    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    /** 
     * Get the 'Amount' element value. Amount as defined in DR rule for monetary discounts/markups
     * 
     * @return value
     */
    public Amount getAmount() {
        return amount;
    }

    /** 
     * Set the 'Amount' element value. Amount as defined in DR rule for monetary discounts/markups
     * 
     * @param amount
     */
    public void setAmount(Amount amount) {
        this.amount = amount;
    }
}
