
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_CabinFacilitiesRowLocationtype">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Front"/>
 *     &lt;xs:enumeration value="Middle"/>
 *     &lt;xs:enumeration value="Rear"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumCabinFacilitiesRowLocationtype implements Serializable {
    /** 
     * Front F precedes first row num ber within cabin class - Padis 9976
    
     */
    FRONT("Front"), /** 
                     * Middle M between row numbers within a cabin class
                     */
    MIDDLE("Middle"), /** 
                       * Rear R follows last row number within a cabin class
                       */
    REAR("Rear");
    private final String value;

    private EnumCabinFacilitiesRowLocationtype(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumCabinFacilitiesRowLocationtype convert(String value) {
        for (EnumCabinFacilitiesRowLocationtype inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
