
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * Padis 9882
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_ColumnDescription">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="CenterSeat"/>
 *     &lt;xs:enumeration value="Aisle"/>
 *     &lt;xs:enumeration value="Window"/>
 *     &lt;xs:enumeration value="Chargeable"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumColumnDescription implements Serializable {
    /** 
     * Center Seat not window, not aisle Padis 9882 - 9
     */
    CENTER_SEAT("CenterSeat"), /** 
                                * Aisle seat - Padis 9882 - A
                                */
    AISLE("Aisle"), /** 
                     * Window Seat - Padis 9882 - W
                     */
    WINDOW("Window"), /** 
                       * Chargeable Row Padis 9882 - CH
                       */
    CHARGEABLE("Chargeable");
    private final String value;

    private EnumColumnDescription(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumColumnDescription convert(String value) {
        for (EnumColumnDescription inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
