
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * An identifier for a type or category of a seat, typically on an airplane or train.
 This is a string list of enumerations with an "Other_" literal to support an open
 enumeration list. Use the "Other_" value in combination with the @extension attribute to exchange a literal that is not in
 the list and is known to your trading partners.
 Table name(s): Air Seat Type (AST)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_SeatFacilitiesType_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="BulkheadSeatWithMovieScreen"/>
 *     &lt;xs:enumeration value="ElectronicConnectionForLapTopOrFaxMachine"/>
 *     &lt;xs:enumeration value="GeneralFacility"/>
 *     &lt;xs:enumeration value="EconomyComfort"/>
 *     &lt;xs:enumeration value="IndividualAirphone"/>
 *     &lt;xs:enumeration value="IndividualMovieScreen-NoChoiceOfMovieSelection"/>
 *     &lt;xs:enumeration value="IndividualVideoScreenChoiceOfMovies,Games,InformationEtc."/>
 *     &lt;xs:enumeration value="IndividualVideoScreenNoChoice"/>
 *     &lt;xs:enumeration value="IndividualVideoScreen-ServicesUnspecified"/>
 *     &lt;xs:enumeration value="LegRestAvailable"/>
 *     &lt;xs:enumeration value="LegSpaceSeat"/>
 *     &lt;xs:enumeration value="ChargeableSeat"/>
 *     &lt;xs:enumeration value="NoFacilitySeat(IndifferentSeat)"/>
 *     &lt;xs:enumeration value="PetInCabin"/>
 *     &lt;xs:enumeration value="PreferredSeat/PreferentialSeat"/>
 *     &lt;xs:enumeration value="SeatInQuietZone"/>
 *     &lt;xs:enumeration value="SeatSuitableForAdultWithInfant"/>
 *     &lt;xs:enumeration value="SeatSuitableForUnaccompaniedMinors"/>
 *     &lt;xs:enumeration value="SeatWithBassinetFacility"/>
 *     &lt;xs:enumeration value="SeatWithFacilitiesForHandicapped/IncapacitatedPassenger"/>
 *     &lt;xs:enumeration value="SeatWithMovieView"/>
 *     &lt;xs:enumeration value="SmokingSeat"/>
 *     &lt;xs:enumeration value="NonSmokingSeat"/>
 *     &lt;xs:enumeration value="FrontOfCabin"/>
 *     &lt;xs:enumeration value="BlockedSeatForPreferredPassengerInAdjacentSeat"/>
 *     &lt;xs:enumeration value="LeftFacingFlatBed"/>
 *     &lt;xs:enumeration value="RightFacingFlatBed"/>
 *     &lt;xs:enumeration value="ForwardFacingFlatBed"/>
 *     &lt;xs:enumeration value="BackwardFacingFlatBed"/>
 *     &lt;xs:enumeration value="LeftFacingFlatBedLeftAngle"/>
 *     &lt;xs:enumeration value="RightFacingFlatBedRightAngle"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumSeatFacilitiesTypeBase implements Serializable {
    /** 
     * Padis 9825 - KA
     */
    BULKHEAD_SEAT_WITH_MOVIE_SCREEN("BulkheadSeatWithMovieScreen"), /** 
                                                                     * Padis 9825 - EC
                                                                     */
    ELECTRONIC_CONNECTION_FOR_LAP_TOP_OR_FAX_MACHINE(
            "ElectronicConnectionForLapTopOrFaxMachine"), /** 
                                                           * Padis 9825 - GF
                                                           */
    GENERAL_FACILITY("GeneralFacility"), /** 
                                          * Padis 9825 - EK
                                          */
    ECONOMY_COMFORT("EconomyComfort"), /** 
                                        * Padis 9825 - AS
                                        */
    INDIVIDUAL_AIRPHONE("IndividualAirphone"), /** 
                                                * Padis 9825 - AM
                                                */
    INDIVIDUAL_MOVIE_SCREEN_NO_CHOICE_OF_MOVIE_SELECTION(
            "IndividualMovieScreen-NoChoiceOfMovieSelection"), /** 
                                                                * Padis 9825 - 3B
                                                                */
    INDIVIDUAL_VIDEO_SCREEN_CHOICE_OF_MOVIES_GAMES_INFORMATION_ETC(
            "IndividualVideoScreenChoiceOfMovies,Games,InformationEtc."), /** 
                                                                           * Padis 9825 - 3A
                                                                           */
    INDIVIDUAL_VIDEO_SCREEN_NO_CHOICE("IndividualVideoScreenNoChoice"), /** 
                                                                         * Padis 9825 - 700
                                                                         */
    INDIVIDUAL_VIDEO_SCREEN_SERVICES_UNSPECIFIED(
            "IndividualVideoScreen-ServicesUnspecified"), /** 
                                                           * Padis 9825 - 2
                                                           */
    LEG_REST_AVAILABLE("LegRestAvailable"), /** 
                                             * Padis 9825 - L
                                             */
    LEG_SPACE_SEAT("LegSpaceSeat"), /** 
                                     * Padis9825 - CH
                                     */
    CHARGEABLE_SEAT("ChargeableSeat"), /** 
                                        * Padis 9825 - X
                                        */
    NO_FACILITY_SEAT_INDIFFERENT_SEAT("NoFacilitySeat(IndifferentSeat)"), /** 
                                                                           * Padis 9825 - PC
                                                                           */
    PET_IN_CABIN("PetInCabin"), /** 
                                 * Padis 9825 - O
                                 */
    PREFERRED_SEAT_PREFERENTIAL_SEAT("PreferredSeat/PreferentialSeat"), /** 
                                                                         * Padis 9825 - Q
                                                                         */
    SEAT_IN_QUIET_ZONE("SeatInQuietZone"), /** 
                                            * Padis 9825 - I
                                            */
    SEAT_SUITABLE_FOR_ADULT_WITH_INFANT("SeatSuitableForAdultWithInfant"), /** 
                                                                            * Padis 9825 - U
                                                                            */
    SEAT_SUITABLE_FOR_UNACCOMPANIED_MINORS("SeatSuitableForUnaccompaniedMinors"), /** 
                                                                                   * Padis 9825 - B
                                                                                   */
    SEAT_WITH_BASSINET_FACILITY("SeatWithBassinetFacility"), /** 
                                                              * PAdis 9825 - H
                                                              */
    SEAT_WITH_FACILITIES_FOR_HANDICAPPED_INCAPACITATED_PASSENGER(
            "SeatWithFacilitiesForHandicapped/IncapacitatedPassenger"), /** 
                                                                         * Padis 9825 - 1M
                                                                         */
    SEAT_WITH_MOVIE_VIEW("SeatWithMovieView"), /** 
                                                * Padis 9825 - S
                                                */
    SMOKING_SEAT("SmokingSeat"), /** 
                                  * Padis 9825 - N
                                  */
    NON_SMOKING_SEAT("NonSmokingSeat"), /** 
                                         * Padis 9825 - FC
                                         */
    FRONT_OF_CABIN("FrontOfCabin"), /** 
                                     * Padis 9825 - BK
                                     */
    BLOCKED_SEAT_FOR_PREFERRED_PASSENGER_IN_ADJACENT_SEAT(
            "BlockedSeatForPreferredPassengerInAdjacentSeat"), /** 
                                                                * UA Bilateral
                                                                */
    LEFT_FACING_FLAT_BED("LeftFacingFlatBed"), /** 
                                                * UA Bilateral
                                                */
    RIGHT_FACING_FLAT_BED("RightFacingFlatBed"), /** 
                                                  * UA Bilateral
                                                  */
    FORWARD_FACING_FLAT_BED("ForwardFacingFlatBed"), /** 
                                                      * UA Bilateral
                                                      */
    BACKWARD_FACING_FLAT_BED("BackwardFacingFlatBed"), /** 
                                                        * UA Bilateral
                                                        */
    LEFT_FACING_FLAT_BED_LEFT_ANGLE("LeftFacingFlatBedLeftAngle"), /** 
                                                                    * UA Bilateral
                                                                    */
    RIGHT_FACING_FLAT_BED_RIGHT_ANGLE("RightFacingFlatBedRightAngle"), OTHER_(
            "Other_");
    private final String value;

    private EnumSeatFacilitiesTypeBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumSeatFacilitiesTypeBase convert(String value) {
        for (EnumSeatFacilitiesTypeBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
