
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_SeatOccupationCabinDefault">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Free"/>
 *     &lt;xs:enumeration value="N"/>
 *     &lt;xs:enumeration value="Occupied"/>
 *     &lt;xs:enumeration value="R"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumSeatOccupationCabinDefault implements Serializable {
    /** 
     * All seats Free - Padis 9883 - F
     */
    FREE("Free"), /** 
                   * No seat occupation default is being used - Padis 9883 - N
                   */
    N("N"), /** 
             * All seats occupied unless otherwise specified - Padis 9883 - O
                        
             */
    OCCUPIED("Occupied"), /** 
                           * seat not designated for RBD specified in request - Padis 9883 -R
                          
                           */
    R("R");
    private final String value;

    private EnumSeatOccupationCabinDefault(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumSeatOccupationCabinDefault convert(String value) {
        for (EnumSeatOccupationCabinDefault inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
