
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * An identifier for a type or category of a seat, typically on an airplane or train.
 This is a string list of enumerations with an "Other_" literal to support an open
 enumeration list. Use the "Other_" value in combination with the @extension attribute to exchange a literal that is not in
 the list and is known to your trading partners.
 Table name(s): Air Seat Type (AST)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_SeatReqType_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="AdjacentAisleSeat"/>
 *     &lt;xs:enumeration value="AisleSeat"/>
 *     &lt;xs:enumeration value="AllAvailableAisleSeats"/>
 *     &lt;xs:enumeration value="AllAvailableWindowSeats"/>
 *     &lt;xs:enumeration value="BulkheadSeat"/>
 *     &lt;xs:enumeration value="CenterSectionSeat(s)"/>
 *     &lt;xs:enumeration value="ElectronicConnectionForLapTopOrFaxMachine"/>
 *     &lt;xs:enumeration value="ExitRowSeat"/>
 *     &lt;xs:enumeration value="NonsmokingSeat"/>
 *     &lt;xs:enumeration value="NotAllowedForInfants"/>
 *     &lt;xs:enumeration value="NotAllowedForMedical"/>
 *     &lt;xs:enumeration value="OnlyAvailableSeats"/>
 *     &lt;xs:enumeration value="PreferredSeat/PreferentialSeat"/>
 *     &lt;xs:enumeration value="SeatSuitableForAdultWithInfant"/>
 *     &lt;xs:enumeration value="SeatSuitableForUnaccompaniedMinors"/>
 *     &lt;xs:enumeration value="SeatWithBassinetFacility"/>
 *     &lt;xs:enumeration value="SeatWithFacilitiesForHandicapped/IncapacitatedPassenger"/>
 *     &lt;xs:enumeration value="SmokingSeat"/>
 *     &lt;xs:enumeration value="Window"/>
 *     &lt;xs:enumeration value="WindowAndAisleTogether"/>
 *     &lt;xs:enumeration value="ChargeableSeat"/>
 *     &lt;xs:enumeration value="NonsmokingAisle"/>
 *     &lt;xs:enumeration value="NonsmokingWindow"/>
 *     &lt;xs:enumeration value="NonSmokingBulkhead"/>
 *     &lt;xs:enumeration value="WindowBulkhead"/>
 *     &lt;xs:enumeration value="AisleBulkhead"/>
 *     &lt;xs:enumeration value="Oxygen"/>
 *     &lt;xs:enumeration value="UnaccompaniedMinor"/>
 *     &lt;xs:enumeration value="LapChild"/>
 *     &lt;xs:enumeration value="ServiceAnimal"/>
 *     &lt;xs:enumeration value="PetInCabin"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumSeatReqTypeBase implements Serializable {
    /** 
     * Padis 9825 - AJ
     */
    ADJACENT_AISLE_SEAT("AdjacentAisleSeat"), /** 
                                               * Padis 9825 - A
                                               */
    AISLE_SEAT("AisleSeat"), /** 
                              * Padis 9825 - AA
                              */
    ALL_AVAILABLE_AISLE_SEATS("AllAvailableAisleSeats"), /** 
                                                          * Padis 9825 - AW
                                                          */
    ALL_AVAILABLE_WINDOW_SEATS("AllAvailableWindowSeats"), /** 
                                                            * Padis 9825 - K
                                                            */
    BULKHEAD_SEAT("BulkheadSeat"), /** 
                                    * Padis 9825 - CC
                                    */
    CENTER_SECTION_SEATS("CenterSectionSeat(s)"), /** 
                                                   * Padis 9825 - EC
                                                   */
    ELECTRONIC_CONNECTION_FOR_LAP_TOP_OR_FAX_MACHINE(
            "ElectronicConnectionForLapTopOrFaxMachine"), /** 
                                                           * Padis 9825 - E
                                                           */
    EXIT_ROW_SEAT("ExitRowSeat"), /** 
                                   * Padis 9825 - N
                                   */
    NONSMOKING_SEAT("NonsmokingSeat"), /** 
                                        * Padis 9825 - 1A
                                        */
    NOT_ALLOWED_FOR_INFANTS("NotAllowedForInfants"), /** 
                                                      * Padis 9825 - 1B
                                                      */
    NOT_ALLOWED_FOR_MEDICAL("NotAllowedForMedical"), /** 
                                                      * Padis 9825 - AV
                                                      */
    ONLY_AVAILABLE_SEATS("OnlyAvailableSeats"), /** 
                                                 * Padis 9825 - O
                                                 */
    PREFERRED_SEAT_PREFERENTIAL_SEAT("PreferredSeat/PreferentialSeat"), /** 
                                                                         * Padis 9825 - I
                                                                         */
    SEAT_SUITABLE_FOR_ADULT_WITH_INFANT("SeatSuitableForAdultWithInfant"), /** 
                                                                            * Padis 9825 - U
                                                                            */
    SEAT_SUITABLE_FOR_UNACCOMPANIED_MINORS("SeatSuitableForUnaccompaniedMinors"), /** 
                                                                                   * Padis 9825 - B
                                                                                   */
    SEAT_WITH_BASSINET_FACILITY("SeatWithBassinetFacility"), /** 
                                                              * Padis 9825 - H
                                                              */
    SEAT_WITH_FACILITIES_FOR_HANDICAPPED_INCAPACITATED_PASSENGER(
            "SeatWithFacilitiesForHandicapped/IncapacitatedPassenger"), /** 
                                                                         * Padis 9825 - S
                                                                         */
    SMOKING_SEAT("SmokingSeat"), /** 
                                  * Padis 9825 - W
                                  */
    WINDOW("Window"), /** 
                       * Padis 9825 - WA
                       */
    WINDOW_AND_AISLE_TOGETHER("WindowAndAisleTogether"), /** 
                                                          * Padis 9825 - CH
                                                          */
    CHARGEABLE_SEAT("ChargeableSeat"), /** 
                                        * combination Padis 9825 - NA
                                        */
    NONSMOKING_AISLE("NonsmokingAisle"), /** 
                                          * combination Padis 9825 - NW
                                          */
    NONSMOKING_WINDOW("NonsmokingWindow"), /** 
                                            * Combination Padis 9825 - NK
                                            */
    NON_SMOKING_BULKHEAD("NonSmokingBulkhead"), /** 
                                                 * Combination Padis 9825 -WK
                                                 */
    WINDOW_BULKHEAD("WindowBulkhead"), /** 
                                        * Combination Padis 9825 -AK
                                        */
    AISLE_BULKHEAD("AisleBulkhead"), /** 
                                      * UA - Bilateral request qualifier
                                      */
    OXYGEN("Oxygen"), /** 
                       * UA - Bilateral request qualifier
                       */
    UNACCOMPANIED_MINOR("UnaccompaniedMinor"), /** 
                                                * UA - Bilateral request qualifier
                                                */
    LAP_CHILD("LapChild"), /** 
                            * UA - Bilateral request qualifier
                            */
    SERVICE_ANIMAL("ServiceAnimal"), PET_IN_CABIN("PetInCabin"), OTHER_(
            "Other_");
    private final String value;

    private EnumSeatReqTypeBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumSeatReqTypeBase convert(String value) {
        for (EnumSeatReqTypeBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
