
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * An identifier for a type or category of a row of seats, typically on an airplane or
 train.
 This is a string list of enumerations with an "Other_" literal to support an open
 enumeration list. Use the "Other_" value in combination with the @extension attribute to exchange a literal that is not in
 the list and is known to your trading partners.
 Table name(s): Air Row Type (ROW)
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Enum_SeatRowType_Base">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="BufferRow"/>
 *     &lt;xs:enumeration value="ExitLeft"/>
 *     &lt;xs:enumeration value="ExitRight"/>
 *     &lt;xs:enumeration value="ExitRow"/>
 *     &lt;xs:enumeration value="ExitRowWithCabinFacilitiesInADesignatedColumn"/>
 *     &lt;xs:enumeration value="ExitRowWithCabinFacilitiesInAnUndesignatedColumn"/>
 *     &lt;xs:enumeration value="ExtraLegRoom"/>
 *     &lt;xs:enumeration value="IndifferentRow"/>
 *     &lt;xs:enumeration value="LowerdeckRow"/>
 *     &lt;xs:enumeration value="MaindeckRow"/>
 *     &lt;xs:enumeration value="No-SmokingRow"/>
 *     &lt;xs:enumeration value="NotOverwingRow"/>
 *     &lt;xs:enumeration value="OverwingRow"/>
 *     &lt;xs:enumeration value="PreferredRow/PreferentialRow"/>
 *     &lt;xs:enumeration value="RowDoesNotExist"/>
 *     &lt;xs:enumeration value="RowWithCabinFacilitiesInADesignatedColumn"/>
 *     &lt;xs:enumeration value="RowWithCabinFacilitiesInAnUndesignatedColumn"/>
 *     &lt;xs:enumeration value="RowWithMovieScreen"/>
 *     &lt;xs:enumeration value="SeatRestrictionsApplyInThisRow"/>
 *     &lt;xs:enumeration value="SmokingRow"/>
 *     &lt;xs:enumeration value="UpperdeckRow"/>
 *     &lt;xs:enumeration value="Other_"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum EnumSeatRowTypeBase implements Serializable {
    /** 
     * Padis 9864 - B
     */
    BUFFER_ROW("BufferRow"), /** 
                              * Padis 9864 - EL
                              */
    EXIT_LEFT("ExitLeft"), /** 
                            * Padis 9864 - ER
                            */
    EXIT_RIGHT("ExitRight"), /** 
                              * Padis 9864 - E
                              */
    EXIT_ROW("ExitRow"), /** 
                          * Padis 9864 - EC
                          */
    EXIT_ROW_WITH_CABIN_FACILITIES_IN_A_DESIGNATED_COLUMN(
            "ExitRowWithCabinFacilitiesInADesignatedColumn"), /** 
                                                               * Padis 9864 - XC
                                                               */
    EXIT_ROW_WITH_CABIN_FACILITIES_IN_AN_UNDESIGNATED_COLUMN(
            "ExitRowWithCabinFacilitiesInAnUndesignatedColumn"), /** 
                                                                  * Padis 9864 - A
                                                                  */
    EXTRA_LEG_ROOM("ExtraLegRoom"), /** 
                                     * Padis 9864 - I
                                     */
    INDIFFERENT_ROW("IndifferentRow"), /** 
                                        * Padis 9864 - L
                                        */
    LOWERDECK_ROW("LowerdeckRow"), /** 
                                    * Padis 9864 - M
                                    */
    MAINDECK_ROW("MaindeckRow"), /** 
                                  * Padis 9864 - N
                                  */
    NO_SMOKING_ROW("No-SmokingRow"), /** 
                                      * Padis 9864 - X
                                      */
    NOT_OVERWING_ROW("NotOverwingRow"), /** 
                                         * Padis 9864 - K
                                         */
    OVERWING_ROW("OverwingRow"), /** 
                                  * OTA coded
                                  */
    PREFERRED_ROW_PREFERENTIAL_ROW("PreferredRow/PreferentialRow"), /** 
                                                                     * Padis 9864 - Z
                                                                     */
    ROW_DOES_NOT_EXIST("RowDoesNotExist"), /** 
                                            * Padis 9864 - C
                                            */
    ROW_WITH_CABIN_FACILITIES_IN_A_DESIGNATED_COLUMN(
            "RowWithCabinFacilitiesInADesignatedColumn"), /** 
                                                           * Padis 9864 - CC
                                                           */
    ROW_WITH_CABIN_FACILITIES_IN_AN_UNDESIGNATED_COLUMN(
            "RowWithCabinFacilitiesInAnUndesignatedColumn"), /** 
                                                              * Padis 9864 - MV
                                                              */
    ROW_WITH_MOVIE_SCREEN("RowWithMovieScreen"), /** 
                                                  * Padis 9864 - D
                                                  */
    SEAT_RESTRICTIONS_APPLY_IN_THIS_ROW("SeatRestrictionsApplyInThisRow"), /** 
                                                                            * Padis 9864 - S
                                                                            */
    SMOKING_ROW("SmokingRow"), /** 
                                * Padis 9864 - U
                                */
    UPPERDECK_ROW("UpperdeckRow"), OTHER_("Other_");
    private final String value;

    private EnumSeatRowTypeBase(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static EnumSeatRowTypeBase convert(String value) {
        for (EnumSeatRowTypeBase inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
