
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Amount" name="GroupTotalPrice" minOccurs="1"/>
 *     &lt;xs:element ref="ns:TravelerFareInfo" minOccurs="1" maxOccurs="999"/>
 *     &lt;xs:element type="xs:string" name="ValidatingCarrier" minOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareGroup implements Serializable
{
    private Amount groupTotalPrice;
    private List<TravelerFareInfo> travelerFareInfoList = new ArrayList<TravelerFareInfo>();
    private String validatingCarrier;

    /** 
     * Get the 'GroupTotalPrice' element value. Total price for the entire itinerary for all passengers of all types. It is the
                          sum of all TypeTotalPrice. Example: 320000
                      
     * 
     * @return value
     */
    public Amount getGroupTotalPrice() {
        return groupTotalPrice;
    }

    /** 
     * Set the 'GroupTotalPrice' element value. Total price for the entire itinerary for all passengers of all types. It is the
                          sum of all TypeTotalPrice. Example: 320000
                      
     * 
     * @param groupTotalPrice
     */
    public void setGroupTotalPrice(Amount groupTotalPrice) {
        this.groupTotalPrice = groupTotalPrice;
    }

    /** 
     * Get the list of 'TravelerFareInfo' element items.
     * 
     * @return list
     */
    public List<TravelerFareInfo> getTravelerFareInfoList() {
        return travelerFareInfoList;
    }

    /** 
     * Set the list of 'TravelerFareInfo' element items.
     * 
     * @param list
     */
    public void setTravelerFareInfoList(List<TravelerFareInfo> list) {
        travelerFareInfoList = list;
    }

    /** 
     * Get the 'ValidatingCarrier' element value. Validating carrier airline designator code..
     * 
     * @return value
     */
    public String getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' element value. Validating carrier airline designator code..
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }
}
