
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Flight_Segment">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FlightDate" name="DepartureDate" minOccurs="1"/>
 *     &lt;xs:element type="ns:Flight_Identifier" name="Operating" minOccurs="0"/>
 *     &lt;xs:element type="ns:Flight_Identifier" name="Marketing" minOccurs="1" maxOccurs="10"/>
 *     &lt;xs:element type="ns:FlightDate" name="ArrivalDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AircraftConfigNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="RecordCreateTag" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Status" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="id"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="destination"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="origin"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightSegment1 implements Serializable
{
    private FlightDate departureDate;
    private FlightIdentifier operating;
    private List<FlightIdentifier> marketingList = new ArrayList<FlightIdentifier>();
    private FlightDate arrivalDate;
    private String aircraftConfigNumber;
    private String recordCreateTag;
    private String status;
    private String id;
    private String destination;
    private String origin;

    /** 
     * Get the 'DepartureDate' element value. Departure date this segment
     * 
     * @return value
     */
    public FlightDate getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. Departure date this segment
     * 
     * @param departureDate
     */
    public void setDepartureDate(FlightDate departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'Operating' element value. Operating Airline
     * 
     * @return value
     */
    public FlightIdentifier getOperating() {
        return operating;
    }

    /** 
     * Set the 'Operating' element value. Operating Airline
     * 
     * @param operating
     */
    public void setOperating(FlightIdentifier operating) {
        this.operating = operating;
    }

    /** 
     * Get the list of 'Marketing' element items. Marketing Airline
     * 
     * @return list
     */
    public List<FlightIdentifier> getMarketingList() {
        return marketingList;
    }

    /** 
     * Set the list of 'Marketing' element items. Marketing Airline
     * 
     * @param list
     */
    public void setMarketingList(List<FlightIdentifier> list) {
        marketingList = list;
    }

    /** 
     * Get the 'ArrivalDate' element value. Arrival date this segment
     * 
     * @return value
     */
    public FlightDate getArrivalDate() {
        return arrivalDate;
    }

    /** 
     * Set the 'ArrivalDate' element value. Arrival date this segment
     * 
     * @param arrivalDate
     */
    public void setArrivalDate(FlightDate arrivalDate) {
        this.arrivalDate = arrivalDate;
    }

    /** 
     * Get the 'AircraftConfigNumber' element value. flight aircraft configuration
     * 
     * @return value
     */
    public String getAircraftConfigNumber() {
        return aircraftConfigNumber;
    }

    /** 
     * Set the 'AircraftConfigNumber' element value. flight aircraft configuration
     * 
     * @param aircraftConfigNumber
     */
    public void setAircraftConfigNumber(String aircraftConfigNumber) {
        this.aircraftConfigNumber = aircraftConfigNumber;
    }

    /** 
     * Get the 'RecordCreateTag' element value. Record Create - RC tag details for LCC 
     * 
     * @return value
     */
    public String getRecordCreateTag() {
        return recordCreateTag;
    }

    /** 
     * Set the 'RecordCreateTag' element value. Record Create - RC tag details for LCC 
     * 
     * @param recordCreateTag
     */
    public void setRecordCreateTag(String recordCreateTag) {
        this.recordCreateTag = recordCreateTag;
    }

    /** 
     * Get the 'Status' element value. status of flight like open, close, boarding, etc.
     * 
     * @return value
     */
    public String getStatus() {
        return status;
    }

    /** 
     * Set the 'Status' element value. status of flight like open, close, boarding, etc.
     * 
     * @param status
     */
    public void setStatus(String status) {
        this.status = status;
    }

    /** 
     * Get the 'id' attribute value. Segment number required only in context of ItineraryPart
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value. Segment number required only in context of ItineraryPart
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'destination' attribute value. IATA airport code
     * 
     * @return value
     */
    public String getDestination() {
        return destination;
    }

    /** 
     * Set the 'destination' attribute value. IATA airport code
     * 
     * @param destination
     */
    public void setDestination(String destination) {
        this.destination = destination;
    }

    /** 
     * Get the 'origin' attribute value. IATA airport code
     * 
     * @return value
     */
    public String getOrigin() {
        return origin;
    }

    /** 
     * Set the 'origin' attribute value. IATA airport code
     * 
     * @param origin
     */
    public void setOrigin(String origin) {
        this.origin = origin;
    }
}
