
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Offer">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CommercialName" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="OfferItemId" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TravellerID" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Price" minOccurs="0"/>
 *     &lt;xs:element ref="ns:BasePrice" minOccurs="0"/>
 *     &lt;xs:element type="ns:Deal" name="Deal" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FeeWaiverRuleId" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EntitlementRuleId" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="entitledInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Offer implements Serializable
{
    private String commercialName;
    private String offerItemId;
    private String travellerID;
    private Price price;
    private BasePrice basePrice;
    private Deal deal;
    private String feeWaiverRuleId;
    private String entitlementRuleId;
    private Boolean entitledInd;

    /** 
     * Get the 'CommercialName' element value. 
                          Specifies the commercial name associated with matched price (PADIS codes).
                      
     * 
     * @return value
     */
    public String getCommercialName() {
        return commercialName;
    }

    /** 
     * Set the 'CommercialName' element value. 
                          Specifies the commercial name associated with matched price (PADIS codes).
                      
     * 
     * @param commercialName
     */
    public void setCommercialName(String commercialName) {
        this.commercialName = commercialName;
    }

    /** 
     * Get the 'OfferItemId' element value. 
                          OfferItemId as defined by NDC. Use this ID when selling the seat based on the price offered here.
                      
     * 
     * @return value
     */
    public String getOfferItemId() {
        return offerItemId;
    }

    /** 
     * Set the 'OfferItemId' element value. 
                          OfferItemId as defined by NDC. Use this ID when selling the seat based on the price offered here.
                      
     * 
     * @param offerItemId
     */
    public void setOfferItemId(String offerItemId) {
        this.offerItemId = offerItemId;
    }

    /** 
     * Get the 'TravellerID' element value. Traveler Profile Identifier.
     * 
     * @return value
     */
    public String getTravellerID() {
        return travellerID;
    }

    /** 
     * Set the 'TravellerID' element value. Traveler Profile Identifier.
     * 
     * @param travellerID
     */
    public void setTravellerID(String travellerID) {
        this.travellerID = travellerID;
    }

    /** 
     * Get the 'Price' element value. Price of seat
     * 
     * @return value
     */
    public Price getPrice() {
        return price;
    }

    /** 
     * Set the 'Price' element value. Price of seat
     * 
     * @param price
     */
    public void setPrice(Price price) {
        this.price = price;
    }

    /** 
     * Get the 'BasePrice' element value. BasePrice of seat
     * 
     * @return value
     */
    public BasePrice getBasePrice() {
        return basePrice;
    }

    /** 
     * Set the 'BasePrice' element value. BasePrice of seat
     * 
     * @param basePrice
     */
    public void setBasePrice(BasePrice basePrice) {
        this.basePrice = basePrice;
    }

    /** 
     * Get the 'Deal' element value. Information about applied discount/markup for this seat
     * 
     * @return value
     */
    public Deal getDeal() {
        return deal;
    }

    /** 
     * Set the 'Deal' element value. Information about applied discount/markup for this seat
     * 
     * @param deal
     */
    public void setDeal(Deal deal) {
        this.deal = deal;
    }

    /** 
     * Get the 'FeeWaiverRuleId' element value. Fee Waiver Rule ID.
     * 
     * @return value
     */
    public String getFeeWaiverRuleId() {
        return feeWaiverRuleId;
    }

    /** 
     * Set the 'FeeWaiverRuleId' element value. Fee Waiver Rule ID.
     * 
     * @param feeWaiverRuleId
     */
    public void setFeeWaiverRuleId(String feeWaiverRuleId) {
        this.feeWaiverRuleId = feeWaiverRuleId;
    }

    /** 
     * Get the 'EntitlementRuleId' element value. Entitlement Rule ID.
     * 
     * @return value
     */
    public String getEntitlementRuleId() {
        return entitlementRuleId;
    }

    /** 
     * Set the 'EntitlementRuleId' element value. Entitlement Rule ID.
     * 
     * @param entitlementRuleId
     */
    public void setEntitlementRuleId(String entitlementRuleId) {
        this.entitlementRuleId = entitlementRuleId;
    }

    /** 
     * Get the 'entitledInd' attribute value. This seat is entitled
     * 
     * @return value
     */
    public Boolean getEntitledInd() {
        return entitledInd;
    }

    /** 
     * Set the 'entitledInd' attribute value. This seat is entitled
     * 
     * @param entitledInd
     */
    public void setEntitledInd(Boolean entitledInd) {
        this.entitledInd = entitledInd;
    }
}
