
package com.sabre.stl.merchandising.v6;

import com.sabre.services.stl.v02.EnumCodeDuty;
import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:ns1="http://services.sabre.com/STL/v02" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="POS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:POS_Location" name="Actual" minOccurs="0"/>
 *     &lt;xs:element type="ns:POS_Location" name="Home" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PCC" minOccurs="0"/>
 *     &lt;xs:element type="ns:ClientContext" name="ClientContext" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="ns1:Enum_CodeDuty" use="optional" name="duty"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LNIATA"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="sine"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="multiHost"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="company"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class POS implements Serializable
{
    private POSLocation actual;
    private POSLocation home;
    private String PCC;
    private ClientContext clientContext;
    private EnumCodeDuty duty;
    private String LNIATA;
    private String sine;
    private String multiHost;
    private String company;

    /** 
     * Get the 'Actual' element value. Actual is where the transaction is initiated.
     * 
     * @return value
     */
    public POSLocation getActual() {
        return actual;
    }

    /** 
     * Set the 'Actual' element value. Actual is where the transaction is initiated.
     * 
     * @param actual
     */
    public void setActual(POSLocation actual) {
        this.actual = actual;
    }

    /** 
     * Get the 'Home' element value. Home is assigned to the agent account.
     * 
     * @return value
     */
    public POSLocation getHome() {
        return home;
    }

    /** 
     * Set the 'Home' element value. Home is assigned to the agent account.
     * 
     * @param home
     */
    public void setHome(POSLocation home) {
        this.home = home;
    }

    /** 
     * Get the 'PCC' element value. Psuedo is either Agency PCC or Agent AAA. Required for
                          most source code is provided.
                      
     * 
     * @return value
     */
    public String getPCC() {
        return PCC;
    }

    /** 
     * Set the 'PCC' element value. Psuedo is either Agency PCC or Agent AAA. Required for
                          most source code is provided.
                      
     * 
     * @param PCC
     */
    public void setPCC(String PCC) {
        this.PCC = PCC;
    }

    /** 
     * Get the 'ClientContext' element value. Client Context
     * 
     * @return value
     */
    public ClientContext getClientContext() {
        return clientContext;
    }

    /** 
     * Set the 'ClientContext' element value. Client Context
     * 
     * @param clientContext
     */
    public void setClientContext(ClientContext clientContext) {
        this.clientContext = clientContext;
    }

    /** 
     * Get the 'duty' attribute value. An authority code assigned to a requestor.
     * 
     * @return value
     */
    public EnumCodeDuty getDuty() {
        return duty;
    }

    /** 
     * Set the 'duty' attribute value. An authority code assigned to a requestor.
     * 
     * @param duty
     */
    public void setDuty(EnumCodeDuty duty) {
        this.duty = duty;
    }

    /** 
     * Get the 'LNIATA' attribute value. LNIATA of the Console the agent signed into.
     * 
     * @return value
     */
    public String getLNIATA() {
        return LNIATA;
    }

    /** 
     * Set the 'LNIATA' attribute value. LNIATA of the Console the agent signed into.
     * 
     * @param LNIATA
     */
    public void setLNIATA(String LNIATA) {
        this.LNIATA = LNIATA;
    }

    /** 
     * Get the 'sine' attribute value. Identifies the agent or party within the requesting
                      entity.
                  
     * 
     * @return value
     */
    public String getSine() {
        return sine;
    }

    /** 
     * Set the 'sine' attribute value. Identifies the agent or party within the requesting
                      entity.
                  
     * 
     * @param sine
     */
    public void setSine(String sine) {
        this.sine = sine;
    }

    /** 
     * Get the 'multiHost' attribute value. Airline partition for multi-host source locations.
     * 
     * @return value
     */
    public String getMultiHost() {
        return multiHost;
    }

    /** 
     * Set the 'multiHost' attribute value. Airline partition for multi-host source locations.
     * 
     * @param multiHost
     */
    public void setMultiHost(String multiHost) {
        this.multiHost = multiHost;
    }

    /** 
     * Get the 'company' attribute value. The IATA assigned code for the Agency or Airine or GDS
     * 
     * @return value
     */
    public String getCompany() {
        return company;
    }

    /** 
     * Set the 'company' attribute value. The IATA assigned code for the Agency or Airine or GDS
     * 
     * @param company
     */
    public void setCompany(String company) {
        this.company = company;
    }
}
