
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Priced_Cabin_Criteria">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CabinClass" minOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="RBD" minOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="displayAllOtherCabins"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PricedCabinCriteria implements Serializable
{
    private String cabinClass;
    private String RBD;
    private boolean displayAllOtherCabins;

    /** 
     * Get the 'CabinClass' element value. Cabin class to apply prices on
     * 
     * @return value
     */
    public String getCabinClass() {
        return cabinClass;
    }

    /** 
     * Set the 'CabinClass' element value. Cabin class to apply prices on
     * 
     * @param cabinClass
     */
    public void setCabinClass(String cabinClass) {
        this.cabinClass = cabinClass;
    }

    /** 
     * Get the 'RBD' element value. Reservation Booking Designator to apply to seatmap cabin request
                      
     * 
     * @return value
     */
    public String getRBD() {
        return RBD;
    }

    /** 
     * Set the 'RBD' element value. Reservation Booking Designator to apply to seatmap cabin request
                      
     * 
     * @param RBD
     */
    public void setRBD(String RBD) {
        this.RBD = RBD;
    }

    /** 
     * Get the 'displayAllOtherCabins' attribute value. Display all cabins
     * 
     * @return value
     */
    public boolean isDisplayAllOtherCabins() {
        return displayAllOtherCabins;
    }

    /** 
     * Set the 'displayAllOtherCabins' attribute value. Display all cabins
     * 
     * @param displayAllOtherCabins
     */
    public void setDisplayAllOtherCabins(boolean displayAllOtherCabins) {
        this.displayAllOtherCabins = displayAllOtherCabins;
    }
}
