
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Row_Air">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="RowNumber" minOccurs="1"/>
 *     &lt;xs:element type="ns:Enum_SeatRowType" name="Type" minOccurs="0" maxOccurs="100"/>
 *     &lt;xs:element ref="ns:Price" minOccurs="0" maxOccurs="100"/>
 *     &lt;xs:element ref="ns:RowFacility" minOccurs="0" maxOccurs="4999"/>
 *     &lt;xs:element ref="ns:Seat" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:string" name="AmenityRef" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RowAir1 implements Serializable
{
    private String rowNumber;
    private List<EnumSeatRowType> typeList = new ArrayList<EnumSeatRowType>();
    private List<Price> priceList = new ArrayList<Price>();
    private List<RowFacility> rowFacilityList = new ArrayList<RowFacility>();
    private List<Seat> seatList = new ArrayList<Seat>();
    private String amenityRef;

    /** 
     * Get the 'RowNumber' element value. Row Number on Aircraft 1-999Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}string
     * 
     * @return value
     */
    public String getRowNumber() {
        return rowNumber;
    }

    /** 
     * Set the 'RowNumber' element value. Row Number on Aircraft 1-999Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}string
     * 
     * @param rowNumber
     */
    public void setRowNumber(String rowNumber) {
        this.rowNumber = rowNumber;
    }

    /** 
     * Get the list of 'Type' element items. Row Characteristics i.e E for EXITAssigned XSD Type: {http://www.w3.org/2001/XMLSchema}string
     * 
     * @return list
     */
    public List<EnumSeatRowType> getTypeList() {
        return typeList;
    }

    /** 
     * Set the list of 'Type' element items. Row Characteristics i.e E for EXITAssigned XSD Type: {http://www.w3.org/2001/XMLSchema}string
     * 
     * @param list
     */
    public void setTypeList(List<EnumSeatRowType> list) {
        typeList = list;
    }

    /** 
     * Get the list of 'Price' element items. Seat Price Applicable to this ROW overrides cabin level price.
                      
     * 
     * @return list
     */
    public List<Price> getPriceList() {
        return priceList;
    }

    /** 
     * Set the list of 'Price' element items. Seat Price Applicable to this ROW overrides cabin level price.
                      
     * 
     * @param list
     */
    public void setPriceList(List<Price> list) {
        priceList = list;
    }

    /** 
     * Get the list of 'RowFacility' element items. Cabin facilities applicable to this ROW
     * 
     * @return list
     */
    public List<RowFacility> getRowFacilityList() {
        return rowFacilityList;
    }

    /** 
     * Set the list of 'RowFacility' element items. Cabin facilities applicable to this ROW
     * 
     * @param list
     */
    public void setRowFacilityList(List<RowFacility> list) {
        rowFacilityList = list;
    }

    /** 
     * Get the list of 'Seat' element items. Seat Details in this ROW
     * 
     * @return list
     */
    public List<Seat> getSeatList() {
        return seatList;
    }

    /** 
     * Set the list of 'Seat' element items. Seat Details in this ROW
     * 
     * @param list
     */
    public void setSeatList(List<Seat> list) {
        seatList = list;
    }

    /** 
     * Get the 'AmenityRef' element value. List of Amenities that apply to this Row
     * 
     * @return value
     */
    public String getAmenityRef() {
        return amenityRef;
    }

    /** 
     * Set the 'AmenityRef' element value. List of Amenities that apply to this Row
     * 
     * @param amenityRef
     */
    public void setAmenityRef(String amenityRef) {
        this.amenityRef = amenityRef;
    }
}
