
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Seat_Air">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CommercialName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Number" minOccurs="0"/>
 *     &lt;xs:element ref="ns:Occupation" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element ref="ns:Location" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element ref="ns:Limitations" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element ref="ns:Facilities" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element ref="ns:Offer" minOccurs="0" maxOccurs="9"/>
 *     &lt;xs:element ref="ns:Bilateral" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AmenityRef" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="blockCode"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="occupiedInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="inoperativeInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="premiumInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="chargeableInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="exitRowInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="restrictedReclineInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="noInfantInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatAir1 implements Serializable
{
    private String commercialName;
    private String number;
    private List<Occupation> occupationList = new ArrayList<Occupation>();
    private List<Location> locationList = new ArrayList<Location>();
    private List<Limitations> limitationList = new ArrayList<Limitations>();
    private List<Facilities> facilityList = new ArrayList<Facilities>();
    private List<Offer> offerList = new ArrayList<Offer>();
    private Bilateral bilateral;
    private String amenityRef;
    private String blockCode;
    private Boolean occupiedInd;
    private Boolean inoperativeInd;
    private Boolean premiumInd;
    private Boolean chargeableInd;
    private Boolean exitRowInd;
    private Boolean restrictedReclineInd;
    private Boolean noInfantInd;

    /** 
     * Get the 'CommercialName' element value. Commercial name for seat retrieved from T191, T198 or S5.
     * 
     * @return value
     */
    public String getCommercialName() {
        return commercialName;
    }

    /** 
     * Set the 'CommercialName' element value. Commercial name for seat retrieved from T191, T198 or S5.
     * 
     * @param commercialName
     */
    public void setCommercialName(String commercialName) {
        this.commercialName = commercialName;
    }

    /** 
     * Get the 'Number' element value. Upper case letter which when added to the row number creates a "Seat Number"
                      Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}string
     * 
     * @return value
     */
    public String getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' element value. Upper case letter which when added to the row number creates a "Seat Number"
                      Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}string
     * 
     * @param number
     */
    public void setNumber(String number) {
        this.number = number;
    }

    /** 
     * Get the list of 'Occupation' element items. Seat Occupation typeAssigned XSD Type: {http://www.w3.org/2001/XMLSchema}string
     * 
     * @return list
     */
    public List<Occupation> getOccupationList() {
        return occupationList;
    }

    /** 
     * Set the list of 'Occupation' element items. Seat Occupation typeAssigned XSD Type: {http://www.w3.org/2001/XMLSchema}string
     * 
     * @param list
     */
    public void setOccupationList(List<Occupation> list) {
        occupationList = list;
    }

    /** 
     * Get the list of 'Location' element items. Details pertinent to location of seat in aircraft
     * 
     * @return list
     */
    public List<Location> getLocationList() {
        return locationList;
    }

    /** 
     * Set the list of 'Location' element items. Details pertinent to location of seat in aircraft
     * 
     * @param list
     */
    public void setLocationList(List<Location> list) {
        locationList = list;
    }

    /** 
     * Get the list of 'Limitations' element items. List of limitations associated with seat
     * 
     * @return list
     */
    public List<Limitations> getLimitationList() {
        return limitationList;
    }

    /** 
     * Set the list of 'Limitations' element items. List of limitations associated with seat
     * 
     * @param list
     */
    public void setLimitationList(List<Limitations> list) {
        limitationList = list;
    }

    /** 
     * Get the list of 'Facilities' element items. Facilities related to a specific seat
     * 
     * @return list
     */
    public List<Facilities> getFacilityList() {
        return facilityList;
    }

    /** 
     * Set the list of 'Facilities' element items. Facilities related to a specific seat
     * 
     * @param list
     */
    public void setFacilityList(List<Facilities> list) {
        facilityList = list;
    }

    /** 
     * Get the list of 'Offer' element items. Passenger Specific Entitlement and Price.
     * 
     * @return list
     */
    public List<Offer> getOfferList() {
        return offerList;
    }

    /** 
     * Set the list of 'Offer' element items. Passenger Specific Entitlement and Price.
     * 
     * @param list
     */
    public void setOfferList(List<Offer> list) {
        offerList = list;
    }

    /** 
     * Get the 'Bilateral' element value. Bilaterally agreed non standard seat characteristics
     * 
     * @return value
     */
    public Bilateral getBilateral() {
        return bilateral;
    }

    /** 
     * Set the 'Bilateral' element value. Bilaterally agreed non standard seat characteristics
     * 
     * @param bilateral
     */
    public void setBilateral(Bilateral bilateral) {
        this.bilateral = bilateral;
    }

    /** 
     * Get the 'AmenityRef' element value. List of Amenities that apply to this seat
     * 
     * @return value
     */
    public String getAmenityRef() {
        return amenityRef;
    }

    /** 
     * Set the 'AmenityRef' element value. List of Amenities that apply to this seat
     * 
     * @param amenityRef
     */
    public void setAmenityRef(String amenityRef) {
        this.amenityRef = amenityRef;
    }

    /** 
     * Get the 'blockCode' attribute value. Special block code, for instance VA's "FF", "GG" special blocks.
     * 
     * @return value
     */
    public String getBlockCode() {
        return blockCode;
    }

    /** 
     * Set the 'blockCode' attribute value. Special block code, for instance VA's "FF", "GG" special blocks.
     * 
     * @param blockCode
     */
    public void setBlockCode(String blockCode) {
        this.blockCode = blockCode;
    }

    /** 
     * Get the 'occupiedInd' attribute value. Seat is available unless present and true. Actual availability is subject to
                      occupation rule.
                  
     * 
     * @return value
     */
    public Boolean getOccupiedInd() {
        return occupiedInd;
    }

    /** 
     * Set the 'occupiedInd' attribute value. Seat is available unless present and true. Actual availability is subject to
                      occupation rule.
                  
     * 
     * @param occupiedInd
     */
    public void setOccupiedInd(Boolean occupiedInd) {
        this.occupiedInd = occupiedInd;
    }

    /** 
     * Get the 'inoperativeInd' attribute value. If true, this seat is not operational.Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}boolean
     * 
     * @return value
     */
    public Boolean getInoperativeInd() {
        return inoperativeInd;
    }

    /** 
     * Set the 'inoperativeInd' attribute value. If true, this seat is not operational.Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}boolean
     * 
     * @param inoperativeInd
     */
    public void setInoperativeInd(Boolean inoperativeInd) {
        this.inoperativeInd = inoperativeInd;
    }

    /** 
     * Get the 'premiumInd' attribute value. If true, this seat is a premium seat that may be subjected to additional fees.
                  Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}boolean
     * 
     * @return value
     */
    public Boolean getPremiumInd() {
        return premiumInd;
    }

    /** 
     * Set the 'premiumInd' attribute value. If true, this seat is a premium seat that may be subjected to additional fees.
                  Assigned XSD Type: {http://www.w3.org/2001/XMLSchema}boolean
     * 
     * @param premiumInd
     */
    public void setPremiumInd(Boolean premiumInd) {
        this.premiumInd = premiumInd;
    }

    /** 
     * Get the 'chargeableInd' attribute value. Padis 9825 - CH
     * 
     * @return value
     */
    public Boolean getChargeableInd() {
        return chargeableInd;
    }

    /** 
     * Set the 'chargeableInd' attribute value. Padis 9825 - CH
     * 
     * @param chargeableInd
     */
    public void setChargeableInd(Boolean chargeableInd) {
        this.chargeableInd = chargeableInd;
    }

    /** 
     * Get the 'exitRowInd' attribute value. This seat is on an exit row
     * 
     * @return value
     */
    public Boolean getExitRowInd() {
        return exitRowInd;
    }

    /** 
     * Set the 'exitRowInd' attribute value. This seat is on an exit row
     * 
     * @param exitRowInd
     */
    public void setExitRowInd(Boolean exitRowInd) {
        this.exitRowInd = exitRowInd;
    }

    /** 
     * Get the 'restrictedReclineInd' attribute value. Padis code 1D
     * 
     * @return value
     */
    public Boolean getRestrictedReclineInd() {
        return restrictedReclineInd;
    }

    /** 
     * Set the 'restrictedReclineInd' attribute value. Padis code 1D
     * 
     * @param restrictedReclineInd
     */
    public void setRestrictedReclineInd(Boolean restrictedReclineInd) {
        this.restrictedReclineInd = restrictedReclineInd;
    }

    /** 
     * Get the 'noInfantInd' attribute value. Padis code - 1A
     * 
     * @return value
     */
    public Boolean getNoInfantInd() {
        return noInfantInd;
    }

    /** 
     * Set the 'noInfantInd' attribute value. Padis code - 1A
     * 
     * @param noInfantInd
     */
    public void setNoInfantInd(Boolean noInfantInd) {
        this.noInfantInd = noInfantInd;
    }
}
