
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatMap_ID">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Equipment" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="mapID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="system"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatMapID implements Serializable
{
    private String equipment;
    private String mapID;
    private String system;

    /** 
     * Get the 'Equipment' element value. IATA aircraft type
     * 
     * @return value
     */
    public String getEquipment() {
        return equipment;
    }

    /** 
     * Set the 'Equipment' element value. IATA aircraft type
     * 
     * @param equipment
     */
    public void setEquipment(String equipment) {
        this.equipment = equipment;
    }

    /** 
     * Get the 'mapID' attribute value. Unique ID that can be used to reference this seatmap
     * 
     * @return value
     */
    public String getMapID() {
        return mapID;
    }

    /** 
     * Set the 'mapID' attribute value. Unique ID that can be used to reference this seatmap
     * 
     * @param mapID
     */
    public void setMapID(String mapID) {
        this.mapID = mapID;
    }

    /** 
     * Get the 'system' attribute value. System that provided the mapID value.
     * 
     * @return value
     */
    public String getSystem() {
        return system;
    }

    /** 
     * Set the 'system' attribute value. System that provided the mapID value.
     * 
     * @param system
     */
    public void setSystem(String system) {
        this.system = system;
    }
}
