
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatMap_Query_Enhanced">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Request" name="RequestType" minOccurs="1"/>
 *     &lt;xs:element ref="ns:Flight" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:choice>
 *       &lt;xs:element ref="ns:CabinDefinition" minOccurs="0"/>
 *       &lt;xs:element ref="ns:PricedCabinCriteria" minOccurs="0"/>
 *     &lt;/xs:choice>
 *     &lt;xs:element type="xs:string" name="Currency" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PNRLocator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AirlineRecordLocator" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FareAvailQualifiers" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element ref="ns:POS" minOccurs="0"/>
 *     &lt;xs:element ref="ns:JourneyData" minOccurs="0"/>
 *     &lt;xs:element ref="ns:FareGroup" minOccurs="0"/>
 *     &lt;xs:element type="ns:SeatMapSource" name="SeatMapSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:Client" name="Client" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="correlationID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatMapQueryEnhanced implements Serializable
{
    private Request requestType;
    private Flight flight;
    private int choiceSelect = -1;
    private static final int CABIN_DEFINITION_CHOICE = 0;
    private static final int PRICED_CABIN_CRITERIA_CHOICE = 1;
    private CabinDefinition cabinDefinition;
    private PricedCabinCriteria pricedCabinCriteria;
    private String currency;
    private String PNRLocator;
    private String airlineRecordLocator;
    private List<FareAvailQualifiers> fareAvailQualifierList = new ArrayList<FareAvailQualifiers>();
    private POS POS;
    private JourneyData journeyData;
    private FareGroup fareGroup;
    private SeatMapSource seatMapSource;
    private Client client;
    private String correlationID;

    /** 
     * Get the 'RequestType' element value. Type of request Staeful, Stateless, Payload
     * 
     * @return value
     */
    public Request getRequestType() {
        return requestType;
    }

    /** 
     * Set the 'RequestType' element value. Type of request Staeful, Stateless, Payload
     * 
     * @param requestType
     */
    public void setRequestType(Request requestType) {
        this.requestType = requestType;
    }

    /** 
     * Get the 'Flight' element value. Flight number , date and time.
     * 
     * @return value
     */
    public Flight getFlight() {
        return flight;
    }

    /** 
     * Set the 'Flight' element value. Flight number , date and time.
     * 
     * @param flight
     */
    public void setFlight(Flight flight) {
        this.flight = flight;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if CabinDefinition is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifCabinDefinition() {
        return choiceSelect == CABIN_DEFINITION_CHOICE;
    }

    /** 
     * Get the 'CabinDefinition' element value. Class Cabin being requested
     * 
     * @return value
     */
    public CabinDefinition getCabinDefinition() {
        return cabinDefinition;
    }

    /** 
     * Set the 'CabinDefinition' element value. Class Cabin being requested
     * 
     * @param cabinDefinition
     */
    public void setCabinDefinition(CabinDefinition cabinDefinition) {
        setChoiceSelect(CABIN_DEFINITION_CHOICE);
        this.cabinDefinition = cabinDefinition;
    }

    /** 
     * Check if PricedCabinCriteria is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPricedCabinCriteria() {
        return choiceSelect == PRICED_CABIN_CRITERIA_CHOICE;
    }

    /** 
     * Get the 'PricedCabinCriteria' element value. Request all cabins for display and request single cabin for pricing
     * 
     * @return value
     */
    public PricedCabinCriteria getPricedCabinCriteria() {
        return pricedCabinCriteria;
    }

    /** 
     * Set the 'PricedCabinCriteria' element value. Request all cabins for display and request single cabin for pricing
     * 
     * @param pricedCabinCriteria
     */
    public void setPricedCabinCriteria(PricedCabinCriteria pricedCabinCriteria) {
        setChoiceSelect(PRICED_CABIN_CRITERIA_CHOICE);
        this.pricedCabinCriteria = pricedCabinCriteria;
    }

    /** 
     * Get the 'Currency' element value. currency request for seatmap pricing
     * 
     * @return value
     */
    public String getCurrency() {
        return currency;
    }

    /** 
     * Set the 'Currency' element value. currency request for seatmap pricing
     * 
     * @param currency
     */
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    /** 
     * Get the 'PNRLocator' element value. Sabre Record Locator of passenger or group
     * 
     * @return value
     */
    public String getPNRLocator() {
        return PNRLocator;
    }

    /** 
     * Set the 'PNRLocator' element value. Sabre Record Locator of passenger or group
     * 
     * @param PNRLocator
     */
    public void setPNRLocator(String PNRLocator) {
        this.PNRLocator = PNRLocator;
    }

    /** 
     * Get the 'AirlineRecordLocator' element value. Airline Record Locator of passenger or group
     * 
     * @return value
     */
    public String getAirlineRecordLocator() {
        return airlineRecordLocator;
    }

    /** 
     * Set the 'AirlineRecordLocator' element value. Airline Record Locator of passenger or group
     * 
     * @param airlineRecordLocator
     */
    public void setAirlineRecordLocator(String airlineRecordLocator) {
        this.airlineRecordLocator = airlineRecordLocator;
    }

    /** 
     * Get the list of 'FareAvailQualifiers' element items. Seat map prices and availabity are based on traveller charactistics.
                      
     * 
     * @return list
     */
    public List<FareAvailQualifiers> getFareAvailQualifierList() {
        return fareAvailQualifierList;
    }

    /** 
     * Set the list of 'FareAvailQualifiers' element items. Seat map prices and availabity are based on traveller charactistics.
                      
     * 
     * @param list
     */
    public void setFareAvailQualifierList(List<FareAvailQualifiers> list) {
        fareAvailQualifierList = list;
    }

    /** 
     * Get the 'POS' element value. Booking agency POS information
     * 
     * @return value
     */
    public POS getPOS() {
        return POS;
    }

    /** 
     * Set the 'POS' element value. Booking agency POS information
     * 
     * @param POS
     */
    public void setPOS(POS POS) {
        this.POS = POS;
    }

    /** 
     * Get the 'JourneyData' element value. Journey control information.
     * 
     * @return value
     */
    public JourneyData getJourneyData() {
        return journeyData;
    }

    /** 
     * Set the 'JourneyData' element value. Journey control information.
     * 
     * @param journeyData
     */
    public void setJourneyData(JourneyData journeyData) {
        this.journeyData = journeyData;
    }

    /** 
     * Get the 'FareGroup' element value. Fare group containing all information regarding the air fares.
                      
     * 
     * @return value
     */
    public FareGroup getFareGroup() {
        return fareGroup;
    }

    /** 
     * Set the 'FareGroup' element value. Fare group containing all information regarding the air fares.
                      
     * 
     * @param fareGroup
     */
    public void setFareGroup(FareGroup fareGroup) {
        this.fareGroup = fareGroup;
    }

    /** 
     * Get the 'SeatMapSource' element value.
     * 
     * @return value
     */
    public SeatMapSource getSeatMapSource() {
        return seatMapSource;
    }

    /** 
     * Set the 'SeatMapSource' element value.
     * 
     * @param seatMapSource
     */
    public void setSeatMapSource(SeatMapSource seatMapSource) {
        this.seatMapSource = seatMapSource;
    }

    /** 
     * Get the 'Client' element value.
     * 
     * @return value
     */
    public Client getClient() {
        return client;
    }

    /** 
     * Set the 'Client' element value.
     * 
     * @param client
     */
    public void setClient(Client client) {
        this.client = client;
    }

    /** 
     * Get the 'correlationID' attribute value. An ID for end-to-end correlation of log messages with the corresponding Web service
                      message throughout the processing of the Web service message.
                  
     * 
     * @return value
     */
    public String getCorrelationID() {
        return correlationID;
    }

    /** 
     * Set the 'correlationID' attribute value. An ID for end-to-end correlation of log messages with the corresponding Web service
                      message throughout the processing of the Web service message.
                  
     * 
     * @param correlationID
     */
    public void setCorrelationID(String correlationID) {
        this.correlationID = correlationID;
    }
}
