
package com.sabre.stl.merchandising.v6;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://stl.sabre.com/Merchandising/v6" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelerFareInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element ref="ns:NameAssociationInfo" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="ns:Amount" name="TypeTotalPrice" minOccurs="1"/>
 *     &lt;xs:element type="ns:Amount" name="Base" minOccurs="1"/>
 *     &lt;xs:element type="ns:Amount" name="Taxes" minOccurs="1"/>
 *     &lt;xs:element type="ns:Amount" name="Total" minOccurs="1"/>
 *     &lt;xs:element ref="ns:JourneyFlight" minOccurs="0" maxOccurs="99"/>
 *     &lt;xs:element type="xs:string" name="TicketByDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FareBasisCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="TypeRequested"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="TypePriced"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="TypeCount"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TravelerFareInfo implements Serializable
{
    private List<NameAssociationInfo> nameAssociationInfoList = new ArrayList<NameAssociationInfo>();
    private Amount typeTotalPrice;
    private Amount base;
    private Amount taxes;
    private Amount total;
    private List<JourneyFlight> journeyFlightList = new ArrayList<JourneyFlight>();
    private String ticketByDate;
    private String fareBasisCode;
    private String typeRequested;
    private String typePriced;
    private BigInteger typeCount;

    /** 
     * Get the list of 'NameAssociationInfo' element items. NameAssociation
     * 
     * @return list
     */
    public List<NameAssociationInfo> getNameAssociationInfoList() {
        return nameAssociationInfoList;
    }

    /** 
     * Set the list of 'NameAssociationInfo' element items. NameAssociation
     * 
     * @param list
     */
    public void setNameAssociationInfoList(List<NameAssociationInfo> list) {
        nameAssociationInfoList = list;
    }

    /** 
     * Get the 'TypeTotalPrice' element value. Total price for all passengers of the same type
     * 
     * @return value
     */
    public Amount getTypeTotalPrice() {
        return typeTotalPrice;
    }

    /** 
     * Set the 'TypeTotalPrice' element value. Total price for all passengers of the same type
     * 
     * @param typeTotalPrice
     */
    public void setTypeTotalPrice(Amount typeTotalPrice) {
        this.typeTotalPrice = typeTotalPrice;
    }

    /** 
     * Get the 'Base' element value. Total base fare amount that includes surcharges (if applicable).
                          Example: 200000
                      
     * 
     * @return value
     */
    public Amount getBase() {
        return base;
    }

    /** 
     * Set the 'Base' element value. Total base fare amount that includes surcharges (if applicable).
                          Example: 200000
                      
     * 
     * @param base
     */
    public void setBase(Amount base) {
        this.base = base;
    }

    /** 
     * Get the 'Taxes' element value. Total taxes amount. Example: 50000
     * 
     * @return value
     */
    public Amount getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value. Total taxes amount. Example: 50000
     * 
     * @param taxes
     */
    public void setTaxes(Amount taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the 'Total' element value. Total price: 50000
     * 
     * @return value
     */
    public Amount getTotal() {
        return total;
    }

    /** 
     * Set the 'Total' element value. Total price: 50000
     * 
     * @param total
     */
    public void setTotal(Amount total) {
        this.total = total;
    }

    /** 
     * Get the list of 'JourneyFlight' element items. JourneyFlight
     * 
     * @return list
     */
    public List<JourneyFlight> getJourneyFlightList() {
        return journeyFlightList;
    }

    /** 
     * Set the list of 'JourneyFlight' element items. JourneyFlight
     * 
     * @param list
     */
    public void setJourneyFlightList(List<JourneyFlight> list) {
        journeyFlightList = list;
    }

    /** 
     * Get the 'TicketByDate' element value. Ticket by date/ time.Example: 2013-12-25.this is not the Booking Time Limit
                          (BookByDate) that applies to offers in a shopping response. This is the date/ time when a ticket-associated offer
                          must be purchased/ ticketed
                      
     * 
     * @return value
     */
    public String getTicketByDate() {
        return ticketByDate;
    }

    /** 
     * Set the 'TicketByDate' element value. Ticket by date/ time.Example: 2013-12-25.this is not the Booking Time Limit
                          (BookByDate) that applies to offers in a shopping response. This is the date/ time when a ticket-associated offer
                          must be purchased/ ticketed
                      
     * 
     * @param ticketByDate
     */
    public void setTicketByDate(String ticketByDate) {
        this.ticketByDate = ticketByDate;
    }

    /** 
     * Get the 'FareBasisCode' element value. Fare Basis Code for the filed fare.
     * 
     * @return value
     */
    public String getFareBasisCode() {
        return fareBasisCode;
    }

    /** 
     * Set the 'FareBasisCode' element value. Fare Basis Code for the filed fare.
     * 
     * @param fareBasisCode
     */
    public void setFareBasisCode(String fareBasisCode) {
        this.fareBasisCode = fareBasisCode;
    }

    /** 
     * Get the 'TypeRequested' attribute value. Passenger type being requested for pricing. If the passenger type sent by the GDS is
                      not in the below predefined list, then it is shown as is. Predefined values are:
                      ADT= Adult
                      CHD = Child
                      INF = Infant
                      GOV = Government
                      MIL = Military
                      SRC = Senior citizen
                      STD = Student
                      YTH = Youth
                      Example: CHD
                  
     * 
     * @return value
     */
    public String getTypeRequested() {
        return typeRequested;
    }

    /** 
     * Set the 'TypeRequested' attribute value. Passenger type being requested for pricing. If the passenger type sent by the GDS is
                      not in the below predefined list, then it is shown as is. Predefined values are:
                      ADT= Adult
                      CHD = Child
                      INF = Infant
                      GOV = Government
                      MIL = Military
                      SRC = Senior citizen
                      STD = Student
                      YTH = Youth
                      Example: CHD
                  
     * 
     * @param typeRequested
     */
    public void setTypeRequested(String typeRequested) {
        this.typeRequested = typeRequested;
    }

    /** 
     * Get the 'TypePriced' attribute value. Passenger type being priced. This type can be different from the type requested if
                      there is no available fare for the requested type. For example the requested type is GOV and the priced type is ADT
                      because there is no available fare for type GOV and there is an available fare for type ADT. If the passenger type sent
                      by the GDS is not the below predefined list, then it is shown as is. Predefined values are:
                      ADT= Adult
                      CHD = Child
                      INF = Infant
                      GOV = Government
                      MIL = Military
                      SRC = Senior citizen
                      STD = Student
                      YTH = Youth
                      Example: ADT
                  
     * 
     * @return value
     */
    public String getTypePriced() {
        return typePriced;
    }

    /** 
     * Set the 'TypePriced' attribute value. Passenger type being priced. This type can be different from the type requested if
                      there is no available fare for the requested type. For example the requested type is GOV and the priced type is ADT
                      because there is no available fare for type GOV and there is an available fare for type ADT. If the passenger type sent
                      by the GDS is not the below predefined list, then it is shown as is. Predefined values are:
                      ADT= Adult
                      CHD = Child
                      INF = Infant
                      GOV = Government
                      MIL = Military
                      SRC = Senior citizen
                      STD = Student
                      YTH = Youth
                      Example: ADT
                  
     * 
     * @param typePriced
     */
    public void setTypePriced(String typePriced) {
        this.typePriced = typePriced;
    }

    /** 
     * Get the 'TypeCount' attribute value.
     * 
     * @return value
     */
    public BigInteger getTypeCount() {
        return typeCount;
    }

    /** 
     * Set the 'TypeCount' attribute value.
     * 
     * @param typeCount
     */
    public void setTypeCount(BigInteger typeCount) {
        this.typeCount = typeCount;
    }
}
