
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountingLine.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TypeIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FareApplication" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FormOfPaymentCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LinkCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AccountingVendorCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ChargeCategoryCoded" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AirlineDesignator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DocumentNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CommissionPercentage" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CommissionAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Fare" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BaseFare" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BasePercent" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TaxPercentage" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TaxAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TaxSurchargeCode2" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GSTCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GSTAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="GSTPercent" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="QSTCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="QSTAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="QSTPercent" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CreditCardNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CreditCardCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PassengerName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NumberOfConjunctedDocuments" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NumberOfCoupons" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OriginalTicketNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OriginalDateOfIssue" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OriginalPlaceOfIssue" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FullPartialExchangeIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OriginalInvoice" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TarriffBasis" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FreeFormText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CurrencyCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SegmentType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SegmentNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="TransactionInd" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AccountingLineText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NetFareAmount" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="NetFareIndicator" minOccurs="0"/>
 *     &lt;xs:element type="ns:SpecialActionIndicator.PNRB" name="SpecialActionIndicator" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="elementId"/>
 *   &lt;xs:attribute type="xs:boolean" name="automated"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AccountingLinePNRB implements Serializable
{
    private String typeIndicator;
    private String fareApplication;
    private String formOfPaymentCode;
    private String linkCode;
    private String accountingVendorCode;
    private String chargeCategoryCoded;
    private String airlineDesignator;
    private String documentNumber;
    private String commissionPercentage;
    private String commissionAmount;
    private String fare;
    private String baseFare;
    private String basePercent;
    private String taxPercentage;
    private String taxAmount;
    private String taxSurchargeCode2;
    private String GSTCode;
    private String GSTAmount;
    private String GSTPercent;
    private String QSTCode;
    private String QSTAmount;
    private String QSTPercent;
    private String creditCardNumber;
    private String creditCardCode;
    private String passengerName;
    private String numberOfConjunctedDocuments;
    private String numberOfCoupons;
    private String originalTicketNumber;
    private String originalDateOfIssue;
    private String originalPlaceOfIssue;
    private String fullPartialExchangeIndicator;
    private String originalInvoice;
    private String tarriffBasis;
    private String freeFormText;
    private String currencyCode;
    private String segmentType;
    private String segmentNumber;
    private String transactionInd;
    private String accountingLineText;
    private String netFareAmount;
    private String netFareIndicator;
    private SpecialActionIndicatorPNRB specialActionIndicator;
    private String id;
    private BigInteger index;
    private OperationTypePNRB op;
    private String elementId;
    private Boolean automated;

    /** 
     * Get the 'TypeIndicator' element value. Indicator of the accounting line, e.g. AC.
     * 
     * @return value
     */
    public String getTypeIndicator() {
        return typeIndicator;
    }

    /** 
     * Set the 'TypeIndicator' element value. Indicator of the accounting line, e.g. AC.
     * 
     * @param typeIndicator
     */
    public void setTypeIndicator(String typeIndicator) {
        this.typeIndicator = typeIndicator;
    }

    /** 
     * Get the 'FareApplication' element value. Fare Application indicates whom Form of Payment is applied to. Possible values:
                          <br xmlns="http://webservices.sabre.com/pnrbuilder/v1_19"/>
                          ONE - a specific passenger
                          <br xmlns="http://webservices.sabre.com/pnrbuilder/v1_19"/>
                          ALL - all the passengers in the PNR
                          <br xmlns="http://webservices.sabre.com/pnrbuilder/v1_19"/>
                          PER - per person
                      
     * 
     * @return value
     */
    public String getFareApplication() {
        return fareApplication;
    }

    /** 
     * Set the 'FareApplication' element value. Fare Application indicates whom Form of Payment is applied to. Possible values:
                          <br xmlns="http://webservices.sabre.com/pnrbuilder/v1_19"/>
                          ONE - a specific passenger
                          <br xmlns="http://webservices.sabre.com/pnrbuilder/v1_19"/>
                          ALL - all the passengers in the PNR
                          <br xmlns="http://webservices.sabre.com/pnrbuilder/v1_19"/>
                          PER - per person
                      
     * 
     * @param fareApplication
     */
    public void setFareApplication(String fareApplication) {
        this.fareApplication = fareApplication;
    }

    /** 
     * Get the 'FormOfPaymentCode' element value. Possible options: CK - check, CA - cash, CH - check or cash (trams only), CC -
                          credit card, CX - credit card (printed with masking).
                      
     * 
     * @return value
     */
    public String getFormOfPaymentCode() {
        return formOfPaymentCode;
    }

    /** 
     * Set the 'FormOfPaymentCode' element value. Possible options: CK - check, CA - cash, CH - check or cash (trams only), CC -
                          credit card, CX - credit card (printed with masking).
                      
     * 
     * @param formOfPaymentCode
     */
    public void setFormOfPaymentCode(String formOfPaymentCode) {
        this.formOfPaymentCode = formOfPaymentCode;
    }

    /** 
     * Get the 'LinkCode' element value.
     * 
     * @return value
     */
    public String getLinkCode() {
        return linkCode;
    }

    /** 
     * Set the 'LinkCode' element value.
     * 
     * @param linkCode
     */
    public void setLinkCode(String linkCode) {
        this.linkCode = linkCode;
    }

    /** 
     * Get the 'AccountingVendorCode' element value.
     * 
     * @return value
     */
    public String getAccountingVendorCode() {
        return accountingVendorCode;
    }

    /** 
     * Set the 'AccountingVendorCode' element value.
     * 
     * @param accountingVendorCode
     */
    public void setAccountingVendorCode(String accountingVendorCode) {
        this.accountingVendorCode = accountingVendorCode;
    }

    /** 
     * Get the 'ChargeCategoryCoded' element value. Charge category code, e.g. TKT.
     * 
     * @return value
     */
    public String getChargeCategoryCoded() {
        return chargeCategoryCoded;
    }

    /** 
     * Set the 'ChargeCategoryCoded' element value. Charge category code, e.g. TKT.
     * 
     * @param chargeCategoryCoded
     */
    public void setChargeCategoryCoded(String chargeCategoryCoded) {
        this.chargeCategoryCoded = chargeCategoryCoded;
    }

    /** 
     * Get the 'AirlineDesignator' element value.
     * 
     * @return value
     */
    public String getAirlineDesignator() {
        return airlineDesignator;
    }

    /** 
     * Set the 'AirlineDesignator' element value.
     * 
     * @param airlineDesignator
     */
    public void setAirlineDesignator(String airlineDesignator) {
        this.airlineDesignator = airlineDesignator;
    }

    /** 
     * Get the 'DocumentNumber' element value. Number used in conjunction with Charge Category Code. Document Number must
                          contain up to 7 digits.
                      
     * 
     * @return value
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /** 
     * Set the 'DocumentNumber' element value. Number used in conjunction with Charge Category Code. Document Number must
                          contain up to 7 digits.
                      
     * 
     * @param documentNumber
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /** 
     * Get the 'CommissionPercentage' element value. Commission percentage in range 0-99.
     * 
     * @return value
     */
    public String getCommissionPercentage() {
        return commissionPercentage;
    }

    /** 
     * Set the 'CommissionPercentage' element value. Commission percentage in range 0-99.
     * 
     * @param commissionPercentage
     */
    public void setCommissionPercentage(String commissionPercentage) {
        this.commissionPercentage = commissionPercentage;
    }

    /** 
     * Get the 'CommissionAmount' element value. Commission amount in range 0-9,999,999.99.
     * 
     * @return value
     */
    public String getCommissionAmount() {
        return commissionAmount;
    }

    /** 
     * Set the 'CommissionAmount' element value. Commission amount in range 0-9,999,999.99.
     * 
     * @param commissionAmount
     */
    public void setCommissionAmount(String commissionAmount) {
        this.commissionAmount = commissionAmount;
    }

    /** 
     * Get the 'Fare' element value. Fare amount in range 0-9,999,999.99.
     * 
     * @return value
     */
    public String getFare() {
        return fare;
    }

    /** 
     * Set the 'Fare' element value. Fare amount in range 0-9,999,999.99.
     * 
     * @param fare
     */
    public void setFare(String fare) {
        this.fare = fare;
    }

    /** 
     * Get the 'BaseFare' element value. Base fare amount in range 0-9,999,999.99.
     * 
     * @return value
     */
    public String getBaseFare() {
        return baseFare;
    }

    /** 
     * Set the 'BaseFare' element value. Base fare amount in range 0-9,999,999.99.
     * 
     * @param baseFare
     */
    public void setBaseFare(String baseFare) {
        this.baseFare = baseFare;
    }

    /** 
     * Get the 'BasePercent' element value. Base fare percentage in range 0-99.
     * 
     * @return value
     */
    public String getBasePercent() {
        return basePercent;
    }

    /** 
     * Set the 'BasePercent' element value. Base fare percentage in range 0-99.
     * 
     * @param basePercent
     */
    public void setBasePercent(String basePercent) {
        this.basePercent = basePercent;
    }

    /** 
     * Get the 'TaxPercentage' element value.
     * 
     * @return value
     */
    public String getTaxPercentage() {
        return taxPercentage;
    }

    /** 
     * Set the 'TaxPercentage' element value.
     * 
     * @param taxPercentage
     */
    public void setTaxPercentage(String taxPercentage) {
        this.taxPercentage = taxPercentage;
    }

    /** 
     * Get the 'TaxAmount' element value. Tax amount in range 0-9,999,999.99.
     * 
     * @return value
     */
    public String getTaxAmount() {
        return taxAmount;
    }

    /** 
     * Set the 'TaxAmount' element value. Tax amount in range 0-9,999,999.99.
     * 
     * @param taxAmount
     */
    public void setTaxAmount(String taxAmount) {
        this.taxAmount = taxAmount;
    }

    /** 
     * Get the 'TaxSurchargeCode2' element value.
     * 
     * @return value
     */
    public String getTaxSurchargeCode2() {
        return taxSurchargeCode2;
    }

    /** 
     * Set the 'TaxSurchargeCode2' element value.
     * 
     * @param taxSurchargeCode2
     */
    public void setTaxSurchargeCode2(String taxSurchargeCode2) {
        this.taxSurchargeCode2 = taxSurchargeCode2;
    }

    /** 
     * Get the 'GSTCode' element value. Goods and Services Tax or Value-Added Tax code: A, B, C or D.
     * 
     * @return value
     */
    public String getGSTCode() {
        return GSTCode;
    }

    /** 
     * Set the 'GSTCode' element value. Goods and Services Tax or Value-Added Tax code: A, B, C or D.
     * 
     * @param GSTCode
     */
    public void setGSTCode(String GSTCode) {
        this.GSTCode = GSTCode;
    }

    /** 
     * Get the 'GSTAmount' element value. Goods and Services Tax or Value-Added Tax amount in range 0-9,999,999.99.
                      
     * 
     * @return value
     */
    public String getGSTAmount() {
        return GSTAmount;
    }

    /** 
     * Set the 'GSTAmount' element value. Goods and Services Tax or Value-Added Tax amount in range 0-9,999,999.99.
                      
     * 
     * @param GSTAmount
     */
    public void setGSTAmount(String GSTAmount) {
        this.GSTAmount = GSTAmount;
    }

    /** 
     * Get the 'GSTPercent' element value. Goods and Services Tax or Value-Added Tax percentage in range 0-99.
                      
     * 
     * @return value
     */
    public String getGSTPercent() {
        return GSTPercent;
    }

    /** 
     * Set the 'GSTPercent' element value. Goods and Services Tax or Value-Added Tax percentage in range 0-99.
                      
     * 
     * @param GSTPercent
     */
    public void setGSTPercent(String GSTPercent) {
        this.GSTPercent = GSTPercent;
    }

    /** 
     * Get the 'QSTCode' element value. Quebec Sales Tax code: A, B, C or D.
     * 
     * @return value
     */
    public String getQSTCode() {
        return QSTCode;
    }

    /** 
     * Set the 'QSTCode' element value. Quebec Sales Tax code: A, B, C or D.
     * 
     * @param QSTCode
     */
    public void setQSTCode(String QSTCode) {
        this.QSTCode = QSTCode;
    }

    /** 
     * Get the 'QSTAmount' element value. Quebec Sales Tax amount in range 0-9,999,999.99.
     * 
     * @return value
     */
    public String getQSTAmount() {
        return QSTAmount;
    }

    /** 
     * Set the 'QSTAmount' element value. Quebec Sales Tax amount in range 0-9,999,999.99.
     * 
     * @param QSTAmount
     */
    public void setQSTAmount(String QSTAmount) {
        this.QSTAmount = QSTAmount;
    }

    /** 
     * Get the 'QSTPercent' element value. Quebec Sales Tax percentage in range 0-99.
     * 
     * @return value
     */
    public String getQSTPercent() {
        return QSTPercent;
    }

    /** 
     * Set the 'QSTPercent' element value. Quebec Sales Tax percentage in range 0-99.
     * 
     * @param QSTPercent
     */
    public void setQSTPercent(String QSTPercent) {
        this.QSTPercent = QSTPercent;
    }

    /** 
     * Get the 'CreditCardNumber' element value. Credit Card Number containing at most 16 digits.
     * 
     * @return value
     */
    public String getCreditCardNumber() {
        return creditCardNumber;
    }

    /** 
     * Set the 'CreditCardNumber' element value. Credit Card Number containing at most 16 digits.
     * 
     * @param creditCardNumber
     */
    public void setCreditCardNumber(String creditCardNumber) {
        this.creditCardNumber = creditCardNumber;
    }

    /** 
     * Get the 'CreditCardCode' element value. Two-letter code of Credit Card provider.
     * 
     * @return value
     */
    public String getCreditCardCode() {
        return creditCardCode;
    }

    /** 
     * Set the 'CreditCardCode' element value. Two-letter code of Credit Card provider.
     * 
     * @param creditCardCode
     */
    public void setCreditCardCode(String creditCardCode) {
        this.creditCardCode = creditCardCode;
    }

    /** 
     * Get the 'PassengerName' element value. Passenger used in Form of Payment association (if Fare Application is ONE). Entry
                          must follow the pattern: [Name Number][Surname] [Given name or initial]
                      
     * 
     * @return value
     */
    public String getPassengerName() {
        return passengerName;
    }

    /** 
     * Set the 'PassengerName' element value. Passenger used in Form of Payment association (if Fare Application is ONE). Entry
                          must follow the pattern: [Name Number][Surname] [Given name or initial]
                      
     * 
     * @param passengerName
     */
    public void setPassengerName(String passengerName) {
        this.passengerName = passengerName;
    }

    /** 
     * Get the 'NumberOfConjunctedDocuments' element value. Number of documents the Accounting Line applies to. Amount in range 1-9
                      
     * 
     * @return value
     */
    public String getNumberOfConjunctedDocuments() {
        return numberOfConjunctedDocuments;
    }

    /** 
     * Set the 'NumberOfConjunctedDocuments' element value. Number of documents the Accounting Line applies to. Amount in range 1-9
                      
     * 
     * @param numberOfConjunctedDocuments
     */
    public void setNumberOfConjunctedDocuments(
            String numberOfConjunctedDocuments) {
        this.numberOfConjunctedDocuments = numberOfConjunctedDocuments;
    }

    /** 
     * Get the 'NumberOfCoupons' element value.
     * 
     * @return value
     */
    public String getNumberOfCoupons() {
        return numberOfCoupons;
    }

    /** 
     * Set the 'NumberOfCoupons' element value.
     * 
     * @param numberOfCoupons
     */
    public void setNumberOfCoupons(String numberOfCoupons) {
        this.numberOfCoupons = numberOfCoupons;
    }

    /** 
     * Get the 'OriginalTicketNumber' element value.
     * 
     * @return value
     */
    public String getOriginalTicketNumber() {
        return originalTicketNumber;
    }

    /** 
     * Set the 'OriginalTicketNumber' element value.
     * 
     * @param originalTicketNumber
     */
    public void setOriginalTicketNumber(String originalTicketNumber) {
        this.originalTicketNumber = originalTicketNumber;
    }

    /** 
     * Get the 'OriginalDateOfIssue' element value.
     * 
     * @return value
     */
    public String getOriginalDateOfIssue() {
        return originalDateOfIssue;
    }

    /** 
     * Set the 'OriginalDateOfIssue' element value.
     * 
     * @param originalDateOfIssue
     */
    public void setOriginalDateOfIssue(String originalDateOfIssue) {
        this.originalDateOfIssue = originalDateOfIssue;
    }

    /** 
     * Get the 'OriginalPlaceOfIssue' element value.
     * 
     * @return value
     */
    public String getOriginalPlaceOfIssue() {
        return originalPlaceOfIssue;
    }

    /** 
     * Set the 'OriginalPlaceOfIssue' element value.
     * 
     * @param originalPlaceOfIssue
     */
    public void setOriginalPlaceOfIssue(String originalPlaceOfIssue) {
        this.originalPlaceOfIssue = originalPlaceOfIssue;
    }

    /** 
     * Get the 'FullPartialExchangeIndicator' element value.
     * 
     * @return value
     */
    public String getFullPartialExchangeIndicator() {
        return fullPartialExchangeIndicator;
    }

    /** 
     * Set the 'FullPartialExchangeIndicator' element value.
     * 
     * @param fullPartialExchangeIndicator
     */
    public void setFullPartialExchangeIndicator(
            String fullPartialExchangeIndicator) {
        this.fullPartialExchangeIndicator = fullPartialExchangeIndicator;
    }

    /** 
     * Get the 'OriginalInvoice' element value.
     * 
     * @return value
     */
    public String getOriginalInvoice() {
        return originalInvoice;
    }

    /** 
     * Set the 'OriginalInvoice' element value.
     * 
     * @param originalInvoice
     */
    public void setOriginalInvoice(String originalInvoice) {
        this.originalInvoice = originalInvoice;
    }

    /** 
     * Get the 'TarriffBasis' element value.
     * 
     * @return value
     */
    public String getTarriffBasis() {
        return tarriffBasis;
    }

    /** 
     * Set the 'TarriffBasis' element value.
     * 
     * @param tarriffBasis
     */
    public void setTarriffBasis(String tarriffBasis) {
        this.tarriffBasis = tarriffBasis;
    }

    /** 
     * Get the 'FreeFormText' element value. Optional text which can contain up to 29 characters.
     * 
     * @return value
     */
    public String getFreeFormText() {
        return freeFormText;
    }

    /** 
     * Set the 'FreeFormText' element value. Optional text which can contain up to 29 characters.
     * 
     * @param freeFormText
     */
    public void setFreeFormText(String freeFormText) {
        this.freeFormText = freeFormText;
    }

    /** 
     * Get the 'CurrencyCode' element value. Three-letter currency code.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Three-letter currency code.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'SegmentType' element value. Type of segment the Accounting Line is associated to, e.g. RAL.
                      
     * 
     * @return value
     */
    public String getSegmentType() {
        return segmentType;
    }

    /** 
     * Set the 'SegmentType' element value. Type of segment the Accounting Line is associated to, e.g. RAL.
                      
     * 
     * @param segmentType
     */
    public void setSegmentType(String segmentType) {
        this.segmentType = segmentType;
    }

    /** 
     * Get the 'SegmentNumber' element value. Number of segment the Accounting Line is associated to.
     * 
     * @return value
     */
    public String getSegmentNumber() {
        return segmentNumber;
    }

    /** 
     * Set the 'SegmentNumber' element value. Number of segment the Accounting Line is associated to.
     * 
     * @param segmentNumber
     */
    public void setSegmentNumber(String segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    /** 
     * Get the 'TransactionInd' element value.
     * 
     * @return value
     */
    public String getTransactionInd() {
        return transactionInd;
    }

    /** 
     * Set the 'TransactionInd' element value.
     * 
     * @param transactionInd
     */
    public void setTransactionInd(String transactionInd) {
        this.transactionInd = transactionInd;
    }

    /** 
     * Get the 'AccountingLineText' element value.
     * 
     * @return value
     */
    public String getAccountingLineText() {
        return accountingLineText;
    }

    /** 
     * Set the 'AccountingLineText' element value.
     * 
     * @param accountingLineText
     */
    public void setAccountingLineText(String accountingLineText) {
        this.accountingLineText = accountingLineText;
    }

    /** 
     * Get the 'NetFareAmount' element value.
     * 
     * @return value
     */
    public String getNetFareAmount() {
        return netFareAmount;
    }

    /** 
     * Set the 'NetFareAmount' element value.
     * 
     * @param netFareAmount
     */
    public void setNetFareAmount(String netFareAmount) {
        this.netFareAmount = netFareAmount;
    }

    /** 
     * Get the 'NetFareIndicator' element value.
     * 
     * @return value
     */
    public String getNetFareIndicator() {
        return netFareIndicator;
    }

    /** 
     * Set the 'NetFareIndicator' element value.
     * 
     * @param netFareIndicator
     */
    public void setNetFareIndicator(String netFareIndicator) {
        this.netFareIndicator = netFareIndicator;
    }

    /** 
     * Get the 'SpecialActionIndicator' element value.
     * 
     * @return value
     */
    public SpecialActionIndicatorPNRB getSpecialActionIndicator() {
        return specialActionIndicator;
    }

    /** 
     * Set the 'SpecialActionIndicator' element value.
     * 
     * @param specialActionIndicator
     */
    public void setSpecialActionIndicator(
            SpecialActionIndicatorPNRB specialActionIndicator) {
        this.specialActionIndicator = specialActionIndicator;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'index' attribute value.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'elementId' attribute value.
     * 
     * @return value
     */
    public String getElementId() {
        return elementId;
    }

    /** 
     * Set the 'elementId' attribute value.
     * 
     * @param elementId
     */
    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    /** 
     * Get the 'automated' attribute value.
     * 
     * @return value
     */
    public Boolean getAutomated() {
        return automated;
    }

    /** 
     * Set the 'automated' attribute value.
     * 
     * @param automated
     */
    public void setAutomated(Boolean automated) {
        this.automated = automated;
    }
}
