
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Air">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AirType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="CheckInAirline" minOccurs="0">
 *           &lt;!-- Reference to inner class CheckInAirline -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:string" use="optional" name="RPH"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class Air extends AirType implements Serializable
{
    private CheckInAirline checkInAirline;
    private String RPH;

    /** 
     * Get the 'CheckInAirline' element value.
     * 
     * @return value
     */
    public CheckInAirline getCheckInAirline() {
        return checkInAirline;
    }

    /** 
     * Set the 'CheckInAirline' element value.
     * 
     * @param checkInAirline
     */
    public void setCheckInAirline(CheckInAirline checkInAirline) {
        this.checkInAirline = checkInAirline;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                              in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                          
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                              in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                          
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CheckInAirline" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="CompanyShortName"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CheckInAirline implements Serializable
    {
        private String code;
        private String companyShortName;

        /** 
         * Get the 'Code' attribute value. "Code" is used to return the check in airline code associated with the particular flight segment.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value. "Code" is used to return the check in airline code associated with the particular flight segment.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'CompanyShortName' attribute value. "CompanyShortName" is used to return the check in airline name.
         * 
         * @return value
         */
        public String getCompanyShortName() {
            return companyShortName;
        }

        /** 
         * Set the 'CompanyShortName' attribute value. "CompanyShortName" is used to return the check in airline name.
         * 
         * @param companyShortName
         */
        public void setCompanyShortName(String companyShortName) {
            this.companyShortName = companyShortName;
        }
    }
}
