
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Used to update air segment information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirSegmentPartialUpdate.PNRB">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:ConfirmationUpdate.PNRB" name="ConfirmationUpdate"/>
 *     &lt;xs:element type="ns:AirActionCodeUpdate.PNRB" name="ActionCodeUpdate"/>
 *     &lt;xs:element type="ns:ClassOfServiceUpdate.PNRB" name="ClassOfServiceUpdate"/>
 *   &lt;/xs:choice>
 *   &lt;xs:attribute type="xs:string" use="required" name="id"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirSegmentPartialUpdatePNRB implements Serializable
{
    private int choiceSelect = -1;
    private static final int CONFIRMATION_UPDATE_CHOICE = 0;
    private static final int ACTION_CODE_UPDATE_CHOICE = 1;
    private static final int CLASS_OF_SERVICE_UPDATE_CHOICE = 2;
    private ConfirmationUpdatePNRB confirmationUpdate;
    private AirActionCodeUpdatePNRB actionCodeUpdate;
    private ClassOfServiceUpdatePNRB classOfServiceUpdate;
    private String id;
    private OperationTypePNRB op;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if ConfirmationUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifConfirmationUpdate() {
        return choiceSelect == CONFIRMATION_UPDATE_CHOICE;
    }

    /** 
     * Get the 'ConfirmationUpdate' element value.
     * 
     * @return value
     */
    public ConfirmationUpdatePNRB getConfirmationUpdate() {
        return confirmationUpdate;
    }

    /** 
     * Set the 'ConfirmationUpdate' element value.
     * 
     * @param confirmationUpdate
     */
    public void setConfirmationUpdate(ConfirmationUpdatePNRB confirmationUpdate) {
        setChoiceSelect(CONFIRMATION_UPDATE_CHOICE);
        this.confirmationUpdate = confirmationUpdate;
    }

    /** 
     * Check if ActionCodeUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifActionCodeUpdate() {
        return choiceSelect == ACTION_CODE_UPDATE_CHOICE;
    }

    /** 
     * Get the 'ActionCodeUpdate' element value.
     * 
     * @return value
     */
    public AirActionCodeUpdatePNRB getActionCodeUpdate() {
        return actionCodeUpdate;
    }

    /** 
     * Set the 'ActionCodeUpdate' element value.
     * 
     * @param actionCodeUpdate
     */
    public void setActionCodeUpdate(AirActionCodeUpdatePNRB actionCodeUpdate) {
        setChoiceSelect(ACTION_CODE_UPDATE_CHOICE);
        this.actionCodeUpdate = actionCodeUpdate;
    }

    /** 
     * Check if ClassOfServiceUpdate is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifClassOfServiceUpdate() {
        return choiceSelect == CLASS_OF_SERVICE_UPDATE_CHOICE;
    }

    /** 
     * Get the 'ClassOfServiceUpdate' element value.
     * 
     * @return value
     */
    public ClassOfServiceUpdatePNRB getClassOfServiceUpdate() {
        return classOfServiceUpdate;
    }

    /** 
     * Set the 'ClassOfServiceUpdate' element value.
     * 
     * @param classOfServiceUpdate
     */
    public void setClassOfServiceUpdate(
            ClassOfServiceUpdatePNRB classOfServiceUpdate) {
        setChoiceSelect(CLASS_OF_SERVICE_UPDATE_CHOICE);
        this.classOfServiceUpdate = classOfServiceUpdate;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }
}
