
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DepartureAirport" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DepartureAirportCodeContext" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DepartureTerminalName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DepartureTerminalCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ArrivalAirport" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ArrivalAirportCodeContext" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ArrivalTerminalName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ArrivalTerminalCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OperatingAirlineCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OperatingAirlineShortName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OperatingFlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="ns:OperatingAirlinePricing" name="OperatingAirlinePricing" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="EquipmentType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MarketingAirlineCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MarketingFlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OperatingClassOfService" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MarketingClassOfService" minOccurs="0"/>
 *     &lt;xs:element name="DisclosureCarrier" minOccurs="0">
 *       &lt;!-- Reference to inner class DisclosureCarrier -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="CodeShareOperatingRecordLocator" minOccurs="0"/>
 *     &lt;xs:element name="MarriageGrp" minOccurs="0">
 *       &lt;!-- Reference to inner class MarriageGrp -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="MarriedConnectionIndicator" minOccurs="0"/>
 *     &lt;xs:element name="Meal" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Meal -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:Seats.PNRB" name="Seats" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AirlineRefId" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="Eticket" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DepartureDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ArrivalDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FlightNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ClassOfService" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PreviousActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="NumberInParty" minOccurs="0"/>
 *     &lt;xs:element type="ns:ItinerarySpecialRequests.PNRB" name="SegmentSpecialRequests" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="inboundConnection" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="outboundConnection" minOccurs="0"/>
 *     &lt;xs:element name="AncillaryServices" minOccurs="0">
 *       &lt;!-- Reference to inner class AncillaryServices -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:boolean" name="BSGIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BSGPNRRecordLocator" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="BSGPNRCreatedDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="PassiveSegmentIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="ScheduleChangeIndicator" minOccurs="0"/>
 *     &lt;xs:element type="xs:dateTime" name="SegmentBookedDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ElapsedTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AirMilesFlown" minOccurs="0"/>
 *     &lt;xs:element name="HiddenStop" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class HiddenStop -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:boolean" name="FunnelFlight" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="ChangeOfGauge" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="UpdatedDepartureDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="UpdatedDepartureTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="UpdatedArrivalTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ScheduledDepartureDateTime" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ScheduledArrivalDateTime" minOccurs="0"/>
 *     &lt;xs:element type="ns:AirPosType.PNRB" name="Pos" minOccurs="0"/>
 *     &lt;xs:element type="ns:FqtvUpgradeRequests" name="FqtvUpgradeRequests" minOccurs="0"/>
 *     &lt;xs:element type="ns:ODDataType" name="ODData" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="InstantPurchase" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BrandID" minOccurs="0"/>
 *     &lt;xs:element name="Cabin" minOccurs="0">
 *       &lt;!-- Reference to inner class Cabin -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Banner" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="OtherAirlineSign" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="Informational" minOccurs="0"/>
 *     &lt;xs:element type="ns:RdbAvailableSeatCountType.PNRB" name="RdbAvailableSeatCounts" minOccurs="0"/>
 *     &lt;xs:element name="ODReevalAtETData" minOccurs="0">
 *       &lt;!-- Reference to inner class ODReevalAtETData -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="TimeSinceBooked" minOccurs="0"/>
 *     &lt;xs:element name="AlliancePartnerGroup" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class AlliancePartnerGroup -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:integer" name="index"/>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="xs:short" name="sequence"/>
 *   &lt;xs:attribute type="xs:short" name="segmentAssociationId"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="isPast"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DayOfWeekInd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ArrivalDayOfWeekInd"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="CodeShare"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="SpecialMeal"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="StopQuantity"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="SmokingAllowed"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ResBookDesigCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="isIgnored"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AirType implements Serializable
{
    private String departureAirport;
    private String departureAirportCodeContext;
    private String departureTerminalName;
    private String departureTerminalCode;
    private String arrivalAirport;
    private String arrivalAirportCodeContext;
    private String arrivalTerminalName;
    private String arrivalTerminalCode;
    private String operatingAirlineCode;
    private String operatingAirlineShortName;
    private String operatingFlightNumber;
    private OperatingAirlinePricing operatingAirlinePricing;
    private String equipmentType;
    private String marketingAirlineCode;
    private String marketingFlightNumber;
    private String operatingClassOfService;
    private String marketingClassOfService;
    private DisclosureCarrier disclosureCarrier;
    private String codeShareOperatingRecordLocator;
    private MarriageGrp marriageGrp;
    private String marriedConnectionIndicator;
    private List<Meal> mealList = new ArrayList<Meal>();
    private SeatsPNRB seats;
    private String airlineRefId;
    private Boolean eticket;
    private String departureDateTime;
    private String arrivalDateTime;
    private String flightNumber;
    private String classOfService;
    private String actionCode;
    private String previousActionCode;
    private BigInteger numberInParty;
    private ItinerarySpecialRequestsPNRB segmentSpecialRequests;
    private Boolean inboundConnection;
    private Boolean outboundConnection;
    private AncillaryServices ancillaryServices;
    private Boolean BSGIndicator;
    private String BSGPNRRecordLocator;
    private Date BSGPNRCreatedDate;
    private Boolean passiveSegmentIndicator;
    private Boolean scheduleChangeIndicator;
    private Date segmentBookedDate;
    private String elapsedTime;
    private String airMilesFlown;
    private List<HiddenStop> hiddenStopList = new ArrayList<HiddenStop>();
    private Boolean funnelFlight;
    private Boolean changeOfGauge;
    private String updatedDepartureDate;
    private String updatedDepartureTime;
    private String updatedArrivalTime;
    private String scheduledDepartureDateTime;
    private String scheduledArrivalDateTime;
    private AirPosTypePNRB pos;
    private FqtvUpgradeRequests fqtvUpgradeRequests;
    private ODDataType ODData;
    private Boolean instantPurchase;
    private String brandID;
    private Cabin cabin;
    private String banner;
    private String otherAirlineSign;
    private Boolean informational;
    private RdbAvailableSeatCountTypePNRB rdbAvailableSeatCounts;
    private ODReevalAtETData ODReevalAtETData1;
    private String timeSinceBooked;
    private AlliancePartnerGroup alliancePartnerGroup;
    private BigInteger index;
    private String id;
    private Short sequence;
    private Short segmentAssociationId;
    private OperationTypePNRB op;
    private Boolean isPast;
    private String dayOfWeekInd;
    private String arrivalDayOfWeekInd;
    private Boolean codeShare;
    private Boolean specialMeal;
    private String stopQuantity;
    private Boolean smokingAllowed;
    private String resBookDesigCode;
    private String code;
    private Boolean isIgnored;

    /** 
     * Get the 'DepartureAirport' element value. Departure point of flight segment.
                      
     * 
     * @return value
     */
    public String getDepartureAirport() {
        return departureAirport;
    }

    /** 
     * Set the 'DepartureAirport' element value. Departure point of flight segment.
                      
     * 
     * @param departureAirport
     */
    public void setDepartureAirport(String departureAirport) {
        this.departureAirport = departureAirport;
    }

    /** 
     * Get the 'DepartureAirportCodeContext' element value. IATA. Ex."IATA"
     * 
     * @return value
     */
    public String getDepartureAirportCodeContext() {
        return departureAirportCodeContext;
    }

    /** 
     * Set the 'DepartureAirportCodeContext' element value. IATA. Ex."IATA"
     * 
     * @param departureAirportCodeContext
     */
    public void setDepartureAirportCodeContext(
            String departureAirportCodeContext) {
        this.departureAirportCodeContext = departureAirportCodeContext;
    }

    /** 
     * Get the 'DepartureTerminalName' element value.
     * 
     * @return value
     */
    public String getDepartureTerminalName() {
        return departureTerminalName;
    }

    /** 
     * Set the 'DepartureTerminalName' element value.
     * 
     * @param departureTerminalName
     */
    public void setDepartureTerminalName(String departureTerminalName) {
        this.departureTerminalName = departureTerminalName;
    }

    /** 
     * Get the 'DepartureTerminalCode' element value.
     * 
     * @return value
     */
    public String getDepartureTerminalCode() {
        return departureTerminalCode;
    }

    /** 
     * Set the 'DepartureTerminalCode' element value.
     * 
     * @param departureTerminalCode
     */
    public void setDepartureTerminalCode(String departureTerminalCode) {
        this.departureTerminalCode = departureTerminalCode;
    }

    /** 
     * Get the 'ArrivalAirport' element value. Arrival airport point of flight segment.
                      
     * 
     * @return value
     */
    public String getArrivalAirport() {
        return arrivalAirport;
    }

    /** 
     * Set the 'ArrivalAirport' element value. Arrival airport point of flight segment.
                      
     * 
     * @param arrivalAirport
     */
    public void setArrivalAirport(String arrivalAirport) {
        this.arrivalAirport = arrivalAirport;
    }

    /** 
     * Get the 'ArrivalAirportCodeContext' element value. IATA. Ex."IATA"
     * 
     * @return value
     */
    public String getArrivalAirportCodeContext() {
        return arrivalAirportCodeContext;
    }

    /** 
     * Set the 'ArrivalAirportCodeContext' element value. IATA. Ex."IATA"
     * 
     * @param arrivalAirportCodeContext
     */
    public void setArrivalAirportCodeContext(String arrivalAirportCodeContext) {
        this.arrivalAirportCodeContext = arrivalAirportCodeContext;
    }

    /** 
     * Get the 'ArrivalTerminalName' element value.
     * 
     * @return value
     */
    public String getArrivalTerminalName() {
        return arrivalTerminalName;
    }

    /** 
     * Set the 'ArrivalTerminalName' element value.
     * 
     * @param arrivalTerminalName
     */
    public void setArrivalTerminalName(String arrivalTerminalName) {
        this.arrivalTerminalName = arrivalTerminalName;
    }

    /** 
     * Get the 'ArrivalTerminalCode' element value.
     * 
     * @return value
     */
    public String getArrivalTerminalCode() {
        return arrivalTerminalCode;
    }

    /** 
     * Set the 'ArrivalTerminalCode' element value.
     * 
     * @param arrivalTerminalCode
     */
    public void setArrivalTerminalCode(String arrivalTerminalCode) {
        this.arrivalTerminalCode = arrivalTerminalCode;
    }

    /** 
     * Get the 'OperatingAirlineCode' element value. The operating airline of the flight if it is a
                          codeshare flight.
                      
     * 
     * @return value
     */
    public String getOperatingAirlineCode() {
        return operatingAirlineCode;
    }

    /** 
     * Set the 'OperatingAirlineCode' element value. The operating airline of the flight if it is a
                          codeshare flight.
                      
     * 
     * @param operatingAirlineCode
     */
    public void setOperatingAirlineCode(String operatingAirlineCode) {
        this.operatingAirlineCode = operatingAirlineCode;
    }

    /** 
     * Get the 'OperatingAirlineShortName' element value.
     * 
     * @return value
     */
    public String getOperatingAirlineShortName() {
        return operatingAirlineShortName;
    }

    /** 
     * Set the 'OperatingAirlineShortName' element value.
     * 
     * @param operatingAirlineShortName
     */
    public void setOperatingAirlineShortName(String operatingAirlineShortName) {
        this.operatingAirlineShortName = operatingAirlineShortName;
    }

    /** 
     * Get the 'OperatingFlightNumber' element value. The operating carrier flight number of the
                          flight.
                      
     * 
     * @return value
     */
    public String getOperatingFlightNumber() {
        return operatingFlightNumber;
    }

    /** 
     * Set the 'OperatingFlightNumber' element value. The operating carrier flight number of the
                          flight.
                      
     * 
     * @param operatingFlightNumber
     */
    public void setOperatingFlightNumber(String operatingFlightNumber) {
        this.operatingFlightNumber = operatingFlightNumber;
    }

    /** 
     * Get the 'OperatingAirlinePricing' element value. Operating airline pricing.
     * 
     * @return value
     */
    public OperatingAirlinePricing getOperatingAirlinePricing() {
        return operatingAirlinePricing;
    }

    /** 
     * Set the 'OperatingAirlinePricing' element value. Operating airline pricing.
     * 
     * @param operatingAirlinePricing
     */
    public void setOperatingAirlinePricing(
            OperatingAirlinePricing operatingAirlinePricing) {
        this.operatingAirlinePricing = operatingAirlinePricing;
    }

    /** 
     * Get the 'EquipmentType' element value. Code used to describe the aircraft type. Example "73H"
     * 
     * @return value
     */
    public String getEquipmentType() {
        return equipmentType;
    }

    /** 
     * Set the 'EquipmentType' element value. Code used to describe the aircraft type. Example "73H"
     * 
     * @param equipmentType
     */
    public void setEquipmentType(String equipmentType) {
        this.equipmentType = equipmentType;
    }

    /** 
     * Get the 'MarketingAirlineCode' element value. Identifies a company
                          by the company code.
                      
     * 
     * @return value
     */
    public String getMarketingAirlineCode() {
        return marketingAirlineCode;
    }

    /** 
     * Set the 'MarketingAirlineCode' element value. Identifies a company
                          by the company code.
                      
     * 
     * @param marketingAirlineCode
     */
    public void setMarketingAirlineCode(String marketingAirlineCode) {
        this.marketingAirlineCode = marketingAirlineCode;
    }

    /** 
     * Get the 'MarketingFlightNumber' element value. The marketing carrier flight number of the
                          flight.
                      
     * 
     * @return value
     */
    public String getMarketingFlightNumber() {
        return marketingFlightNumber;
    }

    /** 
     * Set the 'MarketingFlightNumber' element value. The marketing carrier flight number of the
                          flight.
                      
     * 
     * @param marketingFlightNumber
     */
    public void setMarketingFlightNumber(String marketingFlightNumber) {
        this.marketingFlightNumber = marketingFlightNumber;
    }

    /** 
     * Get the 'OperatingClassOfService' element value. The marketing booking class of service indicated on the face of the PNR. Example
                          "Y"
                      
     * 
     * @return value
     */
    public String getOperatingClassOfService() {
        return operatingClassOfService;
    }

    /** 
     * Set the 'OperatingClassOfService' element value. The marketing booking class of service indicated on the face of the PNR. Example
                          "Y"
                      
     * 
     * @param operatingClassOfService
     */
    public void setOperatingClassOfService(String operatingClassOfService) {
        this.operatingClassOfService = operatingClassOfService;
    }

    /** 
     * Get the 'MarketingClassOfService' element value. The operating booking class of service indicated on the face of the PNR. Example
                          "Y"
                      
     * 
     * @return value
     */
    public String getMarketingClassOfService() {
        return marketingClassOfService;
    }

    /** 
     * Set the 'MarketingClassOfService' element value. The operating booking class of service indicated on the face of the PNR. Example
                          "Y"
                      
     * 
     * @param marketingClassOfService
     */
    public void setMarketingClassOfService(String marketingClassOfService) {
        this.marketingClassOfService = marketingClassOfService;
    }

    /** 
     * Get the 'DisclosureCarrier' element value.
     * 
     * @return value
     */
    public DisclosureCarrier getDisclosureCarrier() {
        return disclosureCarrier;
    }

    /** 
     * Set the 'DisclosureCarrier' element value.
     * 
     * @param disclosureCarrier
     */
    public void setDisclosureCarrier(DisclosureCarrier disclosureCarrier) {
        this.disclosureCarrier = disclosureCarrier;
    }

    /** 
     * Get the 'CodeShareOperatingRecordLocator' element value.
     * 
     * @return value
     */
    public String getCodeShareOperatingRecordLocator() {
        return codeShareOperatingRecordLocator;
    }

    /** 
     * Set the 'CodeShareOperatingRecordLocator' element value.
     * 
     * @param codeShareOperatingRecordLocator
     */
    public void setCodeShareOperatingRecordLocator(
            String codeShareOperatingRecordLocator) {
        this.codeShareOperatingRecordLocator = codeShareOperatingRecordLocator;
    }

    /** 
     * Get the 'MarriageGrp' element value.
     * 
     * @return value
     */
    public MarriageGrp getMarriageGrp() {
        return marriageGrp;
    }

    /** 
     * Set the 'MarriageGrp' element value.
     * 
     * @param marriageGrp
     */
    public void setMarriageGrp(MarriageGrp marriageGrp) {
        this.marriageGrp = marriageGrp;
    }

    /** 
     * Get the 'MarriedConnectionIndicator' element value.
     * 
     * @return value
     */
    public String getMarriedConnectionIndicator() {
        return marriedConnectionIndicator;
    }

    /** 
     * Set the 'MarriedConnectionIndicator' element value.
     * 
     * @param marriedConnectionIndicator
     */
    public void setMarriedConnectionIndicator(String marriedConnectionIndicator) {
        this.marriedConnectionIndicator = marriedConnectionIndicator;
    }

    /** 
     * Get the list of 'Meal' element items.
     * 
     * @return list
     */
    public List<Meal> getMealList() {
        return mealList;
    }

    /** 
     * Set the list of 'Meal' element items.
     * 
     * @param list
     */
    public void setMealList(List<Meal> list) {
        mealList = list;
    }

    /** 
     * Get the 'Seats' element value.
     * 
     * @return value
     */
    public SeatsPNRB getSeats() {
        return seats;
    }

    /** 
     * Set the 'Seats' element value.
     * 
     * @param seats
     */
    public void setSeats(SeatsPNRB seats) {
        this.seats = seats;
    }

    /** 
     * Get the 'AirlineRefId' element value. 2 char code indicating method other airlines segment was added. Example
                          "VA*XBZVGY"
                      
     * 
     * @return value
     */
    public String getAirlineRefId() {
        return airlineRefId;
    }

    /** 
     * Set the 'AirlineRefId' element value. 2 char code indicating method other airlines segment was added. Example
                          "VA*XBZVGY"
                      
     * 
     * @param airlineRefId
     */
    public void setAirlineRefId(String airlineRefId) {
        this.airlineRefId = airlineRefId;
    }

    /** 
     * Get the 'Eticket' element value. True/False indicator. Example "TRUE"
     * 
     * @return value
     */
    public Boolean getEticket() {
        return eticket;
    }

    /** 
     * Set the 'Eticket' element value. True/False indicator. Example "TRUE"
     * 
     * @param eticket
     */
    public void setEticket(Boolean eticket) {
        this.eticket = eticket;
    }

    /** 
     * Get the 'DepartureDateTime' element value.
     * 
     * @return value
     */
    public String getDepartureDateTime() {
        return departureDateTime;
    }

    /** 
     * Set the 'DepartureDateTime' element value.
     * 
     * @param departureDateTime
     */
    public void setDepartureDateTime(String departureDateTime) {
        this.departureDateTime = departureDateTime;
    }

    /** 
     * Get the 'ArrivalDateTime' element value.
     * 
     * @return value
     */
    public String getArrivalDateTime() {
        return arrivalDateTime;
    }

    /** 
     * Set the 'ArrivalDateTime' element value.
     * 
     * @param arrivalDateTime
     */
    public void setArrivalDateTime(String arrivalDateTime) {
        this.arrivalDateTime = arrivalDateTime;
    }

    /** 
     * Get the 'FlightNumber' element value. The flight number of the flight.
                      
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. The flight number of the flight.
                      
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'ClassOfService' element value. Specific Booking
                          Class for this segment.
                      
     * 
     * @return value
     */
    public String getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value. Specific Booking
                          Class for this segment.
                      
     * 
     * @param classOfService
     */
    public void setClassOfService(String classOfService) {
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'ActionCode' element value. Current status of booked segment. Example "HK"
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. Current status of booked segment. Example "HK"
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'PreviousActionCode' element value. Previous status of booked segment. Example "NN"
     * 
     * @return value
     */
    public String getPreviousActionCode() {
        return previousActionCode;
    }

    /** 
     * Set the 'PreviousActionCode' element value. Previous status of booked segment. Example "NN"
     * 
     * @param previousActionCode
     */
    public void setPreviousActionCode(String previousActionCode) {
        this.previousActionCode = previousActionCode;
    }

    /** 
     * Get the 'NumberInParty' element value. Booked seats. Example "2"
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'NumberInParty' element value. Booked seats. Example "2"
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'SegmentSpecialRequests' element value.
     * 
     * @return value
     */
    public ItinerarySpecialRequestsPNRB getSegmentSpecialRequests() {
        return segmentSpecialRequests;
    }

    /** 
     * Set the 'SegmentSpecialRequests' element value.
     * 
     * @param segmentSpecialRequests
     */
    public void setSegmentSpecialRequests(
            ItinerarySpecialRequestsPNRB segmentSpecialRequests) {
        this.segmentSpecialRequests = segmentSpecialRequests;
    }

    /** 
     * Get the 'inboundConnection' element value. Indicates if connection from previous flight segment. Example "FALSE"
                      
     * 
     * @return value
     */
    public Boolean getInboundConnection() {
        return inboundConnection;
    }

    /** 
     * Set the 'inboundConnection' element value. Indicates if connection from previous flight segment. Example "FALSE"
                      
     * 
     * @param inboundConnection
     */
    public void setInboundConnection(Boolean inboundConnection) {
        this.inboundConnection = inboundConnection;
    }

    /** 
     * Get the 'outboundConnection' element value. Indicates if connection to the following flight segment. Example "FALSE"
                      
     * 
     * @return value
     */
    public Boolean getOutboundConnection() {
        return outboundConnection;
    }

    /** 
     * Set the 'outboundConnection' element value. Indicates if connection to the following flight segment. Example "FALSE"
                      
     * 
     * @param outboundConnection
     */
    public void setOutboundConnection(Boolean outboundConnection) {
        this.outboundConnection = outboundConnection;
    }

    /** 
     * Get the 'AncillaryServices' element value.
     * 
     * @return value
     */
    public AncillaryServices getAncillaryServices() {
        return ancillaryServices;
    }

    /** 
     * Set the 'AncillaryServices' element value.
     * 
     * @param ancillaryServices
     */
    public void setAncillaryServices(AncillaryServices ancillaryServices) {
        this.ancillaryServices = ancillaryServices;
    }

    /** 
     * Get the 'BSGIndicator' element value. Used to indicate group bookings.
     * 
     * @return value
     */
    public Boolean getBSGIndicator() {
        return BSGIndicator;
    }

    /** 
     * Set the 'BSGIndicator' element value. Used to indicate group bookings.
     * 
     * @param BSGIndicator
     */
    public void setBSGIndicator(Boolean BSGIndicator) {
        this.BSGIndicator = BSGIndicator;
    }

    /** 
     * Get the 'BSGPNRRecordLocator' element value. The Master or parent blocked space group PNR locator ID. The PNR locator of
                          the original blocked space group PNR.. Example "YOUZYG"
                      
     * 
     * @return value
     */
    public String getBSGPNRRecordLocator() {
        return BSGPNRRecordLocator;
    }

    /** 
     * Set the 'BSGPNRRecordLocator' element value. The Master or parent blocked space group PNR locator ID. The PNR locator of
                          the original blocked space group PNR.. Example "YOUZYG"
                      
     * 
     * @param BSGPNRRecordLocator
     */
    public void setBSGPNRRecordLocator(String BSGPNRRecordLocator) {
        this.BSGPNRRecordLocator = BSGPNRRecordLocator;
    }

    /** 
     * Get the 'BSGPNRCreatedDate' element value. The Master or parent blocked space group PNR create date.
                          The PNR create date of the original blocked space group PNR. Example "2012-11-23"
                      
     * 
     * @return value
     */
    public Date getBSGPNRCreatedDate() {
        return BSGPNRCreatedDate;
    }

    /** 
     * Set the 'BSGPNRCreatedDate' element value. The Master or parent blocked space group PNR create date.
                          The PNR create date of the original blocked space group PNR. Example "2012-11-23"
                      
     * 
     * @param BSGPNRCreatedDate
     */
    public void setBSGPNRCreatedDate(Date BSGPNRCreatedDate) {
        this.BSGPNRCreatedDate = BSGPNRCreatedDate;
    }

    /** 
     * Get the 'PassiveSegmentIndicator' element value. Passively booked segments notification.
     * 
     * @return value
     */
    public Boolean getPassiveSegmentIndicator() {
        return passiveSegmentIndicator;
    }

    /** 
     * Set the 'PassiveSegmentIndicator' element value. Passively booked segments notification.
     * 
     * @param passiveSegmentIndicator
     */
    public void setPassiveSegmentIndicator(Boolean passiveSegmentIndicator) {
        this.passiveSegmentIndicator = passiveSegmentIndicator;
    }

    /** 
     * Get the 'ScheduleChangeIndicator' element value. Notification regarding any schedule changes.
     * 
     * @return value
     */
    public Boolean getScheduleChangeIndicator() {
        return scheduleChangeIndicator;
    }

    /** 
     * Set the 'ScheduleChangeIndicator' element value. Notification regarding any schedule changes.
     * 
     * @param scheduleChangeIndicator
     */
    public void setScheduleChangeIndicator(Boolean scheduleChangeIndicator) {
        this.scheduleChangeIndicator = scheduleChangeIndicator;
    }

    /** 
     * Get the 'SegmentBookedDate' element value. Segment Booked date and time with format: YYYY-MM-DDThh:mm:ss
     * 
     * @return value
     */
    public Date getSegmentBookedDate() {
        return segmentBookedDate;
    }

    /** 
     * Set the 'SegmentBookedDate' element value. Segment Booked date and time with format: YYYY-MM-DDThh:mm:ss
     * 
     * @param segmentBookedDate
     */
    public void setSegmentBookedDate(Date segmentBookedDate) {
        this.segmentBookedDate = segmentBookedDate;
    }

    /** 
     * Get the 'ElapsedTime' element value. "ElapsedTime" is used to return the elapsed time associated with the particular
                          flight segment.
                      
     * 
     * @return value
     */
    public String getElapsedTime() {
        return elapsedTime;
    }

    /** 
     * Set the 'ElapsedTime' element value. "ElapsedTime" is used to return the elapsed time associated with the particular
                          flight segment.
                      
     * 
     * @param elapsedTime
     */
    public void setElapsedTime(String elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    /** 
     * Get the 'AirMilesFlown' element value. "AirMilesFlown" is used to return the air miles flown associated with the
                          particular flight segment.
                      
     * 
     * @return value
     */
    public String getAirMilesFlown() {
        return airMilesFlown;
    }

    /** 
     * Set the 'AirMilesFlown' element value. "AirMilesFlown" is used to return the air miles flown associated with the
                          particular flight segment.
                      
     * 
     * @param airMilesFlown
     */
    public void setAirMilesFlown(String airMilesFlown) {
        this.airMilesFlown = airMilesFlown;
    }

    /** 
     * Get the list of 'HiddenStop' element items.
     * 
     * @return list
     */
    public List<HiddenStop> getHiddenStopList() {
        return hiddenStopList;
    }

    /** 
     * Set the list of 'HiddenStop' element items.
     * 
     * @param list
     */
    public void setHiddenStopList(List<HiddenStop> list) {
        hiddenStopList = list;
    }

    /** 
     * Get the 'FunnelFlight' element value. "FunnelFlight" is used to determine a funnel flight type for flight segment.
                      
     * 
     * @return value
     */
    public Boolean getFunnelFlight() {
        return funnelFlight;
    }

    /** 
     * Set the 'FunnelFlight' element value. "FunnelFlight" is used to determine a funnel flight type for flight segment.
                      
     * 
     * @param funnelFlight
     */
    public void setFunnelFlight(Boolean funnelFlight) {
        this.funnelFlight = funnelFlight;
    }

    /** 
     * Get the 'ChangeOfGauge' element value. "ChangeOfGauge" is used to determine a change of gauge for flight segment.
                      
     * 
     * @return value
     */
    public Boolean getChangeOfGauge() {
        return changeOfGauge;
    }

    /** 
     * Set the 'ChangeOfGauge' element value. "ChangeOfGauge" is used to determine a change of gauge for flight segment.
                      
     * 
     * @param changeOfGauge
     */
    public void setChangeOfGauge(Boolean changeOfGauge) {
        this.changeOfGauge = changeOfGauge;
    }

    /** 
     * Get the 'UpdatedDepartureDate' element value. Updated departure information if applicable with format YYYY-MM-DD
                      
     * 
     * @return value
     */
    public String getUpdatedDepartureDate() {
        return updatedDepartureDate;
    }

    /** 
     * Set the 'UpdatedDepartureDate' element value. Updated departure information if applicable with format YYYY-MM-DD
                      
     * 
     * @param updatedDepartureDate
     */
    public void setUpdatedDepartureDate(String updatedDepartureDate) {
        this.updatedDepartureDate = updatedDepartureDate;
    }

    /** 
     * Get the 'UpdatedDepartureTime' element value. Updated departure information if applicable with format hh:mm
     * 
     * @return value
     */
    public String getUpdatedDepartureTime() {
        return updatedDepartureTime;
    }

    /** 
     * Set the 'UpdatedDepartureTime' element value. Updated departure information if applicable with format hh:mm
     * 
     * @param updatedDepartureTime
     */
    public void setUpdatedDepartureTime(String updatedDepartureTime) {
        this.updatedDepartureTime = updatedDepartureTime;
    }

    /** 
     * Get the 'UpdatedArrivalTime' element value. Updated arrival information if applicable with format hh:mm
     * 
     * @return value
     */
    public String getUpdatedArrivalTime() {
        return updatedArrivalTime;
    }

    /** 
     * Set the 'UpdatedArrivalTime' element value. Updated arrival information if applicable with format hh:mm
     * 
     * @param updatedArrivalTime
     */
    public void setUpdatedArrivalTime(String updatedArrivalTime) {
        this.updatedArrivalTime = updatedArrivalTime;
    }

    /** 
     * Get the 'ScheduledDepartureDateTime' element value. DSS departure information if applicable with format YYYY-MM-DDThh:mm:ss
     * 
     * @return value
     */
    public String getScheduledDepartureDateTime() {
        return scheduledDepartureDateTime;
    }

    /** 
     * Set the 'ScheduledDepartureDateTime' element value. DSS departure information if applicable with format YYYY-MM-DDThh:mm:ss
     * 
     * @param scheduledDepartureDateTime
     */
    public void setScheduledDepartureDateTime(String scheduledDepartureDateTime) {
        this.scheduledDepartureDateTime = scheduledDepartureDateTime;
    }

    /** 
     * Get the 'ScheduledArrivalDateTime' element value. DSS arrival information if applicable with format YYYY-MM-DDThh:mm:ss
     * 
     * @return value
     */
    public String getScheduledArrivalDateTime() {
        return scheduledArrivalDateTime;
    }

    /** 
     * Set the 'ScheduledArrivalDateTime' element value. DSS arrival information if applicable with format YYYY-MM-DDThh:mm:ss
     * 
     * @param scheduledArrivalDateTime
     */
    public void setScheduledArrivalDateTime(String scheduledArrivalDateTime) {
        this.scheduledArrivalDateTime = scheduledArrivalDateTime;
    }

    /** 
     * Get the 'Pos' element value.
     * 
     * @return value
     */
    public AirPosTypePNRB getPos() {
        return pos;
    }

    /** 
     * Set the 'Pos' element value.
     * 
     * @param pos
     */
    public void setPos(AirPosTypePNRB pos) {
        this.pos = pos;
    }

    /** 
     * Get the 'FqtvUpgradeRequests' element value.
     * 
     * @return value
     */
    public FqtvUpgradeRequests getFqtvUpgradeRequests() {
        return fqtvUpgradeRequests;
    }

    /** 
     * Set the 'FqtvUpgradeRequests' element value.
     * 
     * @param fqtvUpgradeRequests
     */
    public void setFqtvUpgradeRequests(FqtvUpgradeRequests fqtvUpgradeRequests) {
        this.fqtvUpgradeRequests = fqtvUpgradeRequests;
    }

    /** 
     * Get the 'ODData' element value. Pnr footprint data for bid price and fare
                          reference
                      
     * 
     * @return value
     */
    public ODDataType getODData() {
        return ODData;
    }

    /** 
     * Set the 'ODData' element value. Pnr footprint data for bid price and fare
                          reference
                      
     * 
     * @param ODData
     */
    public void setODData(ODDataType ODData) {
        this.ODData = ODData;
    }

    /** 
     * Get the 'InstantPurchase' element value. Indication of LCC segment. Example: FALSE
     * 
     * @return value
     */
    public Boolean getInstantPurchase() {
        return instantPurchase;
    }

    /** 
     * Set the 'InstantPurchase' element value. Indication of LCC segment. Example: FALSE
     * 
     * @param instantPurchase
     */
    public void setInstantPurchase(Boolean instantPurchase) {
        this.instantPurchase = instantPurchase;
    }

    /** 
     * Get the 'BrandID' element value. 2 Chars string representing sold brand. Example: PE
     * 
     * @return value
     */
    public String getBrandID() {
        return brandID;
    }

    /** 
     * Set the 'BrandID' element value. 2 Chars string representing sold brand. Example: PE
     * 
     * @param brandID
     */
    public void setBrandID(String brandID) {
        this.brandID = brandID;
    }

    /** 
     * Get the 'Cabin' element value.
     * 
     * @return value
     */
    public Cabin getCabin() {
        return cabin;
    }

    /** 
     * Set the 'Cabin' element value.
     * 
     * @param cabin
     */
    public void setCabin(Cabin cabin) {
        this.cabin = cabin;
    }

    /** 
     * Get the 'Banner' element value. "Air/Banner" is used to return the marketing airline name.
     * 
     * @return value
     */
    public String getBanner() {
        return banner;
    }

    /** 
     * Set the 'Banner' element value. "Air/Banner" is used to return the marketing airline name.
     * 
     * @param banner
     */
    public void setBanner(String banner) {
        this.banner = banner;
    }

    /** 
     * Get the 'OtherAirlineSign' element value. Other airline sign information
     * 
     * @return value
     */
    public String getOtherAirlineSign() {
        return otherAirlineSign;
    }

    /** 
     * Set the 'OtherAirlineSign' element value. Other airline sign information
     * 
     * @param otherAirlineSign
     */
    public void setOtherAirlineSign(String otherAirlineSign) {
        this.otherAirlineSign = otherAirlineSign;
    }

    /** 
     * Get the 'Informational' element value. Informational segment indicator
     * 
     * @return value
     */
    public Boolean getInformational() {
        return informational;
    }

    /** 
     * Set the 'Informational' element value. Informational segment indicator
     * 
     * @param informational
     */
    public void setInformational(Boolean informational) {
        this.informational = informational;
    }

    /** 
     * Get the 'RdbAvailableSeatCounts' element value. Availability seat counts for RDB pricing purposes
     * 
     * @return value
     */
    public RdbAvailableSeatCountTypePNRB getRdbAvailableSeatCounts() {
        return rdbAvailableSeatCounts;
    }

    /** 
     * Set the 'RdbAvailableSeatCounts' element value. Availability seat counts for RDB pricing purposes
     * 
     * @param rdbAvailableSeatCounts
     */
    public void setRdbAvailableSeatCounts(
            RdbAvailableSeatCountTypePNRB rdbAvailableSeatCounts) {
        this.rdbAvailableSeatCounts = rdbAvailableSeatCounts;
    }

    /** 
     * Get the 'ODReevalAtETData' element value.
     * 
     * @return value
     */
    public ODReevalAtETData getODReevalAtETData1() {
        return ODReevalAtETData1;
    }

    /** 
     * Set the 'ODReevalAtETData' element value.
     * 
     * @param ODReevalAtETData1
     */
    public void setODReevalAtETData1(ODReevalAtETData ODReevalAtETData1) {
        this.ODReevalAtETData1 = ODReevalAtETData1;
    }

    /** 
     * Get the 'TimeSinceBooked' element value. Time since booked the segment. Example "10h00m"
     * 
     * @return value
     */
    public String getTimeSinceBooked() {
        return timeSinceBooked;
    }

    /** 
     * Set the 'TimeSinceBooked' element value. Time since booked the segment. Example "10h00m"
     * 
     * @param timeSinceBooked
     */
    public void setTimeSinceBooked(String timeSinceBooked) {
        this.timeSinceBooked = timeSinceBooked;
    }

    /** 
     * Get the 'AlliancePartnerGroup' element value.
     * 
     * @return value
     */
    public AlliancePartnerGroup getAlliancePartnerGroup() {
        return alliancePartnerGroup;
    }

    /** 
     * Set the 'AlliancePartnerGroup' element value.
     * 
     * @param alliancePartnerGroup
     */
    public void setAlliancePartnerGroup(
            AlliancePartnerGroup alliancePartnerGroup) {
        this.alliancePartnerGroup = alliancePartnerGroup;
    }

    /** 
     * Get the 'index' attribute value.
     * 
     * @return value
     */
    public BigInteger getIndex() {
        return index;
    }

    /** 
     * Set the 'index' attribute value.
     * 
     * @param index
     */
    public void setIndex(BigInteger index) {
        this.index = index;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'sequence' attribute value. Identifies sequence number of Itinerary
                  
     * 
     * @return value
     */
    public Short getSequence() {
        return sequence;
    }

    /** 
     * Set the 'sequence' attribute value. Identifies sequence number of Itinerary
                  
     * 
     * @param sequence
     */
    public void setSequence(Short sequence) {
        this.sequence = sequence;
    }

    /** 
     * Get the 'segmentAssociationId' attribute value. Unique segment tab for the segment the association is processed.
     * 
     * @return value
     */
    public Short getSegmentAssociationId() {
        return segmentAssociationId;
    }

    /** 
     * Set the 'segmentAssociationId' attribute value. Unique segment tab for the segment the association is processed.
     * 
     * @param segmentAssociationId
     */
    public void setSegmentAssociationId(Short segmentAssociationId) {
        this.segmentAssociationId = segmentAssociationId;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
                  
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
                  
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'isPast' attribute value. It returns information if current segment is past or not.
     * 
     * @return value
     */
    public Boolean getIsPast() {
        return isPast;
    }

    /** 
     * Set the 'isPast' attribute value. It returns information if current segment is past or not.
     * 
     * @param isPast
     */
    public void setIsPast(Boolean isPast) {
        this.isPast = isPast;
    }

    /** 
     * Get the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
     * 
     * @return value
     */
    public String getDayOfWeekInd() {
        return dayOfWeekInd;
    }

    /** 
     * Set the 'DayOfWeekInd' attribute value. "DayOfWeekInd" is used to return the day of the week indicator.
     * 
     * @param dayOfWeekInd
     */
    public void setDayOfWeekInd(String dayOfWeekInd) {
        this.dayOfWeekInd = dayOfWeekInd;
    }

    /** 
     * Get the 'ArrivalDayOfWeekInd' attribute value. "ArrivalDayOfWeekInd" is used to return the arrival day of the week indicator.
     * 
     * @return value
     */
    public String getArrivalDayOfWeekInd() {
        return arrivalDayOfWeekInd;
    }

    /** 
     * Set the 'ArrivalDayOfWeekInd' attribute value. "ArrivalDayOfWeekInd" is used to return the arrival day of the week indicator.
     * 
     * @param arrivalDayOfWeekInd
     */
    public void setArrivalDayOfWeekInd(String arrivalDayOfWeekInd) {
        this.arrivalDayOfWeekInd = arrivalDayOfWeekInd;
    }

    /** 
     * Get the 'CodeShare' attribute value. "CodeShare" is used to indicate if this is a codeshare flight.
     * 
     * @return value
     */
    public Boolean getCodeShare() {
        return codeShare;
    }

    /** 
     * Set the 'CodeShare' attribute value. "CodeShare" is used to indicate if this is a codeshare flight.
     * 
     * @param codeShare
     */
    public void setCodeShare(Boolean codeShare) {
        this.codeShare = codeShare;
    }

    /** 
     * Get the 'SpecialMeal' attribute value. "SpecialMeal" is used to indicate whether or not a special meal is associated with
                      the particular flight segment.
                  
     * 
     * @return value
     */
    public Boolean getSpecialMeal() {
        return specialMeal;
    }

    /** 
     * Set the 'SpecialMeal' attribute value. "SpecialMeal" is used to indicate whether or not a special meal is associated with
                      the particular flight segment.
                  
     * 
     * @param specialMeal
     */
    public void setSpecialMeal(Boolean specialMeal) {
        this.specialMeal = specialMeal;
    }

    /** 
     * Get the 'StopQuantity' attribute value. "StopQuantity" is used to return the number of stops associated with the particular
                      flight segment.
                  
     * 
     * @return value
     */
    public String getStopQuantity() {
        return stopQuantity;
    }

    /** 
     * Set the 'StopQuantity' attribute value. "StopQuantity" is used to return the number of stops associated with the particular
                      flight segment.
                  
     * 
     * @param stopQuantity
     */
    public void setStopQuantity(String stopQuantity) {
        this.stopQuantity = stopQuantity;
    }

    /** 
     * Get the 'SmokingAllowed' attribute value. "SmokingAllowed" is used to indicate whether or not smoking is permitted on the
                      particular flight segment.
                  
     * 
     * @return value
     */
    public Boolean getSmokingAllowed() {
        return smokingAllowed;
    }

    /** 
     * Set the 'SmokingAllowed' attribute value. "SmokingAllowed" is used to indicate whether or not smoking is permitted on the
                      particular flight segment.
                  
     * 
     * @param smokingAllowed
     */
    public void setSmokingAllowed(Boolean smokingAllowed) {
        this.smokingAllowed = smokingAllowed;
    }

    /** 
     * Get the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to specify the booking class.
                  
     * 
     * @return value
     */
    public String getResBookDesigCode() {
        return resBookDesigCode;
    }

    /** 
     * Set the 'ResBookDesigCode' attribute value. "ResBookDesigCode" is used to specify the booking class.
                  
     * 
     * @param resBookDesigCode
     */
    public void setResBookDesigCode(String resBookDesigCode) {
        this.resBookDesigCode = resBookDesigCode;
    }

    /** 
     * Get the 'Code' attribute value. "Code" is used to return the operating airline code used for pricing associated with
                      the particular flight segment.
                  
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' attribute value. "Code" is used to return the operating airline code used for pricing associated with
                      the particular flight segment.
                  
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'isIgnored' attribute value. "isIgnored" is used to indicate whether or not segment is marked as ignored.
                  
     * 
     * @return value
     */
    public Boolean getIsIgnored() {
        return isIgnored;
    }

    /** 
     * Set the 'isIgnored' attribute value. "isIgnored" is used to indicate whether or not segment is marked as ignored.
                  
     * 
     * @param isIgnored
     */
    public void setIsIgnored(Boolean isIgnored) {
        this.isIgnored = isIgnored;
    }
    /** 
     * Disclosure carrier field (DCX) added. Optional data from DSS. If the DCX is not
                          available, whole section is excluded from the RS.
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DisclosureCarrier" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Banner" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="DOT"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DisclosureCarrier implements Serializable
    {
        private String banner;
        private String code;
        private Boolean DOT;

        /** 
         * Get the 'Banner' element value. "DisclosureCarrier/Banner" is used to return the disclosure carrier
                                        name
                                    
         * 
         * @return value
         */
        public String getBanner() {
            return banner;
        }

        /** 
         * Set the 'Banner' element value. "DisclosureCarrier/Banner" is used to return the disclosure carrier
                                        name
                                    
         * 
         * @param banner
         */
        public void setBanner(String banner) {
            this.banner = banner;
        }

        /** 
         * Get the 'Code' attribute value. "Code" is used to return the disclosure carrier code associated with the
                                    particular vehicle segment
                                
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value. "Code" is used to return the disclosure carrier code associated with the
                                    particular vehicle segment
                                
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'DOT' attribute value. "DOT" is optional data from DSS (DOT) it determines Banner appearance
                                
         * 
         * @return value
         */
        public Boolean getDOT() {
            return DOT;
        }

        /** 
         * Set the 'DOT' attribute value. "DOT" is optional data from DSS (DOT) it determines Banner appearance
                                
         * 
         * @param DOT
         */
        public void setDOT(Boolean DOT) {
            this.DOT = DOT;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarriageGrp" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Ind" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Group" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="Sequence" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MarriageGrp implements Serializable
    {
        private String ind;
        private String group;
        private String sequence;

        /** 
         * Get the 'Ind' element value. An indicator which represents non-contiguous group segments.
                                        Out of sequence married segment will have one other airline in between two airline
                                        group segments.
                                    
         * 
         * @return value
         */
        public String getInd() {
            return ind;
        }

        /** 
         * Set the 'Ind' element value. An indicator which represents non-contiguous group segments.
                                        Out of sequence married segment will have one other airline in between two airline
                                        group segments.
                                    
         * 
         * @param ind
         */
        public void setInd(String ind) {
            this.ind = ind;
        }

        /** 
         * Get the 'Group' element value. A set of air segments that are considered “married” together.
                                        This is referred to as the new married group number. Married Group may contain up to
                                        3 segments.
                                    
         * 
         * @return value
         */
        public String getGroup() {
            return group;
        }

        /** 
         * Set the 'Group' element value. A set of air segments that are considered “married” together.
                                        This is referred to as the new married group number. Married Group may contain up to
                                        3 segments.
                                    
         * 
         * @param group
         */
        public void setGroup(String group) {
            this.group = group;
        }

        /** 
         * Get the 'Sequence' element value. The sequence number within the set/group of air segments that
                                        considered “married” together.
                                    
         * 
         * @return value
         */
        public String getSequence() {
            return sequence;
        }

        /** 
         * Set the 'Sequence' element value. The sequence number within the set/group of air segments that
                                        considered “married” together.
                                    
         * 
         * @param sequence
         */
        public void setSequence(String sequence) {
            this.sequence = sequence;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Meal" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Code"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Meal implements Serializable
    {
        private String code;

        /** 
         * Get the 'Code' attribute value. "Code" is used to return the meal code associated with the particular
                                    flight segment if applicable.
                                
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value. "Code" is used to return the meal code associated with the particular
                                    flight segment if applicable.
                                
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryServices" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AncillaryService" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AncillaryService -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AncillaryServices implements Serializable
    {
        private List<AncillaryService> ancillaryServiceList = new ArrayList<AncillaryService>();

        /** 
         * Get the list of 'AncillaryService' element items.
         * 
         * @return list
         */
        public List<AncillaryService> getAncillaryServiceList() {
            return ancillaryServiceList;
        }

        /** 
         * Set the list of 'AncillaryService' element items.
         * 
         * @param list
         */
        public void setAncillaryServiceList(List<AncillaryService> list) {
            ancillaryServiceList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryService" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="ref"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AncillaryService implements Serializable
        {
            private String ref;

            /** 
             * Get the 'ref' attribute value.
             * 
             * @return value
             */
            public String getRef() {
                return ref;
            }

            /** 
             * Set the 'ref' attribute value.
             * 
             * @param ref
             */
            public void setRef(String ref) {
                this.ref = ref;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HiddenStop" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="ArrivalDateTime" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="DepartureDateTime" minOccurs="0"/>
     *       &lt;xs:element name="Meal" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Meal -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:string" name="Airport"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="EquipmentType"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class HiddenStop implements Serializable
    {
        private String arrivalDateTime;
        private String departureDateTime;
        private List<Meal> mealList = new ArrayList<Meal>();
        private String airport;
        private String equipmentType;

        /** 
         * Get the 'ArrivalDateTime' element value.
         * 
         * @return value
         */
        public String getArrivalDateTime() {
            return arrivalDateTime;
        }

        /** 
         * Set the 'ArrivalDateTime' element value.
         * 
         * @param arrivalDateTime
         */
        public void setArrivalDateTime(String arrivalDateTime) {
            this.arrivalDateTime = arrivalDateTime;
        }

        /** 
         * Get the 'DepartureDateTime' element value.
         * 
         * @return value
         */
        public String getDepartureDateTime() {
            return departureDateTime;
        }

        /** 
         * Set the 'DepartureDateTime' element value.
         * 
         * @param departureDateTime
         */
        public void setDepartureDateTime(String departureDateTime) {
            this.departureDateTime = departureDateTime;
        }

        /** 
         * Get the list of 'Meal' element items.
         * 
         * @return list
         */
        public List<Meal> getMealList() {
            return mealList;
        }

        /** 
         * Set the list of 'Meal' element items.
         * 
         * @param list
         */
        public void setMealList(List<Meal> list) {
            mealList = list;
        }

        /** 
         * Get the 'Airport' attribute value. "Airport" is used to determine airport location code
         * 
         * @return value
         */
        public String getAirport() {
            return airport;
        }

        /** 
         * Set the 'Airport' attribute value. "Airport" is used to determine airport location code
         * 
         * @param airport
         */
        public void setAirport(String airport) {
            this.airport = airport;
        }

        /** 
         * Get the 'EquipmentType' attribute value. "EquipmentType" is used to return the aircraft equipment type associated
                                    with the particular flight segment.
                                
         * 
         * @return value
         */
        public String getEquipmentType() {
            return equipmentType;
        }

        /** 
         * Set the 'EquipmentType' attribute value. "EquipmentType" is used to return the aircraft equipment type associated
                                    with the particular flight segment.
                                
         * 
         * @param equipmentType
         */
        public void setEquipmentType(String equipmentType) {
            this.equipmentType = equipmentType;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Meal" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Meal implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. "Code" is used to return the meal code associated with the particular
                                                  flight segment if applicable.
                                              
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. "Code" is used to return the meal code associated with the particular
                                                  flight segment if applicable.
                                              
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cabin" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="SabreCode"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Name"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="ShortName"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Lang"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Cabin implements Serializable
    {
        private String code;
        private String sabreCode;
        private String name;
        private String shortName;
        private String lang;

        /** 
         * Get the 'Code' attribute value. Reservation Booking Designator code
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value. Reservation Booking Designator code
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'SabreCode' attribute value. Reservation Booking Designator sabre code
         * 
         * @return value
         */
        public String getSabreCode() {
            return sabreCode;
        }

        /** 
         * Set the 'SabreCode' attribute value. Reservation Booking Designator sabre code
         * 
         * @param sabreCode
         */
        public void setSabreCode(String sabreCode) {
            this.sabreCode = sabreCode;
        }

        /** 
         * Get the 'Name' attribute value. Long name of the Reservation booking designator. Example: Premium
                                    Economy
                                
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' attribute value. Long name of the Reservation booking designator. Example: Premium
                                    Economy
                                
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }

        /** 
         * Get the 'ShortName' attribute value. Short name of the Reservation booking designator. Example: PR ECON
                                
         * 
         * @return value
         */
        public String getShortName() {
            return shortName;
        }

        /** 
         * Set the 'ShortName' attribute value. Short name of the Reservation booking designator. Example: PR ECON
                                
         * 
         * @param shortName
         */
        public void setShortName(String shortName) {
            this.shortName = shortName;
        }

        /** 
         * Get the 'Lang' attribute value. Language of the names
         * 
         * @return value
         */
        public String getLang() {
            return lang;
        }

        /** 
         * Set the 'Lang' attribute value. Language of the names
         * 
         * @param lang
         */
        public void setLang(String lang) {
            this.lang = lang;
        }
    }
    /** 
     * Stores the origin-destination reevaluation data provided
                          by SSI at end transaction(ET1.5) for a given segment. Data in this element will only be available to IX via ASDS.
                      
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ODReevalAtETData" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:short" use="required" name="Error"/>
     *     &lt;xs:attribute type="xs:long" use="required" name="ReevaluationMap"/>
     *     &lt;xs:attribute type="xs:short" use="required" name="AvailableSeats"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ODReevalAtETData implements Serializable
    {
        private short error;
        private long reevaluationMap;
        private short availableSeats;

        /** 
         * Get the 'Error' attribute value. An error code if the segment in the PNR has failed during reevaluation.
                                
         * 
         * @return value
         */
        public short getError() {
            return error;
        }

        /** 
         * Set the 'Error' attribute value. An error code if the segment in the PNR has failed during reevaluation.
                                
         * 
         * @param error
         */
        public void setError(short error) {
            this.error = error;
        }

        /** 
         * Get the 'ReevaluationMap' attribute value. An informational field that stores data about the reevaluation.
                                
         * 
         * @return value
         */
        public long getReevaluationMap() {
            return reevaluationMap;
        }

        /** 
         * Set the 'ReevaluationMap' attribute value. An informational field that stores data about the reevaluation.
                                
         * 
         * @param reevaluationMap
         */
        public void setReevaluationMap(long reevaluationMap) {
            this.reevaluationMap = reevaluationMap;
        }

        /** 
         * Get the 'AvailableSeats' attribute value. Availability at the time of end transaction.
                                
         * 
         * @return value
         */
        public short getAvailableSeats() {
            return availableSeats;
        }

        /** 
         * Set the 'AvailableSeats' attribute value. Availability at the time of end transaction.
                                
         * 
         * @param availableSeats
         */
        public void setAvailableSeats(short availableSeats) {
            this.availableSeats = availableSeats;
        }
    }
    /** 
     * Information about alliance partner group related with the flight. Example:
                          Oneworld, Skyteam, Star Alliance
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlliancePartnerGroup" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="Code" minOccurs="1" maxOccurs="1"/>
     *       &lt;xs:element type="xs:string" name="Name" minOccurs="0" maxOccurs="1"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AlliancePartnerGroup implements Serializable
    {
        private String code;
        private String name;

        /** 
         * Get the 'Code' element value. Alliance partner group code. Example: OW
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' element value. Alliance partner group code. Example: OW
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Name' element value. Alliance partner group name. Example: ONEWORLD
         * 
         * @return value
         */
        public String getName() {
            return name;
        }

        /** 
         * Set the 'Name' element value. Alliance partner group name. Example: ONEWORLD
         * 
         * @param name
         */
        public void setName(String name) {
            this.name = name;
        }
    }
}
