
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryServicesPartialUpdate.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:NameAssociationList.PNRB" name="NameAssociationList" minOccurs="0"/>
 *     &lt;xs:element type="ns:SegmentAssociationList.PNRB" name="SegmentAssociationList" minOccurs="0"/>
 *     &lt;xs:choice minOccurs="0">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:int" name="aePortionId"/>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AncillaryServicesPartialUpdatePNRB implements Serializable
{
    private NameAssociationListPNRB nameAssociationList;
    private SegmentAssociationListPNRB segmentAssociationList;
    private Choice choice;
    private Integer aePortionId;
    private String id;
    private OperationTypePNRB op;

    /** 
     * Get the 'NameAssociationList' element value.
     * 
     * @return value
     */
    public NameAssociationListPNRB getNameAssociationList() {
        return nameAssociationList;
    }

    /** 
     * Set the 'NameAssociationList' element value.
     * 
     * @param nameAssociationList
     */
    public void setNameAssociationList(
            NameAssociationListPNRB nameAssociationList) {
        this.nameAssociationList = nameAssociationList;
    }

    /** 
     * Get the 'SegmentAssociationList' element value. Segment Association is a mandatory field when using
                          EMDNumberUpdate/ETicketNumberUpdate for EMD-A (EMDType 2) AEs.
                      
     * 
     * @return value
     */
    public SegmentAssociationListPNRB getSegmentAssociationList() {
        return segmentAssociationList;
    }

    /** 
     * Set the 'SegmentAssociationList' element value. Segment Association is a mandatory field when using
                          EMDNumberUpdate/ETicketNumberUpdate for EMD-A (EMDType 2) AEs.
                      
     * 
     * @param segmentAssociationList
     */
    public void setSegmentAssociationList(
            SegmentAssociationListPNRB segmentAssociationList) {
        this.segmentAssociationList = segmentAssociationList;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the 'aePortionId' attribute value.
     * 
     * @return value
     */
    public Integer getAePortionId() {
        return aePortionId;
    }

    /** 
     * Set the 'aePortionId' attribute value.
     * 
     * @param aePortionId
     */
    public void setAePortionId(Integer aePortionId) {
        this.aePortionId = aePortionId;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element type="ns:AncillaryServiceActionCodeUpdate.PNRB" name="ActionCodeUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServiceSeatRequestTransactionIDUpdate.PNRB" name="SeatRequestTransactionIDUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServiceEMDNumberUpdate.PNRB" name="EMDNumberUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServiceETicketNumberUpdate.PNRB" name="ETicketNumberUpdate"/>
     *   &lt;xs:element type="ns:PricingAndTaxesPartialUpdateType.PNRB" name="PricingAndTaxesPartialUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServicePassengerTypeCodePartialUpdate.PNRB" name="PassengerTypeCodePartialUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServiceIATAIndicatorPartialUpdate.PNRB" name="IATAIndicatorPartialUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServiceFeeGuaranteePartialUpdate.PNRB" name="FeeGuaranteePartialUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServicePurchaseDateUpdate.PNRB" name="PurchaseDateUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServiceGroupCodeAndRficSubcodeUpdate.PNRB" name="GroupCodeAndRficSubcodeUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServiceEMDTypeUpdate.PNRB" name="EMDTypeUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServiceAcsCountUpdate.PNRB" name="AcsCountUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServiceVendorCodeUpdate.PNRB" name="VendorCodeUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServiceAdvisorySegmentList.PNRB" name="SegmentAdvisoryList"/>
     *   &lt;xs:element type="xs:string" name="AaPayOptionalStatus" minOccurs="0"/>
     *   &lt;xs:element type="ns:IndicatorType" name="TaxExemption" minOccurs="0"/>
     *   &lt;xs:element type="ns:AncillaryServicePdcSeatPartialUpdate.PNRB" name="PdcSeatUpdate"/>
     *   &lt;xs:element type="ns:AncillaryServiceRuleSetPartialUpdate.PNRB" name="RuleSetUpdate"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int ACTION_CODE_UPDATE_CHOICE = 0;
        private static final int SEAT_REQUEST_TRANSACTION_ID_UPDATE_CHOICE = 1;
        private static final int EMD_NUMBER_UPDATE_CHOICE = 2;
        private static final int E_TICKET_NUMBER_UPDATE_CHOICE = 3;
        private static final int PRICING_AND_TAXES_PARTIAL_UPDATE_CHOICE = 4;
        private static final int PASSENGER_TYPE_CODE_PARTIAL_UPDATE_CHOICE = 5;
        private static final int IATA_INDICATOR_PARTIAL_UPDATE_CHOICE = 6;
        private static final int FEE_GUARANTEE_PARTIAL_UPDATE_CHOICE = 7;
        private static final int PURCHASE_DATE_UPDATE_CHOICE = 8;
        private static final int GROUP_CODE_AND_RFIC_SUBCODE_UPDATE_CHOICE = 9;
        private static final int EMD_TYPE_UPDATE_CHOICE = 10;
        private static final int ACS_COUNT_UPDATE_CHOICE = 11;
        private static final int VENDOR_CODE_UPDATE_CHOICE = 12;
        private static final int SEGMENT_ADVISORY_LIST_CHOICE = 13;
        private static final int AA_PAY_OPTIONAL_STATUS_CHOICE = 14;
        private static final int TAX_EXEMPTION_CHOICE = 15;
        private static final int PDC_SEAT_UPDATE_CHOICE = 16;
        private static final int RULE_SET_UPDATE_CHOICE = 17;
        private AncillaryServiceActionCodeUpdatePNRB actionCodeUpdate;
        private AncillaryServiceSeatRequestTransactionIDUpdatePNRB seatRequestTransactionIDUpdate;
        private AncillaryServiceEMDNumberUpdatePNRB EMDNumberUpdate;
        private AncillaryServiceETicketNumberUpdatePNRB ETicketNumberUpdate;
        private PricingAndTaxesPartialUpdateTypePNRB pricingAndTaxesPartialUpdate;
        private AncillaryServicePassengerTypeCodePartialUpdatePNRB passengerTypeCodePartialUpdate;
        private AncillaryServiceIATAIndicatorPartialUpdatePNRB IATAIndicatorPartialUpdate;
        private AncillaryServiceFeeGuaranteePartialUpdatePNRB feeGuaranteePartialUpdate;
        private AncillaryServicePurchaseDateUpdatePNRB purchaseDateUpdate;
        private AncillaryServiceGroupCodeAndRficSubcodeUpdatePNRB groupCodeAndRficSubcodeUpdate;
        private AncillaryServiceEMDTypeUpdatePNRB EMDTypeUpdate;
        private AncillaryServiceAcsCountUpdatePNRB acsCountUpdate;
        private AncillaryServiceVendorCodeUpdatePNRB vendorCodeUpdate;
        private AncillaryServiceAdvisorySegmentListPNRB segmentAdvisoryList;
        private String aaPayOptionalStatus;
        private IndicatorType taxExemption;
        private AncillaryServicePdcSeatPartialUpdatePNRB pdcSeatUpdate;
        private AncillaryServiceRuleSetPartialUpdatePNRB ruleSetUpdate;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if ActionCodeUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifActionCodeUpdate() {
            return choiceSelect == ACTION_CODE_UPDATE_CHOICE;
        }

        /** 
         * Get the 'ActionCodeUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServiceActionCodeUpdatePNRB getActionCodeUpdate() {
            return actionCodeUpdate;
        }

        /** 
         * Set the 'ActionCodeUpdate' element value.
         * 
         * @param actionCodeUpdate
         */
        public void setActionCodeUpdate(
                AncillaryServiceActionCodeUpdatePNRB actionCodeUpdate) {
            setChoiceSelect(ACTION_CODE_UPDATE_CHOICE);
            this.actionCodeUpdate = actionCodeUpdate;
        }

        /** 
         * Check if SeatRequestTransactionIDUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSeatRequestTransactionIDUpdate() {
            return choiceSelect == SEAT_REQUEST_TRANSACTION_ID_UPDATE_CHOICE;
        }

        /** 
         * Get the 'SeatRequestTransactionIDUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServiceSeatRequestTransactionIDUpdatePNRB getSeatRequestTransactionIDUpdate() {
            return seatRequestTransactionIDUpdate;
        }

        /** 
         * Set the 'SeatRequestTransactionIDUpdate' element value.
         * 
         * @param seatRequestTransactionIDUpdate
         */
        public void setSeatRequestTransactionIDUpdate(
                AncillaryServiceSeatRequestTransactionIDUpdatePNRB seatRequestTransactionIDUpdate) {
            setChoiceSelect(SEAT_REQUEST_TRANSACTION_ID_UPDATE_CHOICE);
            this.seatRequestTransactionIDUpdate = seatRequestTransactionIDUpdate;
        }

        /** 
         * Check if EMDNumberUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEMDNumberUpdate() {
            return choiceSelect == EMD_NUMBER_UPDATE_CHOICE;
        }

        /** 
         * Get the 'EMDNumberUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServiceEMDNumberUpdatePNRB getEMDNumberUpdate() {
            return EMDNumberUpdate;
        }

        /** 
         * Set the 'EMDNumberUpdate' element value.
         * 
         * @param EMDNumberUpdate
         */
        public void setEMDNumberUpdate(
                AncillaryServiceEMDNumberUpdatePNRB EMDNumberUpdate) {
            setChoiceSelect(EMD_NUMBER_UPDATE_CHOICE);
            this.EMDNumberUpdate = EMDNumberUpdate;
        }

        /** 
         * Check if ETicketNumberUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifETicketNumberUpdate() {
            return choiceSelect == E_TICKET_NUMBER_UPDATE_CHOICE;
        }

        /** 
         * Get the 'ETicketNumberUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServiceETicketNumberUpdatePNRB getETicketNumberUpdate() {
            return ETicketNumberUpdate;
        }

        /** 
         * Set the 'ETicketNumberUpdate' element value.
         * 
         * @param ETicketNumberUpdate
         */
        public void setETicketNumberUpdate(
                AncillaryServiceETicketNumberUpdatePNRB ETicketNumberUpdate) {
            setChoiceSelect(E_TICKET_NUMBER_UPDATE_CHOICE);
            this.ETicketNumberUpdate = ETicketNumberUpdate;
        }

        /** 
         * Check if PricingAndTaxesPartialUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPricingAndTaxesPartialUpdate() {
            return choiceSelect == PRICING_AND_TAXES_PARTIAL_UPDATE_CHOICE;
        }

        /** 
         * Get the 'PricingAndTaxesPartialUpdate' element value.
         * 
         * @return value
         */
        public PricingAndTaxesPartialUpdateTypePNRB getPricingAndTaxesPartialUpdate() {
            return pricingAndTaxesPartialUpdate;
        }

        /** 
         * Set the 'PricingAndTaxesPartialUpdate' element value.
         * 
         * @param pricingAndTaxesPartialUpdate
         */
        public void setPricingAndTaxesPartialUpdate(
                PricingAndTaxesPartialUpdateTypePNRB pricingAndTaxesPartialUpdate) {
            setChoiceSelect(PRICING_AND_TAXES_PARTIAL_UPDATE_CHOICE);
            this.pricingAndTaxesPartialUpdate = pricingAndTaxesPartialUpdate;
        }

        /** 
         * Check if PassengerTypeCodePartialUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPassengerTypeCodePartialUpdate() {
            return choiceSelect == PASSENGER_TYPE_CODE_PARTIAL_UPDATE_CHOICE;
        }

        /** 
         * Get the 'PassengerTypeCodePartialUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServicePassengerTypeCodePartialUpdatePNRB getPassengerTypeCodePartialUpdate() {
            return passengerTypeCodePartialUpdate;
        }

        /** 
         * Set the 'PassengerTypeCodePartialUpdate' element value.
         * 
         * @param passengerTypeCodePartialUpdate
         */
        public void setPassengerTypeCodePartialUpdate(
                AncillaryServicePassengerTypeCodePartialUpdatePNRB passengerTypeCodePartialUpdate) {
            setChoiceSelect(PASSENGER_TYPE_CODE_PARTIAL_UPDATE_CHOICE);
            this.passengerTypeCodePartialUpdate = passengerTypeCodePartialUpdate;
        }

        /** 
         * Check if IATAIndicatorPartialUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifIATAIndicatorPartialUpdate() {
            return choiceSelect == IATA_INDICATOR_PARTIAL_UPDATE_CHOICE;
        }

        /** 
         * Get the 'IATAIndicatorPartialUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServiceIATAIndicatorPartialUpdatePNRB getIATAIndicatorPartialUpdate() {
            return IATAIndicatorPartialUpdate;
        }

        /** 
         * Set the 'IATAIndicatorPartialUpdate' element value.
         * 
         * @param IATAIndicatorPartialUpdate
         */
        public void setIATAIndicatorPartialUpdate(
                AncillaryServiceIATAIndicatorPartialUpdatePNRB IATAIndicatorPartialUpdate) {
            setChoiceSelect(IATA_INDICATOR_PARTIAL_UPDATE_CHOICE);
            this.IATAIndicatorPartialUpdate = IATAIndicatorPartialUpdate;
        }

        /** 
         * Check if FeeGuaranteePartialUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifFeeGuaranteePartialUpdate() {
            return choiceSelect == FEE_GUARANTEE_PARTIAL_UPDATE_CHOICE;
        }

        /** 
         * Get the 'FeeGuaranteePartialUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServiceFeeGuaranteePartialUpdatePNRB getFeeGuaranteePartialUpdate() {
            return feeGuaranteePartialUpdate;
        }

        /** 
         * Set the 'FeeGuaranteePartialUpdate' element value.
         * 
         * @param feeGuaranteePartialUpdate
         */
        public void setFeeGuaranteePartialUpdate(
                AncillaryServiceFeeGuaranteePartialUpdatePNRB feeGuaranteePartialUpdate) {
            setChoiceSelect(FEE_GUARANTEE_PARTIAL_UPDATE_CHOICE);
            this.feeGuaranteePartialUpdate = feeGuaranteePartialUpdate;
        }

        /** 
         * Check if PurchaseDateUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPurchaseDateUpdate() {
            return choiceSelect == PURCHASE_DATE_UPDATE_CHOICE;
        }

        /** 
         * Get the 'PurchaseDateUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServicePurchaseDateUpdatePNRB getPurchaseDateUpdate() {
            return purchaseDateUpdate;
        }

        /** 
         * Set the 'PurchaseDateUpdate' element value.
         * 
         * @param purchaseDateUpdate
         */
        public void setPurchaseDateUpdate(
                AncillaryServicePurchaseDateUpdatePNRB purchaseDateUpdate) {
            setChoiceSelect(PURCHASE_DATE_UPDATE_CHOICE);
            this.purchaseDateUpdate = purchaseDateUpdate;
        }

        /** 
         * Check if GroupCodeAndRficSubcodeUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifGroupCodeAndRficSubcodeUpdate() {
            return choiceSelect == GROUP_CODE_AND_RFIC_SUBCODE_UPDATE_CHOICE;
        }

        /** 
         * Get the 'GroupCodeAndRficSubcodeUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServiceGroupCodeAndRficSubcodeUpdatePNRB getGroupCodeAndRficSubcodeUpdate() {
            return groupCodeAndRficSubcodeUpdate;
        }

        /** 
         * Set the 'GroupCodeAndRficSubcodeUpdate' element value.
         * 
         * @param groupCodeAndRficSubcodeUpdate
         */
        public void setGroupCodeAndRficSubcodeUpdate(
                AncillaryServiceGroupCodeAndRficSubcodeUpdatePNRB groupCodeAndRficSubcodeUpdate) {
            setChoiceSelect(GROUP_CODE_AND_RFIC_SUBCODE_UPDATE_CHOICE);
            this.groupCodeAndRficSubcodeUpdate = groupCodeAndRficSubcodeUpdate;
        }

        /** 
         * Check if EMDTypeUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifEMDTypeUpdate() {
            return choiceSelect == EMD_TYPE_UPDATE_CHOICE;
        }

        /** 
         * Get the 'EMDTypeUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServiceEMDTypeUpdatePNRB getEMDTypeUpdate() {
            return EMDTypeUpdate;
        }

        /** 
         * Set the 'EMDTypeUpdate' element value.
         * 
         * @param EMDTypeUpdate
         */
        public void setEMDTypeUpdate(
                AncillaryServiceEMDTypeUpdatePNRB EMDTypeUpdate) {
            setChoiceSelect(EMD_TYPE_UPDATE_CHOICE);
            this.EMDTypeUpdate = EMDTypeUpdate;
        }

        /** 
         * Check if AcsCountUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAcsCountUpdate() {
            return choiceSelect == ACS_COUNT_UPDATE_CHOICE;
        }

        /** 
         * Get the 'AcsCountUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServiceAcsCountUpdatePNRB getAcsCountUpdate() {
            return acsCountUpdate;
        }

        /** 
         * Set the 'AcsCountUpdate' element value.
         * 
         * @param acsCountUpdate
         */
        public void setAcsCountUpdate(
                AncillaryServiceAcsCountUpdatePNRB acsCountUpdate) {
            setChoiceSelect(ACS_COUNT_UPDATE_CHOICE);
            this.acsCountUpdate = acsCountUpdate;
        }

        /** 
         * Check if VendorCodeUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifVendorCodeUpdate() {
            return choiceSelect == VENDOR_CODE_UPDATE_CHOICE;
        }

        /** 
         * Get the 'VendorCodeUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServiceVendorCodeUpdatePNRB getVendorCodeUpdate() {
            return vendorCodeUpdate;
        }

        /** 
         * Set the 'VendorCodeUpdate' element value.
         * 
         * @param vendorCodeUpdate
         */
        public void setVendorCodeUpdate(
                AncillaryServiceVendorCodeUpdatePNRB vendorCodeUpdate) {
            setChoiceSelect(VENDOR_CODE_UPDATE_CHOICE);
            this.vendorCodeUpdate = vendorCodeUpdate;
        }

        /** 
         * Check if SegmentAdvisoryList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSegmentAdvisoryList() {
            return choiceSelect == SEGMENT_ADVISORY_LIST_CHOICE;
        }

        /** 
         * Get the 'SegmentAdvisoryList' element value. Segment Advisory List data is provided only when collapsing 2 sector AEs into
                                portions. It is used to specify details of interline flights that are not hosted in Sabre.
                            
         * 
         * @return value
         */
        public AncillaryServiceAdvisorySegmentListPNRB getSegmentAdvisoryList() {
            return segmentAdvisoryList;
        }

        /** 
         * Set the 'SegmentAdvisoryList' element value. Segment Advisory List data is provided only when collapsing 2 sector AEs into
                                portions. It is used to specify details of interline flights that are not hosted in Sabre.
                            
         * 
         * @param segmentAdvisoryList
         */
        public void setSegmentAdvisoryList(
                AncillaryServiceAdvisorySegmentListPNRB segmentAdvisoryList) {
            setChoiceSelect(SEGMENT_ADVISORY_LIST_CHOICE);
            this.segmentAdvisoryList = segmentAdvisoryList;
        }

        /** 
         * Check if AaPayOptionalStatus is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAaPayOptionalStatus() {
            return choiceSelect == AA_PAY_OPTIONAL_STATUS_CHOICE;
        }

        /** 
         * Get the 'AaPayOptionalStatus' element value.
         * 
         * @return value
         */
        public String getAaPayOptionalStatus() {
            return aaPayOptionalStatus;
        }

        /** 
         * Set the 'AaPayOptionalStatus' element value.
         * 
         * @param aaPayOptionalStatus
         */
        public void setAaPayOptionalStatus(String aaPayOptionalStatus) {
            setChoiceSelect(AA_PAY_OPTIONAL_STATUS_CHOICE);
            this.aaPayOptionalStatus = aaPayOptionalStatus;
        }

        /** 
         * Check if TaxExemption is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTaxExemption() {
            return choiceSelect == TAX_EXEMPTION_CHOICE;
        }

        /** 
         * Get the 'TaxExemption' element value. When Tax is exempt PNR Ancillary displays will be updated to display "TAX
                                EXEMPT - Y". This applies to both EMD-S and EMD-A.
                            
         * 
         * @return value
         */
        public IndicatorType getTaxExemption() {
            return taxExemption;
        }

        /** 
         * Set the 'TaxExemption' element value. When Tax is exempt PNR Ancillary displays will be updated to display "TAX
                                EXEMPT - Y". This applies to both EMD-S and EMD-A.
                            
         * 
         * @param taxExemption
         */
        public void setTaxExemption(IndicatorType taxExemption) {
            setChoiceSelect(TAX_EXEMPTION_CHOICE);
            this.taxExemption = taxExemption;
        }

        /** 
         * Check if PdcSeatUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPdcSeatUpdate() {
            return choiceSelect == PDC_SEAT_UPDATE_CHOICE;
        }

        /** 
         * Get the 'PdcSeatUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServicePdcSeatPartialUpdatePNRB getPdcSeatUpdate() {
            return pdcSeatUpdate;
        }

        /** 
         * Set the 'PdcSeatUpdate' element value.
         * 
         * @param pdcSeatUpdate
         */
        public void setPdcSeatUpdate(
                AncillaryServicePdcSeatPartialUpdatePNRB pdcSeatUpdate) {
            setChoiceSelect(PDC_SEAT_UPDATE_CHOICE);
            this.pdcSeatUpdate = pdcSeatUpdate;
        }

        /** 
         * Check if RuleSetUpdate is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifRuleSetUpdate() {
            return choiceSelect == RULE_SET_UPDATE_CHOICE;
        }

        /** 
         * Get the 'RuleSetUpdate' element value.
         * 
         * @return value
         */
        public AncillaryServiceRuleSetPartialUpdatePNRB getRuleSetUpdate() {
            return ruleSetUpdate;
        }

        /** 
         * Set the 'RuleSetUpdate' element value.
         * 
         * @param ruleSetUpdate
         */
        public void setRuleSetUpdate(
                AncillaryServiceRuleSetPartialUpdatePNRB ruleSetUpdate) {
            setChoiceSelect(RULE_SET_UPDATE_CHOICE);
            this.ruleSetUpdate = ruleSetUpdate;
        }
    }
}
