
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociationChildElementType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Remark"/>
 *     &lt;xs:enumeration value="PhoneNumber"/>
 *     &lt;xs:enumeration value="Ticket"/>
 *     &lt;xs:enumeration value="AccountingLine"/>
 *     &lt;xs:enumeration value="FOP"/>
 *     &lt;xs:enumeration value="FopUsageType"/>
 *     &lt;xs:enumeration value="FopTripType"/>
 *     &lt;xs:enumeration value="AccountingField"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum AssociationChildElementType implements Serializable {
    REMARK("Remark"), PHONE_NUMBER("PhoneNumber"), TICKET("Ticket"), ACCOUNTING_LINE(
            "AccountingLine"), FOP("FOP"), FOP_USAGE_TYPE("FopUsageType"), FOP_TRIP_TYPE(
            "FopTripType"), ACCOUNTING_FIELD("AccountingField");
    private final String value;

    private AssociationChildElementType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static AssociationChildElementType convert(String value) {
        for (AssociationChildElementType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
