
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BookingChannelGroup">
 *   &lt;xs:attribute type="xs:string" use="required" name="Type"/>
 *   &lt;xs:attribute type="xs:boolean" name="Primary"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BookingChannelGroup implements Serializable
{
    private String type;
    private Boolean primary;

    /** 
     * Get the 'Type' attribute value. The type of booking
                      channel (e.g. Global Distribution System (GDS), Alternative
                      Distribution System (ADS), Sales and Catering System (SCS),
                      Property Management System (PMS), Central Reservation System (CRS),
                      Tour Operator System (TOS), Internet and ALL). Refer to OTA Code
                      List Booking Channel Type (BCT).
                  
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. The type of booking
                      channel (e.g. Global Distribution System (GDS), Alternative
                      Distribution System (ADS), Sales and Catering System (SCS),
                      Property Management System (PMS), Central Reservation System (CRS),
                      Tour Operator System (TOS), Internet and ALL). Refer to OTA Code
                      List Booking Channel Type (BCT).
                  
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'Primary' attribute value. Indicates
                      whether the enumerated booking channel is the primary means of
                      connectivity used by the source.
                  
     * 
     * @return value
     */
    public Boolean getPrimary() {
        return primary;
    }

    /** 
     * Set the 'Primary' attribute value. Indicates
                      whether the enumerated booking channel is the primary means of
                      connectivity used by the source.
                  
     * 
     * @param primary
     */
    public void setPrimary(Boolean primary) {
        this.primary = primary;
    }
}
