
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Used to update confirmation for air segment
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConfirmationUpdate.PNRB">
 *   &lt;xs:attribute type="xs:string" name="RecordLocator"/>
 *   &lt;xs:attribute type="xs:string" name="SegmentAccess"/>
 *   &lt;xs:attribute type="xs:string" name="AirlineCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ConfirmationUpdatePNRB implements Serializable
{
    private String recordLocator;
    private String segmentAccess;
    private String airlineCode;

    /** 
     * Get the 'RecordLocator' attribute value. Record Locator for booking in airline's system (e.g. "DABGTQ")
                  
     * 
     * @return value
     */
    public String getRecordLocator() {
        return recordLocator;
    }

    /** 
     * Set the 'RecordLocator' attribute value. Record Locator for booking in airline's system (e.g. "DABGTQ")
                  
     * 
     * @param recordLocator
     */
    public void setRecordLocator(String recordLocator) {
        this.recordLocator = recordLocator;
    }

    /** 
     * Get the 'SegmentAccess' attribute value. Code for segment access (e.g. "RL", "DC")
     * 
     * @return value
     */
    public String getSegmentAccess() {
        return segmentAccess;
    }

    /** 
     * Set the 'SegmentAccess' attribute value. Code for segment access (e.g. "RL", "DC")
     * 
     * @param segmentAccess
     */
    public void setSegmentAccess(String segmentAccess) {
        this.segmentAccess = segmentAccess;
    }

    /** 
     * Get the 'AirlineCode' attribute value. Code of airline confirming segment (e.g. "AA", "B6")
                  
     * 
     * @return value
     */
    public String getAirlineCode() {
        return airlineCode;
    }

    /** 
     * Set the 'AirlineCode' attribute value. Code of airline confirming segment (e.g. "AA", "B6")
                  
     * 
     * @param airlineCode
     */
    public void setAirlineCode(String airlineCode) {
        this.airlineCode = airlineCode;
    }
}
