
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CurrencyCodeList">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="ADP"/>
 *     &lt;xs:enumeration value="AED"/>
 *     &lt;xs:enumeration value="AFA"/>
 *     &lt;xs:enumeration value="AFN"/>
 *     &lt;xs:enumeration value="ALL"/>
 *     &lt;xs:enumeration value="AMD"/>
 *     &lt;xs:enumeration value="ANG"/>
 *     &lt;xs:enumeration value="AOA"/>
 *     &lt;xs:enumeration value="AON"/>
 *     &lt;xs:enumeration value="AOR"/>
 *     &lt;xs:enumeration value="ARS"/>
 *     &lt;xs:enumeration value="ATS"/>
 *     &lt;xs:enumeration value="AUD"/>
 *     &lt;xs:enumeration value="AWG"/>
 *     &lt;xs:enumeration value="AZM"/>
 *     &lt;xs:enumeration value="AZN"/>
 *     &lt;xs:enumeration value="BAM"/>
 *     &lt;xs:enumeration value="BBD"/>
 *     &lt;xs:enumeration value="BDT"/>
 *     &lt;xs:enumeration value="BEF"/>
 *     &lt;xs:enumeration value="BGL"/>
 *     &lt;xs:enumeration value="BGN"/>
 *     &lt;xs:enumeration value="BHD"/>
 *     &lt;xs:enumeration value="BIF"/>
 *     &lt;xs:enumeration value="BMD"/>
 *     &lt;xs:enumeration value="BND"/>
 *     &lt;xs:enumeration value="BOB"/>
 *     &lt;xs:enumeration value="BOV"/>
 *     &lt;xs:enumeration value="BRL"/>
 *     &lt;xs:enumeration value="BSD"/>
 *     &lt;xs:enumeration value="BTN"/>
 *     &lt;xs:enumeration value="BWP"/>
 *     &lt;xs:enumeration value="BYR"/>
 *     &lt;xs:enumeration value="BZD"/>
 *     &lt;xs:enumeration value="CAD"/>
 *     &lt;xs:enumeration value="CDF"/>
 *     &lt;xs:enumeration value="CHE"/>
 *     &lt;xs:enumeration value="CHF"/>
 *     &lt;xs:enumeration value="CHW"/>
 *     &lt;xs:enumeration value="CLF"/>
 *     &lt;xs:enumeration value="CLP"/>
 *     &lt;xs:enumeration value="CNY"/>
 *     &lt;xs:enumeration value="COP"/>
 *     &lt;xs:enumeration value="COU"/>
 *     &lt;xs:enumeration value="CRC"/>
 *     &lt;xs:enumeration value="CUP"/>
 *     &lt;xs:enumeration value="CUC"/>
 *     &lt;xs:enumeration value="CVE"/>
 *     &lt;xs:enumeration value="CYP"/>
 *     &lt;xs:enumeration value="CZK"/>
 *     &lt;xs:enumeration value="DEM"/>
 *     &lt;xs:enumeration value="DJF"/>
 *     &lt;xs:enumeration value="DKK"/>
 *     &lt;xs:enumeration value="DOP"/>
 *     &lt;xs:enumeration value="DZD"/>
 *     &lt;xs:enumeration value="ECS"/>
 *     &lt;xs:enumeration value="ECV"/>
 *     &lt;xs:enumeration value="EEK"/>
 *     &lt;xs:enumeration value="EGP"/>
 *     &lt;xs:enumeration value="ERN"/>
 *     &lt;xs:enumeration value="ESP"/>
 *     &lt;xs:enumeration value="ETB"/>
 *     &lt;xs:enumeration value="EUR"/>
 *     &lt;xs:enumeration value="FIM"/>
 *     &lt;xs:enumeration value="FJD"/>
 *     &lt;xs:enumeration value="FKP"/>
 *     &lt;xs:enumeration value="FRF"/>
 *     &lt;xs:enumeration value="GBP"/>
 *     &lt;xs:enumeration value="GEL"/>
 *     &lt;xs:enumeration value="GHC"/>
 *     &lt;xs:enumeration value="GHS"/>
 *     &lt;xs:enumeration value="GIP"/>
 *     &lt;xs:enumeration value="GMD"/>
 *     &lt;xs:enumeration value="GNF"/>
 *     &lt;xs:enumeration value="GRD"/>
 *     &lt;xs:enumeration value="GTQ"/>
 *     &lt;xs:enumeration value="GWP"/>
 *     &lt;xs:enumeration value="GYD"/>
 *     &lt;xs:enumeration value="HKD"/>
 *     &lt;xs:enumeration value="HNL"/>
 *     &lt;xs:enumeration value="HRK"/>
 *     &lt;xs:enumeration value="HTG"/>
 *     &lt;xs:enumeration value="HUF"/>
 *     &lt;xs:enumeration value="IDR"/>
 *     &lt;xs:enumeration value="IEP"/>
 *     &lt;xs:enumeration value="ILS"/>
 *     &lt;xs:enumeration value="INR"/>
 *     &lt;xs:enumeration value="IQD"/>
 *     &lt;xs:enumeration value="IRR"/>
 *     &lt;xs:enumeration value="ISK"/>
 *     &lt;xs:enumeration value="ITL"/>
 *     &lt;xs:enumeration value="JMD"/>
 *     &lt;xs:enumeration value="JOD"/>
 *     &lt;xs:enumeration value="JPY"/>
 *     &lt;xs:enumeration value="KES"/>
 *     &lt;xs:enumeration value="KGS"/>
 *     &lt;xs:enumeration value="KHR"/>
 *     &lt;xs:enumeration value="KMF"/>
 *     &lt;xs:enumeration value="KPW"/>
 *     &lt;xs:enumeration value="KRW"/>
 *     &lt;xs:enumeration value="KWD"/>
 *     &lt;xs:enumeration value="KYD"/>
 *     &lt;xs:enumeration value="KZT"/>
 *     &lt;xs:enumeration value="LAK"/>
 *     &lt;xs:enumeration value="LBP"/>
 *     &lt;xs:enumeration value="LKR"/>
 *     &lt;xs:enumeration value="LRD"/>
 *     &lt;xs:enumeration value="LSL"/>
 *     &lt;xs:enumeration value="LTL"/>
 *     &lt;xs:enumeration value="LUF"/>
 *     &lt;xs:enumeration value="LVL"/>
 *     &lt;xs:enumeration value="LYD"/>
 *     &lt;xs:enumeration value="MAD"/>
 *     &lt;xs:enumeration value="MDL"/>
 *     &lt;xs:enumeration value="MGA"/>
 *     &lt;xs:enumeration value="MGF"/>
 *     &lt;xs:enumeration value="MKD"/>
 *     &lt;xs:enumeration value="MMK"/>
 *     &lt;xs:enumeration value="MNT"/>
 *     &lt;xs:enumeration value="MOP"/>
 *     &lt;xs:enumeration value="MRO"/>
 *     &lt;xs:enumeration value="MTL"/>
 *     &lt;xs:enumeration value="MUR"/>
 *     &lt;xs:enumeration value="MVR"/>
 *     &lt;xs:enumeration value="MWK"/>
 *     &lt;xs:enumeration value="MXN"/>
 *     &lt;xs:enumeration value="MXV"/>
 *     &lt;xs:enumeration value="MYR"/>
 *     &lt;xs:enumeration value="MZM"/>
 *     &lt;xs:enumeration value="MZN"/>
 *     &lt;xs:enumeration value="NAD"/>
 *     &lt;xs:enumeration value="NGN"/>
 *     &lt;xs:enumeration value="NIO"/>
 *     &lt;xs:enumeration value="NLG"/>
 *     &lt;xs:enumeration value="NOK"/>
 *     &lt;xs:enumeration value="NPR"/>
 *     &lt;xs:enumeration value="NZD"/>
 *     &lt;xs:enumeration value="OMR"/>
 *     &lt;xs:enumeration value="PAB"/>
 *     &lt;xs:enumeration value="PEN"/>
 *     &lt;xs:enumeration value="PGK"/>
 *     &lt;xs:enumeration value="PHP"/>
 *     &lt;xs:enumeration value="PKR"/>
 *     &lt;xs:enumeration value="PLN"/>
 *     &lt;xs:enumeration value="PTE"/>
 *     &lt;xs:enumeration value="PYG"/>
 *     &lt;xs:enumeration value="QAR"/>
 *     &lt;xs:enumeration value="ROL"/>
 *     &lt;xs:enumeration value="RON"/>
 *     &lt;xs:enumeration value="RSD"/>
 *     &lt;xs:enumeration value="RUB"/>
 *     &lt;xs:enumeration value="RUR"/>
 *     &lt;xs:enumeration value="RWF"/>
 *     &lt;xs:enumeration value="SAR"/>
 *     &lt;xs:enumeration value="SBD"/>
 *     &lt;xs:enumeration value="SCR"/>
 *     &lt;xs:enumeration value="SDD"/>
 *     &lt;xs:enumeration value="SDG"/>
 *     &lt;xs:enumeration value="SEK"/>
 *     &lt;xs:enumeration value="SGD"/>
 *     &lt;xs:enumeration value="SHP"/>
 *     &lt;xs:enumeration value="SIT"/>
 *     &lt;xs:enumeration value="SKK"/>
 *     &lt;xs:enumeration value="SLL"/>
 *     &lt;xs:enumeration value="SOS"/>
 *     &lt;xs:enumeration value="SRD"/>
 *     &lt;xs:enumeration value="SRG"/>
 *     &lt;xs:enumeration value="SSP"/>
 *     &lt;xs:enumeration value="STD"/>
 *     &lt;xs:enumeration value="STN"/>
 *     &lt;xs:enumeration value="SVC"/>
 *     &lt;xs:enumeration value="SYP"/>
 *     &lt;xs:enumeration value="SZL"/>
 *     &lt;xs:enumeration value="THB"/>
 *     &lt;xs:enumeration value="TJR"/>
 *     &lt;xs:enumeration value="TJS"/>
 *     &lt;xs:enumeration value="TMM"/>
 *     &lt;xs:enumeration value="TMT"/>
 *     &lt;xs:enumeration value="TND"/>
 *     &lt;xs:enumeration value="TOP"/>
 *     &lt;xs:enumeration value="TPE"/>
 *     &lt;xs:enumeration value="TRL"/>
 *     &lt;xs:enumeration value="TRY"/>
 *     &lt;xs:enumeration value="TTD"/>
 *     &lt;xs:enumeration value="TWD"/>
 *     &lt;xs:enumeration value="TZS"/>
 *     &lt;xs:enumeration value="UAH"/>
 *     &lt;xs:enumeration value="UGX"/>
 *     &lt;xs:enumeration value="USD"/>
 *     &lt;xs:enumeration value="USN"/>
 *     &lt;xs:enumeration value="USS"/>
 *     &lt;xs:enumeration value="UYI"/>
 *     &lt;xs:enumeration value="UYU"/>
 *     &lt;xs:enumeration value="UZS"/>
 *     &lt;xs:enumeration value="VEB"/>
 *     &lt;xs:enumeration value="VEF"/>
 *     &lt;xs:enumeration value="VND"/>
 *     &lt;xs:enumeration value="VUV"/>
 *     &lt;xs:enumeration value="WST"/>
 *     &lt;xs:enumeration value="XAF"/>
 *     &lt;xs:enumeration value="XAG"/>
 *     &lt;xs:enumeration value="XAU"/>
 *     &lt;xs:enumeration value="XBA"/>
 *     &lt;xs:enumeration value="XBB"/>
 *     &lt;xs:enumeration value="XBC"/>
 *     &lt;xs:enumeration value="XBD"/>
 *     &lt;xs:enumeration value="XCD"/>
 *     &lt;xs:enumeration value="XDR"/>
 *     &lt;xs:enumeration value="XFO"/>
 *     &lt;xs:enumeration value="XFU"/>
 *     &lt;xs:enumeration value="XOF"/>
 *     &lt;xs:enumeration value="XPD"/>
 *     &lt;xs:enumeration value="XPF"/>
 *     &lt;xs:enumeration value="XPT"/>
 *     &lt;xs:enumeration value="XSU"/>
 *     &lt;xs:enumeration value="XTS"/>
 *     &lt;xs:enumeration value="XUA"/>
 *     &lt;xs:enumeration value="XXX"/>
 *     &lt;xs:enumeration value="YER"/>
 *     &lt;xs:enumeration value="YUM"/>
 *     &lt;xs:enumeration value="ZAL"/>
 *     &lt;xs:enumeration value="ZAR"/>
 *     &lt;xs:enumeration value="ZMK"/>
 *     &lt;xs:enumeration value="ZMW"/>
 *     &lt;xs:enumeration value="ZRN"/>
 *     &lt;xs:enumeration value="ZWD"/>
 *     &lt;xs:enumeration value="ZWL"/>
 *     &lt;xs:enumeration value="BYN"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum CurrencyCodeList implements Serializable {
    /** 
     * Andorran Peseta: Andorra
     */
    ADP, /** 
          * UAE Dirham: United Arab Emirates
          */
    AED, /** 
          * Afghani: Afghanistan; replaced in 2003 by AFN
          */
    AFA, /** 
          * Afghani: Afghanistan;
          */
    AFN, /** 
          * Lek: Albania
          */
    ALL, /** 
          * Armenian Dram: Armenia
          */
    AMD, /** 
          * Antillian Guilder: Netherlands Antilles
          */
    ANG, /** 
          * Angolan Kwanza: Angola
          */
    AOA, /** 
          * New Kwanza: Angola; used until 1995, now AOA
          */
    AON, /** 
          * Kwanza Reajustado: Angola; used until 1995, now AON
          */
    AOR, /** 
          * Argentine Peso: Argentina
          */
    ARS, /** 
          * Schilling: Austria; replaced by Euro in 2002
          */
    ATS, /** 
          * Australian Dollar: Australia, Christmas Island, Cocos (Keeling) Islands, Heard
                            and Mcdonald Islands, Kiribati, Nauru, Norfolk Island, Tuvalu
                        
          */
    AUD, /** 
          * Aruban Guilder: Aruba
          */
    AWG, /** 
          * Azerbaijanian Manat: Azerbaijan; replaced by AZN in 2006
          */
    AZM, /** 
          * Azerbaijani Manat: Azerbaijan
          */
    AZN, /** 
          * Convertible Marks: Bosnia and Herzegovina
          */
    BAM, /** 
          * Barbados Dollar: Barbados
          */
    BBD, /** 
          * Taka: Bangladesh
          */
    BDT, /** 
          * Belgian Franc: Belgium; replaced by Euro in 2002
          */
    BEF, /** 
          * Lev: Bulgaria; replaced by BGN in 1999
          */
    BGL, /** 
          * Bulgarian LEV: Bulgaria
          */
    BGN, /** 
          * Bahraini Dinar: Bahrain
          */
    BHD, /** 
          * Burundi Franc: Burundi
          */
    BIF, /** 
          * Bermudian Dollar: Bermuda
          */
    BMD, /** 
          * Brunei Dollar: Brunei Darussalam
          */
    BND, /** 
          * Bolivian Boliviano: Bolivia
          */
    BOB, /** 
          * Bolivian MVDOL: Bolivia (not in circulation)
          */
    BOV, /** 
          * Brazilian Real: Brazil
          */
    BRL, /** 
          * Bahamian Dollar: Bahamas
          */
    BSD, /** 
          * Ngultrum: Bhutan
          */
    BTN, /** 
          * Pula: Botswana
          */
    BWP, /** 
          * Belarussian Ruble: Belarus
          */
    BYR, /** 
          * Belize Dollar: Belize
          */
    BZD, /** 
          * Canadian Dollar: Canada
          */
    CAD, /** 
          * Franc Congolais: Congo, The Democratic Republic Of
          */
    CDF, /** 
          * WIR Euro(complementary currency): Switzerland
          */
    CHE, /** 
          * Swiss Franc: Liechtenstein, Switzerland
          */
    CHF, /** 
          * WIR Franc (complementary currency): Switzerland
          */
    CHW, /** 
          * Unidades de fomento: Chile
          */
    CLF, /** 
          * Chilean Peso: Chile
          */
    CLP, /** 
          * Yuan Renminbi: China
          */
    CNY, /** 
          * Colombian Peso: Colombia
          */
    COP, /** 
          * Unidad de Valor Real: Colombia
          */
    COU, /** 
          * Costa Rican Colon: Costa Rica
          */
    CRC, /** 
          * Cuban Peso: Cuba
          */
    CUP, /** 
          * Cuban Convertible Peso: Cuba
          */
    CUC, /** 
          * Cape Verde Escudo: Cape Verde
          */
    CVE, /** 
          * Cyprus Pound: Cyprus; replaced by Euro in 2007
          */
    CYP, /** 
          * Czech Koruna: Czech Republic
          */
    CZK, /** 
          * Deutsche Mark: Germany; replaced by Euro in 2002
          */
    DEM, /** 
          * Djibouti Franc: Djibouti
          */
    DJF, /** 
          * Danish Krone: Denmark, Faeroe Islands, Greenland
          */
    DKK, /** 
          * Dominican Peso: Dominican Republic
          */
    DOP, /** 
          * Algerian Dinar: Algeria
          */
    DZD, /** 
          * Sucre: Ecuador; ; replaced by US Dollar in 2000
          */
    ECS, /** 
          * Unidad de Valor Constante (UVC): Ecuador; not used since 2000
          */
    ECV, /** 
          * Kroon: Estonia; replaced by Euro in 2011
          */
    EEK, /** 
          * Egyptian Pound: Egypt
          */
    EGP, /** 
          * Nakfa: Eritrea
          */
    ERN, /** 
          * Spanish Peseta: Andorra, Spain; replaced by Euro in 2002
          */
    ESP, /** 
          * Ethiopian Birr: Ethiopia
          */
    ETB, /** 
          * Euro:
          */
    EUR, /** 
          * Markka: Finland; replaced by Euro in 2002
          */
    FIM, /** 
          * Fiji Dollar: Fiji
          */
    FJD, /** 
          * Pound: Falkland Islands (Malvinas)
          */
    FKP, /** 
          * French Franc: Andorra, France, French Guiana, French Southern Territories,
                            Guadeloupe, Martinique, Monaco, Reunion, St Pierre and Miquelon; replaced by Euro in 1999
                        
          */
    FRF, /** 
          * Pound Sterling: United Kingdom
          */
    GBP, /** 
          * Lari: Georgia
          */
    GEL, /** 
          * Cedi: Ghana; replaced in 2007 by Ghanaian New Cedi GHS
          */
    GHC, /** 
          * Cedi: Ghana
          */
    GHS, /** 
          * Gibraltar Pound: Gibraltar
          */
    GIP, /** 
          * Dalasi: Gambia
          */
    GMD, /** 
          * Guinea Franc: Guinea
          */
    GNF, /** 
          * Drachma: Greece; replaced by Euro in 2002
          */
    GRD, /** 
          * Quetzal: Guatemala
          */
    GTQ, /** 
          * Guinea-Bissau Peso: Guinea-Bissau; replaced by CFA franc in 1997
                        
          */
    GWP, /** 
          * Guyana Dollar: Guyana
          */
    GYD, /** 
          * Hong Kong Dollar: Hong Kong
          */
    HKD, /** 
          * Lempira: Honduras
          */
    HNL, /** 
          * Kuna: Croatia
          */
    HRK, /** 
          * Gourde: Haiti
          */
    HTG, /** 
          * Forint: Hungary
          */
    HUF, /** 
          * Rupiah: East Timor, Indonesia
          */
    IDR, /** 
          * Irish Pound: Ireland; replaced by Euro in 2009
          */
    IEP, /** 
          * New Israeli Sheqel: Israel
          */
    ILS, /** 
          * Indian Rupee: Bhutan, India
          */
    INR, /** 
          * Iraqi Dinar: Iraq
          */
    IQD, /** 
          * Iranian Rial: Iran (Islamic Republic Of)
          */
    IRR, /** 
          * Iceland Krona: Iceland
          */
    ISK, /** 
          * Italian Lira: Italy, San Marino, Vatican City State (Holy See); replaced by Euro
                            in 1999
                        
          */
    ITL, /** 
          * Jamaican Dollar: Jamaica
          */
    JMD, /** 
          * Jordanian Dinar: Jordan
          */
    JOD, /** 
          * Yen: Japan
          */
    JPY, /** 
          * Kenyan Shilling: Kenya
          */
    KES, /** 
          * Som: Kyrgyzstan
          */
    KGS, /** 
          * Riel: Cambodia
          */
    KHR, /** 
          * Comoro Franc: Comoros
          */
    KMF, /** 
          * North Korean Won: Korea, Democratic People's Republic Of
          */
    KPW, /** 
          * Won: Korea, Republic Of
          */
    KRW, /** 
          * Kuwaiti Dinar: Kuwait
          */
    KWD, /** 
          * Cayman Islands Dollar: Cayman Islands
          */
    KYD, /** 
          * Tenge: Kazakhstan
          */
    KZT, /** 
          * Kip: Lao People's Democratic Republic
          */
    LAK, /** 
          * Lebanese Pound: Lebanon
          */
    LBP, /** 
          * Sri Lanka Rupee: Sri Lanka
          */
    LKR, /** 
          * Liberian Dollar: Liberia
          */
    LRD, /** 
          * Loti: Lesotho
          */
    LSL, /** 
          * Lithuanian Litas: Lithuania; replaced by Euro in 2015
          */
    LTL, /** 
          * Luxembourg Franc: Luxembourg; replaced by Euro in 2002
          */
    LUF, /** 
          * Latvian Lats: Latvia; replaced by Euro in 2014
          */
    LVL, /** 
          * Libyan Dinar: Libyan Arab Jamahiriya
          */
    LYD, /** 
          * Moroccan Dirham: Morocco, Western Sahara
          */
    MAD, /** 
          * Moldovan Leu: Moldova, Republic Of
          */
    MDL, /** 
          * Malagasy Ariary: Madagascar
          */
    MGA, /** 
          * Malagasy Franc: Madagascar; replaced by Ariary in 2005
          */
    MGF, /** 
          * Denar: Macedonia, The Former Yugoslav Republic Of
          */
    MKD, /** 
          * Kyat: Myanmar
          */
    MMK, /** 
          * Tugrik: Mongolia
          */
    MNT, /** 
          * Pataca: Macau
          */
    MOP, /** 
          * Ouguiya: Mauritania
          */
    MRO, /** 
          * Maltese Lira: Malta; replaced by Euro in 2008
          */
    MTL, /** 
          * Mauritius Rupee: Mauritius
          */
    MUR, /** 
          * Rufiyaa: Maldives
          */
    MVR, /** 
          * Kwacha: Malawi
          */
    MWK, /** 
          * Mexican Peso: Mexico
          */
    MXN, /** 
          * Mexican Unidad de Inversion (UDI): Mexico
          */
    MXV, /** 
          * Malaysian Ringgit: Malaysia
          */
    MYR, /** 
          * Metical: Mozambique; replaced by MZN in 2012
          */
    MZM, /** 
          * Metical: Mozambique
          */
    MZN, /** 
          * Namibia Dollar: Namibia
          */
    NAD, /** 
          * Naira: Nigeria
          */
    NGN, /** 
          * Cordoba Oro: Nicaragua
          */
    NIO, /** 
          * Netherlands Guilder: Netherlands; replaced by Euro in 2002
          */
    NLG, /** 
          * Norwegian Krone: Bouvet Island, Norway, Svalbard and Jan Mayen Islands
                        
          */
    NOK, /** 
          * Nepalese Rupee: Nepal
          */
    NPR, /** 
          * New Zealand Dollar: Cook Islands, New Zealand, Niue, Pitcairn, Tokelau
                        
          */
    NZD, /** 
          * Rial Omani: Oman
          */
    OMR, /** 
          * Balboa: Panama
          */
    PAB, /** 
          * Nuevo Sol: Peru
          */
    PEN, /** 
          * Kina: Papua New Guinea
          */
    PGK, /** 
          * Philippine Peso: Philippines
          */
    PHP, /** 
          * Pakistan Rupee: Pakistan
          */
    PKR, /** 
          * Zloty: Poland
          */
    PLN, /** 
          * Portuguese Escudo: Portugal; replaced by Euro in 2002
          */
    PTE, /** 
          * Guarani: Paraguay
          */
    PYG, /** 
          * Qatari Rial: Qatar
          */
    QAR, /** 
          * Leu: Romania; replaced by RON in 2005
          */
    ROL, /** 
          * Leu: Romania
          */
    RON, /** 
          * Serbian Dinar: Serbia
          */
    RSD, /** 
          * Russian Ruble: Russian Federation
          */
    RUB, /** 
          * Russian Ruble: Russian Federation; replaced by RUB in 1998, but the code is still
                            in use
                        
          */
    RUR, /** 
          * Rwanda Franc: Rwanda
          */
    RWF, /** 
          * Saudi Riyal: Saudi Arabia
          */
    SAR, /** 
          * Solomon Islands Dollar: Solomon Islands
          */
    SBD, /** 
          * Seychelles Rupee: Seychelles
          */
    SCR, /** 
          * Sudanese Dinar: Sudan; replased by Sudanese Pound (SDG) in 2007
                        
          */
    SDD, /** 
          * Sudanese Pound: Sudan
          */
    SDG, /** 
          * Swedish Krona: Sweden
          */
    SEK, /** 
          * Singapore Dollar: Singapore
          */
    SGD, /** 
          * St Helena Pound: St Helena
          */
    SHP, /** 
          * Tolar: Slovenia; replaced by Euro in 2007
          */
    SIT, /** 
          * Slovak Koruna: Slovakia; replaced by Euro in 2009
          */
    SKK, /** 
          * Leone: Sierra Leone
          */
    SLL, /** 
          * Somali Shilling: Somalia
          */
    SOS, /** 
          * Surinam Dollar: Suriname
          */
    SRD, /** 
          * Surinam Guilder: Suriname; replaced by Suriname Guilder in 2004
                        
          */
    SRG, /** 
          * South Sudanese Pound; South Sudan
          */
    SSP, /** 
          * Dobra: Sao Tome and Principe (before 12/01/17)
          */
    STD, /** 
          * Dobra: Sao Tome and Principe (after 12/01/17)
          */
    STN, /** 
          * El Salvador Colon: El Salvador
          */
    SVC, /** 
          * Syrian Pound: Syrian Arab Republic
          */
    SYP, /** 
          * Lilangeni: Swaziland
          */
    SZL, /** 
          * Baht: Thailand
          */
    THB, /** 
          * Tajik Ruble (old): Tajikistan (Old); replaced by Somoni (TJS) in 2000
                        
          */
    TJR, /** 
          * Somoni: Tajikistan
          */
    TJS, /** 
          * Manat: Turkmenistan; replaced by TMT in 2009
          */
    TMM, /** 
          * Manat: Turkmenistan
          */
    TMT, /** 
          * Tunisian Dinar: Tunisia
          */
    TND, /** 
          * Pa'anga: Tonga
          */
    TOP, /** 
          * Timor Escudo: East Timor; replaced by USD
          */
    TPE, /** 
          * Turkish Lira: Turkey; replaced by TRY in 2005
          */
    TRL, /** 
          * Turkish Lira: Turkey
          */
    TRY, /** 
          * Trinidad and Tobago Dollar: Trinidad and Tobago
          */
    TTD, /** 
          * New Taiwan Dollar: Taiwan, Province Of China
          */
    TWD, /** 
          * Tanzanian Shilling: Tanzania, United Republic Of
          */
    TZS, /** 
          * Hryvnia: Ukraine
          */
    UAH, /** 
          * Uganda Shilling: Uganda
          */
    UGX, /** 
          * US Dollar: American Samoa, British Indian Ocean Territory,, Guam, Haiti, Marshall
                            Islands, Micronesia, Northern Mariana Islands, Palau, Panama, Puerto Rico, Turks and Caicos
                            Islands, United States, United States Minor Outlaying Islands, Virgin Islands (British), Virgin
                            Islands (U.S.)
                        
          */
    USD, /** 
          * (Next day): United States
          */
    USN, /** 
          * (Same day): United States
          */
    USS, /** 
          * Uruguay Peso en Unidades Indexadas (URUIURUI) (funds code): Uruguay
                        
          */
    UYI, /** 
          * Peso Uruguayo: Uruguay
          */
    UYU, /** 
          * Uzbekistan Sum: Uzbekistan
          */
    UZS, /** 
          * Bolivar: Venezuela
          */
    VEB, /** 
          * Bolivar: Venezuela
          */
    VEF, /** 
          * Dong: Vietnam
          */
    VND, /** 
          * Vatu: Vanuatu
          */
    VUV, /** 
          * Tala: Samoa
          */
    WST, /** 
          * CFA Franc BEAC: Cameroon, Central African Republic, Chad, Congo, Equatorial
                            Guinea, Gabon
                        
          */
    XAF, /** 
          * Silver: Bond Markets Units
          */
    XAG, /** 
          * Gold Bond Markets Units:
          */
    XAU, /** 
          * European Composite Unit (EURCO): Bond Markets Units
          */
    XBA, /** 
          * European Monetary Unit (E.M.U.-6): Bond Markets Units
          */
    XBB, /** 
          * European Unit of Account 9 (E.U.A.- 9): Bond Markets Units
          */
    XBC, /** 
          * European Unit of Account 17 (E.U.A.- 17): Bond Markets Units
          */
    XBD, /** 
          * East Caribbean Dollar: Anguilla, Antigua and Barbuda, Dominica, Grenada,
                            Montserrat, St Kitts - Nevis, Saint Lucia, Saint Vincent and The Grenadines
                        
          */
    XCD, /** 
          * SDR: International Monetary Fund (Imf)
          */
    XDR, /** 
          * Gold-Franc: Special settlement currencies; replaced by Special Drawing Rights
                            (XDR) in 2003
                        
          */
    XFO, /** 
          * UIC-Franc: Special settlement currencies; replaced by EURO in 2013
                        
          */
    XFU, /** 
          * CFA Franc BCEAO: Benin, Burkina Faso, Cote D'ivoire, Guinea-Bissau, Mali, Niger,
                            Senegal, Togo
                        
          */
    XOF, /** 
          * Palladium: Bond Markets Units
          */
    XPD, /** 
          * CFP Franc: French Polynesia, New Caledonia, Wallis and Futuna Islands
                        
          */
    XPF, /** 
          * Platinum: Bond Markets Units
          */
    XPT, /** 
          * SUCRE: Unified System for Regional Compensation (SUCRE)[
          */
    XSU, /** 
          * Codes specifically reserved for testing purposes:
          */
    XTS, /** 
          * ADB Unit of Account: African Development Bank[
          */
    XUA, /** 
          * The codes assigned for transactions where no currency is involved are::
                        
          */
    XXX, /** 
          * Yemeni Rial: Yemen
          */
    YER, /** 
          * New Dinar: Yugoslavia;
          */
    YUM, /** 
          * (financial Rand): Lesotho; not used since 1995ZM
          */
    ZAL, /** 
          * Rand: Lesotho, Namibia, South Africa
          */
    ZAR, /** 
          * Kwacha: Zambia; replaced by ZMW in 2012
          */
    ZMK, /** 
          * Kwacha: Zambia
          */
    ZMW, /** 
          * New Zaire: Zaire; replaced by Congolese Franc in 1998
          */
    ZRN, /** 
          * Zimbabwe Dollar: Zimbabwe; replaced by Zimbabwean Dollar in 2009
                        
          */
    ZWD, /** 
          * Zimbabwean Dollar: Zimbabwe
          */
    ZWL, /** 
          * Belarusian Ruble: Belarus
          */
    BYN
}
