
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Format:

 3DOCA(segment number)/(address
 type)/(country)/(street)/(city)/(state or province)/(zip
 or postal code)/(lap child indicator)/(pnr name assoc)

 * enter destinationa address info 3DOCA2/D/GB/10 DOWNING
 STREET/LONDON/EN/7A1 H30-2.1

 * lap child 3DOC12/D/USA/987 CENTER
 ST/AUSTIN/TX/76160/I-1.2

 * enter residence address info 3DOCA1/R/US/1234
 MAIN/EULESS/TX/76040-1.2

 * enter address info with multiple segment selection
 3DOCA2,3/R/GBR/14 CHARING RD/LONDON/EN/7A1 H3P

 * enter residence address with mandatory components only
 3DOCA/R/GB

 * enter desitnation address with mandatory components
 only 3DOCA/D/USA/SHERATON WAIKIKI/HONOLULU/HAWAII

 * delete a DOCA entry 3(line/itme number)¤ 37¤

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DOCAEntry.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:AddressType.RD.PNRB" name="AddressType" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Country" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Street" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="City" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="StateProvince" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PostCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="LapChild" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FreeText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="ActionCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:integer" name="NumberInParty" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:RequestType.PNRB" name="type"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DOCAEntryPNRB implements Serializable
{
    private AddressTypeRDPNRB addressType;
    private String country;
    private String street;
    private String city;
    private String stateProvince;
    private String postCode;
    private Boolean lapChild;
    private String freeText;
    private String actionCode;
    private BigInteger numberInParty;
    private String id;
    private RequestTypePNRB type;
    private OperationTypePNRB op;
    private String RPH;

    /** 
     * Get the 'AddressType' element value. R = Residence D = Destination
     * 
     * @return value
     */
    public AddressTypeRDPNRB getAddressType() {
        return addressType;
    }

    /** 
     * Set the 'AddressType' element value. R = Residence D = Destination
     * 
     * @param addressType
     */
    public void setAddressType(AddressTypeRDPNRB addressType) {
        this.addressType = addressType;
    }

    /** 
     * Get the 'Country' element value.
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' element value.
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'Street' element value.
     * 
     * @return value
     */
    public String getStreet() {
        return street;
    }

    /** 
     * Set the 'Street' element value.
     * 
     * @param street
     */
    public void setStreet(String street) {
        this.street = street;
    }

    /** 
     * Get the 'City' element value.
     * 
     * @return value
     */
    public String getCity() {
        return city;
    }

    /** 
     * Set the 'City' element value.
     * 
     * @param city
     */
    public void setCity(String city) {
        this.city = city;
    }

    /** 
     * Get the 'StateProvince' element value.
     * 
     * @return value
     */
    public String getStateProvince() {
        return stateProvince;
    }

    /** 
     * Set the 'StateProvince' element value.
     * 
     * @param stateProvince
     */
    public void setStateProvince(String stateProvince) {
        this.stateProvince = stateProvince;
    }

    /** 
     * Get the 'PostCode' element value.
     * 
     * @return value
     */
    public String getPostCode() {
        return postCode;
    }

    /** 
     * Set the 'PostCode' element value.
     * 
     * @param postCode
     */
    public void setPostCode(String postCode) {
        this.postCode = postCode;
    }

    /** 
     * Get the 'LapChild' element value.
     * 
     * @return value
     */
    public Boolean getLapChild() {
        return lapChild;
    }

    /** 
     * Set the 'LapChild' element value.
     * 
     * @param lapChild
     */
    public void setLapChild(Boolean lapChild) {
        this.lapChild = lapChild;
    }

    /** 
     * Get the 'FreeText' element value. Flight and freetext data. Ex. "DOCA LA HK1/D/US/987 MAIN/EULESS/TEXAS/76040"
                      
     * 
     * @return value
     */
    public String getFreeText() {
        return freeText;
    }

    /** 
     * Set the 'FreeText' element value. Flight and freetext data. Ex. "DOCA LA HK1/D/US/987 MAIN/EULESS/TEXAS/76040"
                      
     * 
     * @param freeText
     */
    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }

    /** 
     * Get the 'ActionCode' element value. Indication of the status of the SSR notification.
                          A value of 'HK' indicates the intended carrier has received the message and has confirmed its
                          contents. Ex. "HK"
                      
     * 
     * @return value
     */
    public String getActionCode() {
        return actionCode;
    }

    /** 
     * Set the 'ActionCode' element value. Indication of the status of the SSR notification.
                          A value of 'HK' indicates the intended carrier has received the message and has confirmed its
                          contents. Ex. "HK"
                      
     * 
     * @param actionCode
     */
    public void setActionCode(String actionCode) {
        this.actionCode = actionCode;
    }

    /** 
     * Get the 'NumberInParty' element value. Number of passengers for whom the Special Service Request is being requested.
                          Ex."1"
                      
     * 
     * @return value
     */
    public BigInteger getNumberInParty() {
        return numberInParty;
    }

    /** 
     * Set the 'NumberInParty' element value. Number of passengers for whom the Special Service Request is being requested.
                          Ex."1"
                      
     * 
     * @param numberInParty
     */
    public void setNumberInParty(BigInteger numberInParty) {
        this.numberInParty = numberInParty;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @return value
     */
    public RequestTypePNRB getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @param type
     */
    public void setType(RequestTypePNRB type) {
        this.type = type;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
