
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Can be name associated.

 formats:

 * add emergency information (GFAX AND AFAX)
 4PCTC/(contact name)/(country code)(phone number)-(name
 number) 4PCTC/PIERRE BOUVIER/US 817 555 0000-1.1

 * add emergency information with free text (GFAX AND
 AFAX) 4PCTC/(contact name)/(country code) (phone
 number)/(free text)
 4PCTC/MEIER THOMAS/DE 49 9131 45567/HOME

 * indicate that passenger has refused to provide
 emergency contact info (GFAX AND AFAX)

 4PCTC//

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EmergencyContactRequest.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="ContactName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CountryCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PhoneNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FreeText" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="Comment" minOccurs="0"/>
 *     &lt;xs:element type="xs:boolean" name="PassengerRefusal" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="VendorCode" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:RequestType.PNRB" name="type"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 *   &lt;xs:attribute type="xs:string" name="RPH"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class EmergencyContactRequestPNRB implements Serializable
{
    private String contactName;
    private String countryCode;
    private String phoneNumber;
    private String freeText;
    private String comment;
    private Boolean passengerRefusal;
    private String vendorCode;
    private String id;
    private RequestTypePNRB type;
    private OperationTypePNRB op;
    private String RPH;

    /** 
     * Get the 'ContactName' element value. Name given by the passenger as an emergency contact
                          in a PCTC SSR message that can be reached at the EmergencyPhoneNumber. Ex. " SMITH/ANNE"
                      
     * 
     * @return value
     */
    public String getContactName() {
        return contactName;
    }

    /** 
     * Set the 'ContactName' element value. Name given by the passenger as an emergency contact
                          in a PCTC SSR message that can be reached at the EmergencyPhoneNumber. Ex. " SMITH/ANNE"
                      
     * 
     * @param contactName
     */
    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    /** 
     * Get the 'CountryCode' element value. The country code corresponding to the EmergencyPhoneNumber in a PCTC SSR message.
                          Ex."PL"
                      
     * 
     * @return value
     */
    public String getCountryCode() {
        return countryCode;
    }

    /** 
     * Set the 'CountryCode' element value. The country code corresponding to the EmergencyPhoneNumber in a PCTC SSR message.
                          Ex."PL"
                      
     * 
     * @param countryCode
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /** 
     * Get the 'PhoneNumber' element value. must not contain dashes and must include the
                          entire telephone number including area codes,
                          etc...
                      
     * 
     * @return value
     */
    public String getPhoneNumber() {
        return phoneNumber;
    }

    /** 
     * Set the 'PhoneNumber' element value. must not contain dashes and must include the
                          entire telephone number including area codes,
                          etc...
                      
     * 
     * @param phoneNumber
     */
    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    /** 
     * Get the 'FreeText' element value.
     * 
     * @return value
     */
    public String getFreeText() {
        return freeText;
    }

    /** 
     * Set the 'FreeText' element value.
     * 
     * @param freeText
     */
    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }

    /** 
     * Get the 'Comment' element value. Free text associated with the PCTC SSR, often indicating the relationship
                          of the EmergencyContactName to the passenger; Also used for the text accompanying an
                          OSI message starting with 'CTC'.
                      
     * 
     * @return value
     */
    public String getComment() {
        return comment;
    }

    /** 
     * Set the 'Comment' element value. Free text associated with the PCTC SSR, often indicating the relationship
                          of the EmergencyContactName to the passenger; Also used for the text accompanying an
                          OSI message starting with 'CTC'.
                      
     * 
     * @param comment
     */
    public void setComment(String comment) {
        this.comment = comment;
    }

    /** 
     * Get the 'PassengerRefusal' element value. True/False indicates whether the pax refused to provide emergency contact info.
                          Ex."TRUE"
                      
     * 
     * @return value
     */
    public Boolean getPassengerRefusal() {
        return passengerRefusal;
    }

    /** 
     * Set the 'PassengerRefusal' element value. True/False indicates whether the pax refused to provide emergency contact info.
                          Ex."TRUE"
                      
     * 
     * @param passengerRefusal
     */
    public void setPassengerRefusal(Boolean passengerRefusal) {
        this.passengerRefusal = passengerRefusal;
    }

    /** 
     * Get the 'VendorCode' element value. Carrier OSI/SSR is being sent to. Ex."EY"
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' element value. Carrier OSI/SSR is being sent to. Ex."EY"
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @return value
     */
    public RequestTypePNRB getType() {
        return type;
    }

    /** 
     * Set the 'type' attribute value. A = AFAX G = GFAX
     * 
     * @param type
     */
    public void setType(RequestTypePNRB type) {
        this.type = type;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }

    /** 
     * Get the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @return value
     */
    public String getRPH() {
        return RPH;
    }

    /** 
     * Set the 'RPH' attribute value. The Reference Place Holder (RPH) is an index code used to identify an instance
                      in a collection of like items (e.g. used to assign individual passengers or clients to particular itinerary items).
                  
     * 
     * @param RPH
     */
    public void setRPH(String RPH) {
        this.RPH = RPH;
    }
}
