
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;
import java.util.Date;

/** 
 * Flight and frequent traveler upgrade request
 details

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FqtvUpgradeRequest">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:FlightBasicData">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="xs:string" name="StatusCode" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="OriginalRequestTimestamp" minOccurs="0"/>
 *         &lt;xs:element type="xs:dateTime" name="LocalDepartureDate" minOccurs="0"/>
 *         &lt;xs:element type="xs:int" name="TierLevel" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="RequestedUpgradeClass" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="CompanionData" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="FrequentTravelerAirline" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="FrequentTravelerNumber" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="FreeText" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="SSRPreference" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="SeatPreference" minOccurs="0"/>
 *         &lt;xs:element type="xs:string" name="PassengerName" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:string" name="UpgradeType"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FqtvUpgradeRequest extends FlightBasicData implements Serializable
{
    private String statusCode;
    private Date originalRequestTimestamp;
    private Date localDepartureDate;
    private Integer tierLevel;
    private String requestedUpgradeClass;
    private String companionData;
    private String frequentTravelerAirline;
    private String frequentTravelerNumber;
    private String freeText;
    private String SSRPreference;
    private String seatPreference;
    private String passengerName;
    private String upgradeType;

    /** 
     * Get the 'StatusCode' element value.
     * 
     * @return value
     */
    public String getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' element value.
     * 
     * @param statusCode
     */
    public void setStatusCode(String statusCode) {
        this.statusCode = statusCode;
    }

    /** 
     * Get the 'OriginalRequestTimestamp' element value.
     * 
     * @return value
     */
    public Date getOriginalRequestTimestamp() {
        return originalRequestTimestamp;
    }

    /** 
     * Set the 'OriginalRequestTimestamp' element value.
     * 
     * @param originalRequestTimestamp
     */
    public void setOriginalRequestTimestamp(Date originalRequestTimestamp) {
        this.originalRequestTimestamp = originalRequestTimestamp;
    }

    /** 
     * Get the 'LocalDepartureDate' element value.
     * 
     * @return value
     */
    public Date getLocalDepartureDate() {
        return localDepartureDate;
    }

    /** 
     * Set the 'LocalDepartureDate' element value.
     * 
     * @param localDepartureDate
     */
    public void setLocalDepartureDate(Date localDepartureDate) {
        this.localDepartureDate = localDepartureDate;
    }

    /** 
     * Get the 'TierLevel' element value.
     * 
     * @return value
     */
    public Integer getTierLevel() {
        return tierLevel;
    }

    /** 
     * Set the 'TierLevel' element value.
     * 
     * @param tierLevel
     */
    public void setTierLevel(Integer tierLevel) {
        this.tierLevel = tierLevel;
    }

    /** 
     * Get the 'RequestedUpgradeClass' element value.
     * 
     * @return value
     */
    public String getRequestedUpgradeClass() {
        return requestedUpgradeClass;
    }

    /** 
     * Set the 'RequestedUpgradeClass' element value.
     * 
     * @param requestedUpgradeClass
     */
    public void setRequestedUpgradeClass(String requestedUpgradeClass) {
        this.requestedUpgradeClass = requestedUpgradeClass;
    }

    /** 
     * Get the 'CompanionData' element value.
     * 
     * @return value
     */
    public String getCompanionData() {
        return companionData;
    }

    /** 
     * Set the 'CompanionData' element value.
     * 
     * @param companionData
     */
    public void setCompanionData(String companionData) {
        this.companionData = companionData;
    }

    /** 
     * Get the 'FrequentTravelerAirline' element value.
     * 
     * @return value
     */
    public String getFrequentTravelerAirline() {
        return frequentTravelerAirline;
    }

    /** 
     * Set the 'FrequentTravelerAirline' element value.
     * 
     * @param frequentTravelerAirline
     */
    public void setFrequentTravelerAirline(String frequentTravelerAirline) {
        this.frequentTravelerAirline = frequentTravelerAirline;
    }

    /** 
     * Get the 'FrequentTravelerNumber' element value.
     * 
     * @return value
     */
    public String getFrequentTravelerNumber() {
        return frequentTravelerNumber;
    }

    /** 
     * Set the 'FrequentTravelerNumber' element value.
     * 
     * @param frequentTravelerNumber
     */
    public void setFrequentTravelerNumber(String frequentTravelerNumber) {
        this.frequentTravelerNumber = frequentTravelerNumber;
    }

    /** 
     * Get the 'FreeText' element value.
     * 
     * @return value
     */
    public String getFreeText() {
        return freeText;
    }

    /** 
     * Set the 'FreeText' element value.
     * 
     * @param freeText
     */
    public void setFreeText(String freeText) {
        this.freeText = freeText;
    }

    /** 
     * Get the 'SSRPreference' element value.
     * 
     * @return value
     */
    public String getSSRPreference() {
        return SSRPreference;
    }

    /** 
     * Set the 'SSRPreference' element value.
     * 
     * @param SSRPreference
     */
    public void setSSRPreference(String SSRPreference) {
        this.SSRPreference = SSRPreference;
    }

    /** 
     * Get the 'SeatPreference' element value.
     * 
     * @return value
     */
    public String getSeatPreference() {
        return seatPreference;
    }

    /** 
     * Set the 'SeatPreference' element value.
     * 
     * @param seatPreference
     */
    public void setSeatPreference(String seatPreference) {
        this.seatPreference = seatPreference;
    }

    /** 
     * Get the 'PassengerName' element value.
     * 
     * @return value
     */
    public String getPassengerName() {
        return passengerName;
    }

    /** 
     * Set the 'PassengerName' element value.
     * 
     * @param passengerName
     */
    public void setPassengerName(String passengerName) {
        this.passengerName = passengerName;
    }

    /** 
     * Get the 'UpgradeType' attribute value.
     * 
     * @return value
     */
    public String getUpgradeType() {
        return upgradeType;
    }

    /** 
     * Set the 'UpgradeType' attribute value.
     * 
     * @param upgradeType
     */
    public void setUpgradeType(String upgradeType) {
        this.upgradeType = upgradeType;
    }
}
