
package com.sabre.webservices.pnrbuilder.v119;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FrequentFlyerTSAPreCheckUpdate.PNRB">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:NameAssociationList.PNRB" name="NameAssociationList" minOccurs="0"/>
 *     &lt;xs:element type="ns:SegmentAssociationList.PNRB" name="SegmentAssociationList" minOccurs="0"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:Loyalty.PNRB" name="Loyalty" minOccurs="0"/>
 *       &lt;xs:element type="ns:TSAPreCheck.PNRB" name="TSAPreCheck" minOccurs="0"/>
 *       &lt;xs:element type="ns:PassengerMetaData.PNRB" name="PassengerMetaData" minOccurs="0"/>
 *     &lt;/xs:choice>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="id"/>
 *   &lt;xs:attribute type="ns:OperationType.PNRB" name="op"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FrequentFlyerTSAPreCheckUpdatePNRB implements Serializable
{
    private NameAssociationListPNRB nameAssociationList;
    private SegmentAssociationListPNRB segmentAssociationList;
    private int choiceSelect = -1;
    private static final int LOYALTY_CHOICE = 0;
    private static final int TSA_PRE_CHECK_CHOICE = 1;
    private static final int PASSENGER_META_DATA_CHOICE = 2;
    private LoyaltyPNRB loyalty;
    private TSAPreCheckPNRB TSAPreCheck;
    private PassengerMetaDataPNRB passengerMetaData;
    private String id;
    private OperationTypePNRB op;

    /** 
     * Get the 'NameAssociationList' element value.
     * 
     * @return value
     */
    public NameAssociationListPNRB getNameAssociationList() {
        return nameAssociationList;
    }

    /** 
     * Set the 'NameAssociationList' element value.
     * 
     * @param nameAssociationList
     */
    public void setNameAssociationList(
            NameAssociationListPNRB nameAssociationList) {
        this.nameAssociationList = nameAssociationList;
    }

    /** 
     * Get the 'SegmentAssociationList' element value.
     * 
     * @return value
     */
    public SegmentAssociationListPNRB getSegmentAssociationList() {
        return segmentAssociationList;
    }

    /** 
     * Set the 'SegmentAssociationList' element value.
     * 
     * @param segmentAssociationList
     */
    public void setSegmentAssociationList(
            SegmentAssociationListPNRB segmentAssociationList) {
        this.segmentAssociationList = segmentAssociationList;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Loyalty is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifLoyalty() {
        return choiceSelect == LOYALTY_CHOICE;
    }

    /** 
     * Get the 'Loyalty' element value.
     * 
     * @return value
     */
    public LoyaltyPNRB getLoyalty() {
        return loyalty;
    }

    /** 
     * Set the 'Loyalty' element value.
     * 
     * @param loyalty
     */
    public void setLoyalty(LoyaltyPNRB loyalty) {
        setChoiceSelect(LOYALTY_CHOICE);
        this.loyalty = loyalty;
    }

    /** 
     * Check if TSAPreCheck is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifTSAPreCheck() {
        return choiceSelect == TSA_PRE_CHECK_CHOICE;
    }

    /** 
     * Get the 'TSAPreCheck' element value.
     * 
     * @return value
     */
    public TSAPreCheckPNRB getTSAPreCheck() {
        return TSAPreCheck;
    }

    /** 
     * Set the 'TSAPreCheck' element value.
     * 
     * @param TSAPreCheck
     */
    public void setTSAPreCheck(TSAPreCheckPNRB TSAPreCheck) {
        setChoiceSelect(TSA_PRE_CHECK_CHOICE);
        this.TSAPreCheck = TSAPreCheck;
    }

    /** 
     * Check if PassengerMetaData is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPassengerMetaData() {
        return choiceSelect == PASSENGER_META_DATA_CHOICE;
    }

    /** 
     * Get the 'PassengerMetaData' element value.
     * 
     * @return value
     */
    public PassengerMetaDataPNRB getPassengerMetaData() {
        return passengerMetaData;
    }

    /** 
     * Set the 'PassengerMetaData' element value.
     * 
     * @param passengerMetaData
     */
    public void setPassengerMetaData(PassengerMetaDataPNRB passengerMetaData) {
        setChoiceSelect(PASSENGER_META_DATA_CHOICE);
        this.passengerMetaData = passengerMetaData;
    }

    /** 
     * Get the 'id' attribute value.
     * 
     * @return value
     */
    public String getId() {
        return id;
    }

    /** 
     * Set the 'id' attribute value.
     * 
     * @param id
     */
    public void setId(String id) {
        this.id = id;
    }

    /** 
     * Get the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @return value
     */
    public OperationTypePNRB getOp() {
        return op;
    }

    /** 
     * Set the 'op' attribute value. C = Create, U = Update, D = Delete
     * 
     * @param op
     */
    public void setOp(OperationTypePNRB op) {
        this.op = op;
    }
}
