
package com.sabre.webservices.pnrbuilder.v119;

import com.sabre.services.res.or.v114.PriceQuoteType;
import java.io.Serializable;
import org.w3c.dom.Element;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://webservices.sabre.com/pnrbuilder/v1_19" xmlns:ns1="http://services.sabre.com/res/or/v1_14" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="GetReservationRSType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:Warnings.PNRB" name="Warnings" minOccurs="0"/>
 *     &lt;xs:element type="ns:Errors.PNRB" name="Errors" minOccurs="0"/>
 *     &lt;xs:choice>
 *       &lt;xs:element type="ns:Reservation.PNRB" name="Reservation" minOccurs="0"/>
 *       &lt;xs:element name="Content" minOccurs="0">
 *         &lt;xs:complexType>
 *           &lt;xs:choice>
 *             &lt;xs:any processContents="lax"/>
 *           &lt;/xs:choice>
 *         &lt;/xs:complexType>
 *       &lt;/xs:element>
 *     &lt;/xs:choice>
 *     &lt;xs:element ref="ns1:PriceQuote" minOccurs="0"/>
 *     &lt;xs:element type="ns:VCR" name="VCR" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Version"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class GetReservationRSType implements Serializable
{
    private WarningsPNRB warnings;
    private ErrorsPNRB errors;
    private int choiceSelect = -1;
    private static final int RESERVATION_CHOICE = 0;
    private static final int CONTENT_CHOICE = 1;
    private ReservationPNRB reservation;
    private Element content;
    private PriceQuoteType priceQuote;
    private VCR VCR;
    private String version;

    /** 
     * Get the 'Warnings' element value.
     * 
     * @return value
     */
    public WarningsPNRB getWarnings() {
        return warnings;
    }

    /** 
     * Set the 'Warnings' element value.
     * 
     * @param warnings
     */
    public void setWarnings(WarningsPNRB warnings) {
        this.warnings = warnings;
    }

    /** 
     * Get the 'Errors' element value.
     * 
     * @return value
     */
    public ErrorsPNRB getErrors() {
        return errors;
    }

    /** 
     * Set the 'Errors' element value.
     * 
     * @param errors
     */
    public void setErrors(ErrorsPNRB errors) {
        this.errors = errors;
    }

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if Reservation is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifReservation() {
        return choiceSelect == RESERVATION_CHOICE;
    }

    /** 
     * Get the 'Reservation' element value.
     * 
     * @return value
     */
    public ReservationPNRB getReservation() {
        return reservation;
    }

    /** 
     * Set the 'Reservation' element value.
     * 
     * @param reservation
     */
    public void setReservation(ReservationPNRB reservation) {
        setChoiceSelect(RESERVATION_CHOICE);
        this.reservation = reservation;
    }

    /** 
     * Check if Content is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifContent() {
        return choiceSelect == CONTENT_CHOICE;
    }

    /** 
     * Get the 'Content' element value.
     * 
     * @return value
     */
    public Element getContent() {
        return content;
    }

    /** 
     * Set the 'Content' element value.
     * 
     * @param content
     */
    public void setContent(Element content) {
        setChoiceSelect(CONTENT_CHOICE);
        this.content = content;
    }

    /** 
     * Get the 'PriceQuote' element value.
     * 
     * @return value
     */
    public PriceQuoteType getPriceQuote() {
        return priceQuote;
    }

    /** 
     * Set the 'PriceQuote' element value.
     * 
     * @param priceQuote
     */
    public void setPriceQuote(PriceQuoteType priceQuote) {
        this.priceQuote = priceQuote;
    }

    /** 
     * Get the 'VCR' element value.
     * 
     * @return value
     */
    public VCR getVCR() {
        return VCR;
    }

    /** 
     * Set the 'VCR' element value.
     * 
     * @param VCR
     */
    public void setVCR(VCR VCR) {
        this.VCR = VCR;
    }

    /** 
     * Get the 'Version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'Version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }
}
